/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sippresence.server.subscription;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.apache.log4j.Logger;
import org.mobicents.slee.sipevent.server.publication.pojo.ComposedPublication;
import org.mobicents.slee.sipevent.server.subscription.NotifyContent;
import org.mobicents.slee.sipevent.server.subscription.pojo.Subscription;
import org.mobicents.slee.sipevent.server.subscription.pojo.SubscriptionKey;
import org.mobicents.slee.sippresence.pojo.datamodel.Person;
import org.mobicents.slee.sippresence.pojo.pidf.Presence;
import org.mobicents.slee.sippresence.pojo.rpid.Sphere;
import org.mobicents.slee.sippresence.server.subscription.PresenceSubscriptionControlSbbLocalObject;
import org.mobicents.slee.sippresence.server.subscription.rules.OMAPresRule;
import org.mobicents.slee.sippresence.server.subscription.rules.PresRuleCMPKey;
import org.mobicents.slee.sippresence.server.subscription.rules.RulesetProcessor;
import org.mobicents.slee.sippresence.server.subscription.rules.SubHandlingAction;
import org.openxdm.xcap.client.appusage.presrules.jaxb.commonpolicy.Ruleset;
import org.openxdm.xcap.common.key.AttributeUriKey;
import org.openxdm.xcap.common.key.DocumentUriKey;
import org.openxdm.xcap.common.key.ElementUriKey;
import org.openxdm.xcap.common.key.XcapUriKey;
import org.openxdm.xcap.common.uri.DocumentSelector;
import org.openxdm.xcap.common.uri.ParseException;
import org.openxdm.xcap.common.uri.Parser;

public class PresenceSubscriptionControl {
    private static Logger logger = Logger.getLogger(PresenceSubscriptionControl.class);
    private static final String[] eventPackages = new String[]{"presence"};
    private PresenceSubscriptionControlSbbLocalObject sbb;

    public PresenceSubscriptionControl(PresenceSubscriptionControlSbbLocalObject sbb) {
        this.sbb = sbb;
    }

    public static String[] getEventPackages() {
        return eventPackages;
    }

    public void isSubscriberAuthorized(String subscriber, String subscriberDisplayName, String notifier, SubscriptionKey key, int expires, String content, String contentType, String contentSubtype, String presRulesAUID, String presRulesDocumentName) {
        PresRuleCMPKey cmpKey;
        OMAPresRule combinedRule;
        HashMap<PresRuleCMPKey, OMAPresRule> combinedRules = this.sbb.getCombinedRules();
        if (combinedRules == null) {
            combinedRules = new HashMap<PresRuleCMPKey, OMAPresRule>();
        }
        if ((combinedRule = (OMAPresRule)combinedRules.get(cmpKey = new PresRuleCMPKey(subscriber, notifier, key.getEventPackage(), key.getRealEventId()))) == null) {
            for (Object keyObject : combinedRules.keySet()) {
                PresRuleCMPKey k = (PresRuleCMPKey)keyObject;
                if (!k.getSubscriber().equals(subscriber) || !k.getNotifier().equals(notifier)) continue;
                combinedRule = (OMAPresRule)combinedRules.get(k);
                combinedRules.put(cmpKey, combinedRule);
                this.sbb.setCombinedRules(combinedRules);
                break;
            }
        }
        if (combinedRule == null) {
            DocumentSelector documentSelector = this.getDocumentSelector(notifier, presRulesAUID, presRulesDocumentName);
            if (documentSelector == null) {
                this.sbb.getParentSbbCMP().newSubscriptionAuthorization(subscriber, subscriberDisplayName, notifier, key, expires, 403);
            } else {
                combinedRules.put(cmpKey, new OMAPresRule());
                this.sbb.setCombinedRules(combinedRules);
                this.sbb.getParentSbbCMP().newSubscriptionAuthorization(subscriber, subscriberDisplayName, notifier, key, expires, 202);
                this.sbb.getXDMClientControlSbb().get((XcapUriKey)new DocumentUriKey(documentSelector));
            }
        } else {
            this.sbb.getParentSbbCMP().newSubscriptionAuthorization(subscriber, subscriberDisplayName, notifier, key, expires, combinedRule.getSubHandling().getResponseCode());
        }
    }

    public void removingSubscription(Subscription subscription, String presRulesAUID, String presRulesDocumentName) {
        Map combinedRules;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("removingSubscription(" + subscription + ")"));
        }
        if ((combinedRules = this.sbb.getCombinedRules()) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("combined rules: " + combinedRules.keySet()));
            }
            if (combinedRules.remove(new PresRuleCMPKey(subscription.getSubscriber(), subscription.getNotifier(), subscription.getKey().getEventPackage(), subscription.getKey().getRealEventId())) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("removed rule from combined rules map (" + subscription + ")"));
                }
                boolean subscriptionNeeded = false;
                for (Object k : combinedRules.keySet()) {
                    PresRuleCMPKey presRuleCMPKey = (PresRuleCMPKey)k;
                    if (!presRuleCMPKey.getNotifier().equals(subscription.getNotifier()) || !presRuleCMPKey.getEventPackage().equals(subscription.getKey().getEventPackage())) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("subscription needed due to rule " + presRuleCMPKey));
                    }
                    subscriptionNeeded = true;
                    break;
                }
                if (!subscriptionNeeded) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"subscription not needed");
                    }
                    DocumentSelector documentSelector = this.getDocumentSelector(subscription.getNotifier(), presRulesAUID, presRulesDocumentName);
                    this.sbb.getXDMClientControlSbb().unsubscribeDocument(documentSelector);
                }
            }
        }
    }

    public void getResponse(XcapUriKey key, int responseCode, String mimetype, String content) {
        DocumentSelector documentSelector = null;
        if (key instanceof DocumentUriKey) {
            documentSelector = ((DocumentUriKey)key).getDocumentSelector();
        } else if (key instanceof AttributeUriKey) {
            documentSelector = ((AttributeUriKey)key).getDocumentSelector();
        } else if (key instanceof ElementUriKey) {
            documentSelector = ((ElementUriKey)key).getDocumentSelector();
        } else {
            try {
                documentSelector = Parser.parseDocumentSelector((String)key.getResourceSelector().getDocumentSelector());
            }
            catch (ParseException e) {
                logger.error((Object)"bug, a xcap uri key document selector string could not be parsed", (Throwable)e);
            }
        }
        if (responseCode == 200) {
            this.documentUpdated(documentSelector, null, null, content);
        } else {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("didn't found a pres-rules in doc at " + key.getResourceSelector()));
            }
            String notifier = this.getUser(documentSelector);
            Map combinedRules = this.sbb.getCombinedRules();
            if (combinedRules != null) {
                for (Object object : combinedRules.keySet()) {
                    PresRuleCMPKey cmpKey = (PresRuleCMPKey)object;
                    if (!cmpKey.getNotifier().equals(notifier)) continue;
                    OMAPresRule combinedRule = (OMAPresRule)combinedRules.get(cmpKey);
                    combinedRule.setProvideAllDevices(true);
                    combinedRule.setProvideAllAttributes(true);
                    combinedRule.setProvideAllPersons(true);
                    combinedRule.setProvideAllServices(true);
                    combinedRule.setSubHandling(SubHandlingAction.allow);
                    this.sbb.getParentSbbCMP().authorizationChanged(cmpKey.getSubscriber(), notifier, "presence", cmpKey.getEventId(), combinedRule.getSubHandling().getResponseCode());
                }
                this.sbb.setCombinedRules(combinedRules);
            }
        }
        this.sbb.getXDMClientControlSbb().subscribeDocument(documentSelector);
    }

    public void documentUpdated(DocumentSelector documentSelector, String oldETag, String newETag, String documentAsString) {
        if (!documentSelector.getAUID().equals("org.openmobilealliance.pres-rules") && !documentSelector.getAUID().equals("pres-rules")) {
            return;
        }
        String notifier = this.getUser(documentSelector);
        Ruleset ruleset = this.unmarshallRuleset(documentAsString);
        if (ruleset == null) {
            logger.error((Object)"rcvd ruleset update from xdm client but unmarshalling of ruleset failed, ignoring update");
            return;
        }
        HashMap<PresRuleCMPKey, OMAPresRule> combinedRules = this.sbb.getCombinedRules();
        if (combinedRules == null) {
            combinedRules = new HashMap<PresRuleCMPKey, OMAPresRule>();
        }
        for (Object key : combinedRules.keySet()) {
            PresRuleCMPKey cmpKey = (PresRuleCMPKey)key;
            if (!cmpKey.getNotifier().equals(notifier)) continue;
            OMAPresRule oldCombinedRule = (OMAPresRule)combinedRules.get(cmpKey);
            RulesetProcessor rulesetProcessor = new RulesetProcessor(cmpKey.getSubscriber(), notifier, ruleset, this.sbb);
            OMAPresRule newCombinedRule = rulesetProcessor.getCombinedRule();
            combinedRules.put(cmpKey, newCombinedRule);
            if (oldCombinedRule.getSubHandling().getResponseCode() == newCombinedRule.getSubHandling().getResponseCode()) continue;
            this.sbb.getParentSbbCMP().authorizationChanged(cmpKey.getSubscriber(), notifier, "presence", cmpKey.getEventId(), newCombinedRule.getSubHandling().getResponseCode());
        }
        this.sbb.setCombinedRules(combinedRules);
    }

    public String getSphere(String notifier) {
        ComposedPublication composedPublication = this.sbb.getPublicationChildSbb().getComposedPublication(notifier, "presence");
        if (composedPublication != null && composedPublication.getUnmarshalledContent().getValue() instanceof Presence) {
            Presence presence = (Presence)composedPublication.getUnmarshalledContent().getValue();
            for (Object anyObject : presence.getAny()) {
                JAXBElement anyElement = (JAXBElement)anyObject;
                if (!(anyElement.getValue() instanceof Person)) continue;
                Person person = (Person)anyElement.getValue();
                for (Object anotherAnyObject : person.getAny()) {
                    JAXBElement anotherAnyElement = (JAXBElement)anotherAnyObject;
                    if (!(anotherAnyElement.getValue() instanceof Sphere)) continue;
                    Sphere sphere = (Sphere)anotherAnyElement.getValue();
                    String result = null;
                    for (Object contentObject : sphere.getContent()) {
                        if (contentObject instanceof String) {
                            if (result == null) {
                                result = (String)contentObject;
                                continue;
                            }
                            result = result + " " + (String)contentObject;
                            continue;
                        }
                        if (!(contentObject instanceof JAXBElement)) continue;
                        JAXBElement contentElement = (JAXBElement)contentObject;
                        if (result == null) {
                            result = contentElement.getName().getLocalPart();
                            continue;
                        }
                        result = result + " " + contentElement.getName().getLocalPart();
                    }
                    return result;
                }
            }
        }
        return null;
    }

    public NotifyContent getNotifyContent(Subscription subscription) {
        try {
            ComposedPublication composedPublication = this.sbb.getPublicationChildSbb().getComposedPublication(subscription.getNotifier(), subscription.getKey().getEventPackage());
            if (composedPublication != null) {
                return new NotifyContent((Object)composedPublication.getUnmarshalledContent(), this.sbb.getHeaderFactory().createContentTypeHeader(composedPublication.getContentType(), composedPublication.getContentSubType()));
            }
        }
        catch (Exception e) {
            logger.error((Object)"failed to get notify content", (Throwable)e);
        }
        return null;
    }

    public Object filterContentPerSubscriber(String subscriber, String notifier, String eventPackage, Object unmarshalledContent) {
        return unmarshalledContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ruleset unmarshallRuleset(String documentAsString) {
        StringReader stringReader = new StringReader(documentAsString);
        try {
            Ruleset ruleset = (Ruleset)this.sbb.getUnmarshaller().unmarshal((Reader)stringReader);
            return ruleset;
        }
        catch (Exception e) {
            logger.error((Object)"unmarshalling of ruleset failed", (Throwable)e);
            Ruleset ruleset = null;
            return ruleset;
        }
        finally {
            stringReader.close();
        }
    }

    private DocumentSelector getDocumentSelector(String user, String presRulesAUID, String presRulesDocumentName) {
        return new DocumentSelector(presRulesAUID, "users/" + user, presRulesDocumentName);
    }

    private String getUser(DocumentSelector documentSelector) {
        return documentSelector.getDocumentParent().substring("users/".length());
    }
}

