/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.sippresence.server.subscription.rules;

import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.mobicents.slee.sippresence.server.subscription.rules.GeoPrivTransformation;
import org.mobicents.slee.sippresence.server.subscription.rules.OMAPresRule;
import org.mobicents.slee.sippresence.server.subscription.rules.PublishedSphereSource;
import org.mobicents.slee.sippresence.server.subscription.rules.SubHandlingAction;
import org.mobicents.slee.sippresence.server.subscription.rules.UnknownBooleanAttributeTransformation;
import org.mobicents.slee.sippresence.server.subscription.rules.UserInputTransformation;
import org.openxdm.xcap.client.appusage.presrules.jaxb.ProvideAllAttributes;
import org.openxdm.xcap.client.appusage.presrules.jaxb.ProvideDevicePermission;
import org.openxdm.xcap.client.appusage.presrules.jaxb.ProvidePersonPermission;
import org.openxdm.xcap.client.appusage.presrules.jaxb.ProvideServicePermission;
import org.openxdm.xcap.client.appusage.presrules.jaxb.UnknownBooleanPermission;
import org.openxdm.xcap.client.appusage.presrules.jaxb.commonpolicy.ActionsType;
import org.openxdm.xcap.client.appusage.presrules.jaxb.commonpolicy.ExceptType;
import org.openxdm.xcap.client.appusage.presrules.jaxb.commonpolicy.IdentityType;
import org.openxdm.xcap.client.appusage.presrules.jaxb.commonpolicy.ManyType;
import org.openxdm.xcap.client.appusage.presrules.jaxb.commonpolicy.OneType;
import org.openxdm.xcap.client.appusage.presrules.jaxb.commonpolicy.RuleType;
import org.openxdm.xcap.client.appusage.presrules.jaxb.commonpolicy.Ruleset;
import org.openxdm.xcap.client.appusage.presrules.jaxb.commonpolicy.SphereType;
import org.openxdm.xcap.client.appusage.presrules.jaxb.commonpolicy.TransformationsType;
import org.openxdm.xcap.client.appusage.presrules.jaxb.commonpolicy.ValidityType;

public class RulesetProcessor {
    private String subscriber;
    private String notifier;
    private PublishedSphereSource publishedSphereSource;
    private OMAPresRule combinedRule;

    public RulesetProcessor(String subscriber, String notifier, Ruleset ruleset, PublishedSphereSource publishedSphereSource) {
        this.subscriber = subscriber;
        this.notifier = notifier;
        this.publishedSphereSource = publishedSphereSource;
        this.processRuleset(ruleset);
    }

    public String getSubscriber() {
        return this.subscriber;
    }

    public OMAPresRule getCombinedRule() {
        return this.combinedRule;
    }

    private void processRuleset(Ruleset ruleset) {
        for (RuleType ruleType : ruleset.getRule()) {
            OMAPresRule omaPresRule;
            boolean permissionGranted;
            SubHandlingAction subHandling = this.processActions(ruleType);
            if (subHandling == null || !(permissionGranted = this.processConditions(ruleType)) || (omaPresRule = this.processTransformations(ruleType)) == null) continue;
            omaPresRule.setSubHandling(subHandling);
            if (this.combinedRule == null) {
                this.combinedRule = omaPresRule;
                continue;
            }
            this.combinedRule.combine(omaPresRule);
        }
        if (this.combinedRule == null) {
            this.combinedRule = new OMAPresRule();
        }
    }

    private SubHandlingAction processActions(RuleType ruleType) {
        JAXBElement element;
        List anys;
        ActionsType actionsType = ruleType.getActions();
        if (actionsType != null && (anys = actionsType.getAny()).size() == 1 && anys.get(0) instanceof JAXBElement && (element = (JAXBElement)anys.get(0)).getName().getLocalPart().equals("sub-handling")) {
            String subHandlingValue = (String)element.getValue();
            if (subHandlingValue.equals("allow") || subHandlingValue.equals("30")) {
                return SubHandlingAction.allow;
            }
            if (subHandlingValue.equals("polite-block") || subHandlingValue.equals("20")) {
                return SubHandlingAction.politeblock;
            }
            if (subHandlingValue.equals("confirm") || subHandlingValue.equals("10")) {
                return SubHandlingAction.confirm;
            }
            if (subHandlingValue.equals("block") || subHandlingValue.equals("0")) {
                return SubHandlingAction.block;
            }
        }
        return null;
    }

    private boolean processConditions(RuleType ruleType) {
        String subscriberDomain = null;
        List identityOrSphereOrValidityObjectList = ruleType.getConditions().getIdentityOrSphereOrValidity();
        if (identityOrSphereOrValidityObjectList.isEmpty()) {
            return false;
        }
        for (Object identityOrSphereOrValidityObject : identityOrSphereOrValidityObjectList) {
            JAXBElement identityOrSphereOrValidity = (JAXBElement)identityOrSphereOrValidityObject;
            if (identityOrSphereOrValidity.getValue() instanceof IdentityType) {
                IdentityType identityType = (IdentityType)identityOrSphereOrValidity.getValue();
                boolean idPermission = false;
                for (Object oneOrManyOrAnyObject : identityType.getOneOrManyOrAny()) {
                    int i;
                    JAXBElement oneOrManyOrAny = (JAXBElement)oneOrManyOrAnyObject;
                    if (oneOrManyOrAny.getValue() instanceof OneType) {
                        OneType oneType = (OneType)oneOrManyOrAny.getValue();
                        if (!this.subscriber.equals(oneType.getId())) continue;
                        idPermission = true;
                        break;
                    }
                    if (!(oneOrManyOrAny.getValue() instanceof ManyType)) continue;
                    ManyType manyType = (ManyType)oneOrManyOrAny.getValue();
                    if (subscriberDomain == null && (i = this.subscriber.indexOf(64)) > 0) {
                        subscriberDomain = this.subscriber.substring(i + 1);
                    }
                    if (manyType.getDomain() != null && !this.domainsMatch(subscriberDomain, manyType.getDomain())) continue;
                    boolean exceptNotFound = true;
                    for (Object exceptOrAnyObject : manyType.getExceptOrAny()) {
                        JAXBElement exceptOrAny = (JAXBElement)exceptOrAnyObject;
                        if (!(exceptOrAny.getValue() instanceof ExceptType)) continue;
                        ExceptType exceptType = (ExceptType)exceptOrAny.getValue();
                        if (this.subscriber.equals(exceptType.getId())) {
                            exceptNotFound = false;
                            break;
                        }
                        if (!this.domainsMatch(subscriberDomain, exceptType.getDomain())) continue;
                        exceptNotFound = false;
                        break;
                    }
                    if (!exceptNotFound) continue;
                    idPermission = true;
                    break;
                }
                if (idPermission) continue;
                return false;
            }
            if (identityOrSphereOrValidity.getValue() instanceof SphereType) {
                SphereType sphereType = (SphereType)identityOrSphereOrValidity.getValue();
                String sphere = this.publishedSphereSource.getSphere(this.notifier);
                if (sphereType.getValue() != null && !this.spheresMatch(sphere, sphereType.getValue())) continue;
                return false;
            }
            if (!(identityOrSphereOrValidity.getValue() instanceof ValidityType)) continue;
            ValidityType validityType = (ValidityType)identityOrSphereOrValidity.getValue();
            if (validityType.getFromAndUntil().size() % 2 == 0) {
                // empty if block
            }
            boolean valid = false;
            XMLGregorianCalendar calendar = null;
            try {
                calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
            }
            catch (DatatypeConfigurationException e) {
                System.err.println("Failed to create calendar to verify pres-rules condition validity");
                e.printStackTrace();
            }
            if (calendar != null) {
                Iterator iterator = validityType.getFromAndUntil().iterator();
                while (iterator.hasNext()) {
                    JAXBElement fromElement = (JAXBElement)iterator.next();
                    JAXBElement untilElement = (JAXBElement)iterator.next();
                    if (fromElement.getName().getLocalPart().equals("from") && untilElement.getName().getLocalPart().equals("until")) {
                        if (((XMLGregorianCalendar)fromElement.getValue()).compare(calendar) >= 1 || ((XMLGregorianCalendar)untilElement.getValue()).compare(calendar) <= -1) continue;
                        valid = true;
                        break;
                    }
                    valid = false;
                    break;
                }
            }
            if (valid) continue;
            return false;
        }
        return true;
    }

    private OMAPresRule processTransformations(RuleType ruleType) {
        TransformationsType transformationsType = ruleType.getTransformations();
        if (transformationsType != null) {
            OMAPresRule rule = new OMAPresRule();
            for (Object transformationObject : transformationsType.getAny()) {
                if (transformationObject instanceof ProvideAllAttributes) {
                    rule.setProvideAllAttributes(true);
                    continue;
                }
                if (!(transformationObject instanceof JAXBElement)) continue;
                JAXBElement element = (JAXBElement)transformationObject;
                if (element.getName().getNamespaceURI().equals("urn:oma:xml:prs:pres-rules")) {
                    if (element.getName().getLocalPart().equals("provide-registration-state")) {
                        rule.setProvideRegistrationState((Boolean)element.getValue());
                        continue;
                    }
                    if (element.getName().getLocalPart().equals("provide-network-availability")) {
                        rule.setProvideNetworkAvailability((Boolean)element.getValue());
                        continue;
                    }
                    if (element.getName().getLocalPart().equals("provide-willingness")) {
                        rule.setProvideWillingness((Boolean)element.getValue());
                        continue;
                    }
                    if (element.getName().getLocalPart().equals("provide-barring-state")) {
                        rule.setProvideBarringState((Boolean)element.getValue());
                        continue;
                    }
                    if (element.getName().getLocalPart().equals("provide-session-participation")) {
                        rule.setProvideSessionParticipation((Boolean)element.getValue());
                        continue;
                    }
                    if (element.getName().getLocalPart().equals("service-id")) {
                        rule.getServiceIDs().add((String)element.getValue());
                        continue;
                    }
                    if (!element.getName().getLocalPart().equals("provide-geopriv")) continue;
                    try {
                        rule.setProvideGeopriv(GeoPrivTransformation.valueOf((String)element.getValue()));
                    }
                    catch (Exception e) {
                        System.err.println("Failed to parse provide-geopriv value in transformation");
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!element.getName().getNamespaceURI().equals("urn:ietf:params:xml:ns:pres-rules")) continue;
                if (element.getName().getLocalPart().equals("provide-devices")) {
                    rule.processDevicePermission((ProvideDevicePermission)element.getValue());
                    continue;
                }
                if (element.getName().getLocalPart().equals("provide-persons")) {
                    rule.processPersonPermission((ProvidePersonPermission)element.getValue());
                    continue;
                }
                if (element.getName().getLocalPart().equals("provide-services")) {
                    rule.processServicePermission((ProvideServicePermission)element.getValue());
                    continue;
                }
                if (element.getName().getLocalPart().equals("provide-unknown-attribute")) {
                    UnknownBooleanPermission unknownBooleanPermission = (UnknownBooleanPermission)element.getValue();
                    rule.getUnknownBooleanAttributes().add(new UnknownBooleanAttributeTransformation(unknownBooleanPermission.getName(), unknownBooleanPermission.getNs()));
                    continue;
                }
                if (element.getName().getLocalPart().equals("provide-place-is")) {
                    rule.setProvidePlaceIs((Boolean)element.getValue());
                    continue;
                }
                if (element.getName().getLocalPart().equals("provide-privacy")) {
                    rule.setProvidePrivacy((Boolean)element.getValue());
                    continue;
                }
                if (element.getName().getLocalPart().equals("provide-class")) {
                    rule.setProvideClass((Boolean)element.getValue());
                    continue;
                }
                if (element.getName().getLocalPart().equals("provide-place-type")) {
                    rule.setProvidePlaceType((Boolean)element.getValue());
                    continue;
                }
                if (element.getName().getLocalPart().equals("provide-relationship")) {
                    rule.setProvideRelationship((Boolean)element.getValue());
                    continue;
                }
                if (element.getName().getLocalPart().equals("provide-mood")) {
                    rule.setProvideMood((Boolean)element.getValue());
                    continue;
                }
                if (element.getName().getLocalPart().equals("provide-activities")) {
                    rule.setProvideActivities((Boolean)element.getValue());
                    continue;
                }
                if (element.getName().getLocalPart().equals("provide-sphere")) {
                    rule.setProvideSphere((Boolean)element.getValue());
                    continue;
                }
                if (element.getName().getLocalPart().equals("provide-user-input")) {
                    try {
                        rule.setProvideUserInput(UserInputTransformation.valueOf((String)element.getValue()));
                    }
                    catch (Exception e) {
                        System.err.println("Failed to parse provide-user-input value in transformation");
                        e.printStackTrace();
                    }
                    continue;
                }
                if (element.getName().getLocalPart().equals("provide-time-offset")) {
                    rule.setProvideTimeOffset((Boolean)element.getValue());
                    continue;
                }
                if (element.getName().getLocalPart().equals("provide-note")) {
                    rule.setProvideNote((Boolean)element.getValue());
                    continue;
                }
                if (element.getName().getLocalPart().equals("provide-deviceID")) {
                    rule.setProvideDeviceID((Boolean)element.getValue());
                    continue;
                }
                if (!element.getName().getLocalPart().equals("provide-status-icon")) continue;
                rule.setProvideStatusIcon((Boolean)element.getValue());
            }
            return rule;
        }
        return null;
    }

    private boolean domainsMatch(String domain, String conditionDomain) {
        return domain.equals(conditionDomain);
    }

    private boolean spheresMatch(String sphere, String conditionSphere) {
        String[] conditionSphereTokens;
        for (String conditionSphereToken : conditionSphereTokens = conditionSphere.split(" ")) {
            if (!conditionSphereToken.equalsIgnoreCase(sphere)) continue;
            return true;
        }
        return false;
    }
}

