/*
 * Decompiled with CFR 0.152.
 */
package org.openxdm.xcap.client;

import java.io.IOException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxdm.xcap.client.Response;
import org.openxdm.xcap.client.XCAPClient;
import org.openxdm.xcap.common.key.XcapUriKey;

public class XCAPClientImpl
implements XCAPClient {
    private static final Log log = LogFactory.getLog(XCAPClientImpl.class);
    private HttpClient client;
    private String xcapRoot;

    public XCAPClientImpl(String host, int port, String xcapRoot) throws InterruptedException {
        this.xcapRoot = xcapRoot;
        this.client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this.client.getHostConfiguration().setHost(host, port, "http");
        this.client.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        this.client.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
    }

    public void shutdown() {
        log.info((Object)"shutdown()");
        if (this.client != null) {
            ((MultiThreadedHttpConnectionManager)this.client.getHttpConnectionManager()).shutdown();
        }
    }

    private String addXcapRoot(String path) {
        return this.xcapRoot + path;
    }

    private Response getResponse(XcapUriKey key, HttpMethod method) throws IOException {
        int statusCode = method.getStatusCode();
        Header[] headers = method.getResponseHeaders();
        String content = null;
        String eTag = null;
        if (statusCode == 200 || statusCode == 201) {
            content = method.getResponseBodyAsString();
            Header eTagHeader = method.getResponseHeader("ETag");
            if (eTagHeader != null) {
                eTag = eTagHeader.getValue();
            }
        } else if (statusCode == 409) {
            content = method.getResponseBodyAsString();
        }
        Response response = new Response(statusCode, eTag, headers, content);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received:\n--BEGIN--\n" + response.toString() + "\n--END--"));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response get(XcapUriKey key) throws HttpException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("get(key=" + key + ")"));
        }
        Response response = null;
        GetMethod get = new GetMethod(this.addXcapRoot(key.toString()));
        try {
            this.client.executeMethod((HttpMethod)get);
            response = this.getResponse(key, (HttpMethod)get);
        }
        finally {
            get.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response put(XcapUriKey key, String mimetype, String content) throws HttpException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("put(key=" + key + ", mimetype=" + mimetype + ", content=" + content + ")"));
        }
        Response response = null;
        PutMethod put = new PutMethod(this.addXcapRoot(key.toString()));
        put.setRequestHeader("Content-Type", mimetype);
        put.setRequestEntity((RequestEntity)new StringRequestEntity(content));
        try {
            this.client.executeMethod((HttpMethod)put);
            response = this.getResponse(key, (HttpMethod)put);
        }
        finally {
            put.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response putIfMatch(XcapUriKey key, String eTag, String mimetype, String content) throws HttpException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("putIfMatch(key=" + key + ", eTag=" + eTag + ", mimetype=" + mimetype + ", content=" + content + ")"));
        }
        Response response = null;
        PutMethod put = new PutMethod(this.addXcapRoot(key.toString()));
        put.setRequestHeader("Content-Type", mimetype);
        put.setRequestHeader("If-Match", eTag);
        put.setRequestEntity((RequestEntity)new StringRequestEntity(content));
        try {
            this.client.executeMethod((HttpMethod)put);
            response = this.getResponse(key, (HttpMethod)put);
        }
        finally {
            put.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response putIfNoneMatch(XcapUriKey key, String eTag, String mimetype, String content) throws HttpException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("putIfNoneMatch(key=" + key + ", eTag=" + eTag + ", mimetype=" + mimetype + ", content=" + content + ")"));
        }
        Response response = null;
        PutMethod put = new PutMethod(this.addXcapRoot(key.toString()));
        put.setRequestHeader("Content-Type", mimetype);
        put.setRequestHeader("If-None-Match", eTag);
        put.setRequestEntity((RequestEntity)new StringRequestEntity(content));
        try {
            this.client.executeMethod((HttpMethod)put);
            response = this.getResponse(key, (HttpMethod)put);
        }
        finally {
            put.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response put(XcapUriKey key, String mimetype, byte[] content) throws HttpException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("put(key=" + key + ", mimetype=" + mimetype + ", content=" + content + ")"));
        }
        Response response = null;
        PutMethod put = new PutMethod(this.addXcapRoot(key.toString()));
        put.setRequestHeader("Content-Type", mimetype);
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(content));
        try {
            this.client.executeMethod((HttpMethod)put);
            response = this.getResponse(key, (HttpMethod)put);
        }
        finally {
            put.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response putIfMatch(XcapUriKey key, String eTag, String mimetype, byte[] content) throws HttpException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("putIfMatch(key=" + key + ", eTag=" + eTag + ", mimetype=" + mimetype + ", content=" + content + ")"));
        }
        Response response = null;
        PutMethod put = new PutMethod(this.addXcapRoot(key.toString()));
        put.setRequestHeader("Content-Type", mimetype);
        put.setRequestHeader("If-Match", eTag);
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(content));
        try {
            this.client.executeMethod((HttpMethod)put);
            response = this.getResponse(key, (HttpMethod)put);
        }
        finally {
            put.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response putIfNoneMatch(XcapUriKey key, String eTag, String mimetype, byte[] content) throws HttpException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("putIfNoneMatch(key=" + key + ", eTag=" + eTag + ", mimetype=" + mimetype + ", content=" + content + ")"));
        }
        Response response = null;
        PutMethod put = new PutMethod(this.addXcapRoot(key.toString()));
        put.setRequestHeader("Content-Type", mimetype);
        put.setRequestHeader("If-None-Match", eTag);
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(content));
        try {
            this.client.executeMethod((HttpMethod)put);
            response = this.getResponse(key, (HttpMethod)put);
        }
        finally {
            put.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response delete(XcapUriKey key) throws HttpException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("delete(key=" + key + ")"));
        }
        Response response = null;
        DeleteMethod delete = new DeleteMethod(this.addXcapRoot(key.toString()));
        try {
            this.client.executeMethod((HttpMethod)delete);
            response = this.getResponse(key, (HttpMethod)delete);
        }
        finally {
            delete.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response deleteIfMatch(XcapUriKey key, String eTag) throws HttpException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteIfMatch(key=" + key + ", eTag=" + eTag + ")"));
        }
        Response response = null;
        DeleteMethod delete = new DeleteMethod(this.addXcapRoot(key.toString()));
        try {
            delete.setRequestHeader("If-Match", eTag);
            this.client.executeMethod((HttpMethod)delete);
            response = this.getResponse(key, (HttpMethod)delete);
        }
        finally {
            delete.releaseConnection();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response deleteIfNoneMatch(XcapUriKey key, String eTag) throws HttpException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("deleteIfNoneMatch(key=" + key + ", eTag=" + eTag + ")"));
        }
        Response response = null;
        DeleteMethod delete = new DeleteMethod(this.addXcapRoot(key.toString()));
        try {
            delete.setRequestHeader("If-None-Match", eTag);
            this.client.executeMethod((HttpMethod)delete);
            response = this.getResponse(key, (HttpMethod)delete);
        }
        finally {
            delete.releaseConnection();
        }
        return response;
    }
}

