/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.example.xcapclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.SLEEException;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.TransactionRolledbackLocalException;
import javax.slee.UnrecognizedActivityException;
import javax.slee.resource.ActivityAlreadyExistsException;
import javax.slee.resource.CouldNotStartActivityException;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceActivityFactory;
import javax.slee.serviceactivity.ServiceStartedEvent;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.commons.httpclient.HttpException;
import org.apache.log4j.Logger;
import org.mobicents.slee.resource.xcapclient.AsyncActivity;
import org.mobicents.slee.resource.xcapclient.ResponseEvent;
import org.mobicents.slee.resource.xcapclient.XCAPClientActivityContextInterfaceFactory;
import org.mobicents.slee.resource.xcapclient.XCAPClientResourceAdaptorSbbInterface;
import org.openxdm.xcap.client.Response;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.EntryType;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.ListType;
import org.openxdm.xcap.client.appusage.resourcelists.jaxb.ObjectFactory;
import org.openxdm.xcap.client.appusage.resourcelists.key.ResourceListsUserElementUriKey;
import org.openxdm.xcap.common.key.UserDocumentUriKey;
import org.openxdm.xcap.common.key.UserElementUriKey;
import org.openxdm.xcap.common.key.XcapUriKey;
import org.openxdm.xcap.common.uri.ElementSelector;
import org.openxdm.xcap.common.uri.ElementSelectorStep;
import org.openxdm.xcap.common.uri.ElementSelectorStepByAttr;
import org.openxdm.xcap.common.xml.XMLValidator;

public abstract class XCAPClientExampleSbb
implements Sbb {
    private SbbContext sbbContext = null;
    private static JAXBContext jAXBContext = XCAPClientExampleSbb.initJAXBContext();
    private Context myEnv = null;
    private XCAPClientResourceAdaptorSbbInterface ra = null;
    private XCAPClientActivityContextInterfaceFactory acif = null;
    private String userName = "sip:bob@example.com";
    private String documentName = "index";
    private static Logger log = Logger.getLogger(XCAPClientExampleSbb.class);

    private static JAXBContext initJAXBContext() {
        try {
            return JAXBContext.newInstance((String)"org.openxdm.xcap.client.appusage.resourcelists.jaxb");
        }
        catch (JAXBException e) {
            log.error((Object)"unable to init jaxb context", (Throwable)e);
            return null;
        }
    }

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
        try {
            this.myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.ra = (XCAPClientResourceAdaptorSbbInterface)this.myEnv.lookup("slee/resources/xcapclient/1.0/sbbrainterface");
            this.acif = (XCAPClientActivityContextInterfaceFactory)this.myEnv.lookup("slee/resources/xcapclient/1.0/acif");
        }
        catch (NamingException e) {
            log.error((Object)"unable to set sbb context", (Throwable)e);
        }
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    protected SbbContext getSbbContext() {
        return this.sbbContext;
    }

    public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
        try {
            ServiceActivity sa = ((ServiceActivityFactory)this.myEnv.lookup("slee/serviceactivity/factory")).getActivity();
            if (sa.equals(aci.getActivity())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"service started...");
                }
                try {
                    this.syncTest();
                    this.asyncTest();
                }
                catch (Exception f) {
                    log.error((Object)"sync test failed...", (Throwable)f);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"unable to handle service started event...", (Throwable)e);
        }
    }

    public void syncTest() throws HttpException, IOException, JAXBException {
        UserDocumentUriKey docKey = new UserDocumentUriKey("resource-lists", this.userName, this.documentName);
        String initialDocument = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><resource-lists xmlns=\"urn:ietf:params:xml:ns:resource-lists\"><list name=\"friends\"/></resource-lists>";
        String element = "<entry uri=\"sip:alice@example.com\" xmlns=\"urn:ietf:params:xml:ns:resource-lists\"/>";
        String finalDocument = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><resource-lists xmlns=\"urn:ietf:params:xml:ns:resource-lists\"><list name=\"friends\">" + element + "</list>" + "</resource-lists>";
        Response response = this.ra.put((XcapUriKey)docKey, "application/resource-lists+xml", initialDocument, null);
        if (response != null) {
            if (response.getCode() == 200 || response.getCode() == 201) {
                log.info((Object)"document created in xcap server...");
            } else {
                log.error((Object)("bad response from xcap server: " + response.toString()));
            }
        } else {
            log.error((Object)"unable to create document in xcap server...");
        }
        LinkedList<Object> elementSelectorSteps = new LinkedList<Object>();
        ElementSelectorStep step1 = new ElementSelectorStep("resource-lists");
        ElementSelectorStepByAttr step2 = new ElementSelectorStepByAttr("list", "name", "friends");
        ElementSelectorStepByAttr step3 = new ElementSelectorStepByAttr("entry", "uri", "sip:alice@example.com");
        elementSelectorSteps.add(step1);
        elementSelectorSteps.addLast(step2);
        elementSelectorSteps.addLast(step3);
        UserElementUriKey elemKey = new UserElementUriKey("resource-lists", this.userName, this.documentName, new ElementSelector(elementSelectorSteps), null);
        response = this.ra.put((XcapUriKey)elemKey, "application/xcap-el+xml", element, null);
        if (response != null) {
            if (response.getCode() == 201) {
                log.info((Object)"element created in xcap server...");
            } else {
                log.error((Object)("bad response from xcap server: " + response.toString()));
            }
        } else {
            log.error((Object)"unable to create element in xcap server...");
        }
        response = this.ra.get((XcapUriKey)docKey, null);
        if (response != null) {
            if (response.getCode() == 200 && XMLValidator.weaklyEquals((String)response.getContent(), (String)finalDocument)) {
                log.info((Object)"document retreived in xcap server and content is the expected...");
                log.info((Object)"sync test suceed :)");
            } else {
                log.error((Object)("bad response from xcap server: " + response.toString()));
            }
        } else {
            log.error((Object)"unable to retreive document in xcap server...");
        }
    }

    public void asyncTest() throws ActivityAlreadyExistsException, CouldNotStartActivityException, NullPointerException, UnrecognizedActivityException, TransactionRequiredLocalException, TransactionRolledbackLocalException, HttpException, SLEEException, IllegalStateException, JAXBException, IOException {
        ObjectFactory of = new ObjectFactory();
        ListType listType = of.createListType();
        listType.setName("enemies");
        EntryType entry = of.createEntryType();
        entry.setUri("sip:winniethepooh@disney.com");
        listType.getListOrExternalOrEntry().add(entry);
        LinkedList<Object> elementSelectorSteps = new LinkedList<Object>();
        ElementSelectorStep step1 = new ElementSelectorStep("resource-lists");
        ElementSelectorStepByAttr step2 = new ElementSelectorStepByAttr("list", "name", "enemies");
        elementSelectorSteps.add(step1);
        elementSelectorSteps.addLast(step2);
        ResourceListsUserElementUriKey key = new ResourceListsUserElementUriKey(this.userName, this.documentName, new ElementSelector(elementSelectorSteps), null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        jAXBContext.createMarshaller().marshal((Object)listType, (OutputStream)baos);
        Response response = this.ra.put((XcapUriKey)key, "application/xcap-el+xml", baos.toByteArray(), null);
        if (response != null) {
            if (response.getCode() == 201) {
                log.info((Object)"list element created in xcap server...");
            } else {
                log.error((Object)("bad response from xcap server: " + response.toString()));
            }
        } else {
            log.error((Object)"unable to create list element in xcap server...");
        }
        AsyncActivity activity = this.ra.createActivity();
        ActivityContextInterface aci = this.acif.getActivityContextInterface(activity);
        aci.attach(this.sbbContext.getSbbLocalObject());
        activity.get((XcapUriKey)key, null);
    }

    public void onResponseEvent(ResponseEvent event, ActivityContextInterface aci) {
        log.info((Object)("onResponseEvent(event=" + event + ",aci=" + aci + ")"));
        Response response = event.getResponse();
        if (response != null) {
            if (response.getCode() == 200) {
                log.info((Object)"list element retreived from xcap server...");
                StringReader stringReader = new StringReader(response.getContent());
                ListType listType = null;
                try {
                    listType = (ListType)jAXBContext.createUnmarshaller().unmarshal((Reader)stringReader);
                }
                catch (Exception e) {
                    log.error((Object)"unable to unmarshall response content", (Throwable)e);
                }
                stringReader.close();
                if (listType != null && listType.getName().equals("enemies")) {
                    List list = listType.getListOrExternalOrEntry();
                    if (list.size() == 1) {
                        EntryType entry = (EntryType)((JAXBElement)list.get(0)).getValue();
                        if (entry.getUri().equals("sip:winniethepooh@disney.com")) {
                            log.info((Object)"async test suceed :)");
                        } else {
                            log.error((Object)"list element retreived is not the expected one");
                        }
                    } else {
                        log.error((Object)"list element retreived is not the expected one");
                    }
                } else {
                    log.error((Object)"list element retreived is not the expected one");
                }
            } else {
                log.error((Object)("bad response from xcap server: " + response.toString()));
            }
        } else {
            log.error((Object)"unable to create list element in xcap server...");
        }
        try {
            this.ra.delete((XcapUriKey)new UserDocumentUriKey("resource-lists", this.userName, this.documentName), null);
        }
        catch (Exception e) {
            log.error((Object)"failed to delete document", (Throwable)e);
        }
        AsyncActivity activity = (AsyncActivity)aci.getActivity();
        if (activity != null) {
            activity.endActivity();
        }
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        try {
            ServiceActivity sa = ((ServiceActivityFactory)this.myEnv.lookup("slee/serviceactivity/factory")).getActivity();
            if (sa.equals(aci.getActivity()) && log.isDebugEnabled()) {
                log.debug((Object)"service deactivated...");
            }
        }
        catch (Exception e) {
            log.error((Object)"unable to handle activity end event...", (Throwable)e);
        }
    }
}

