/*
 * RtpTrafficDialog.java
 *
 * Created on 4 Декабрь 2008 г., 10:33
 */
package org.mobicents.media.server.testsuite.gui.graph;

import org.mobicents.media.server.testsuite.general.AbstractCall;
import org.mobicents.media.server.testsuite.general.rtp.PacketTableModel;



/**
 *
 * @author  kulikov
 */
public class RtpTrafficDialog extends javax.swing.JDialog {

    /** A return status code - returned if Cancel button has been pressed */
    public static final int RET_CANCEL = 0;
    /** A return status code - returned if OK button has been pressed */
    public static final int RET_OK = 1;
    private AbstractCall call;

    /** Creates new form RtpTrafficDialog */
    public RtpTrafficDialog(java.awt.Frame parent, boolean modal, AbstractCall call) {
        super(parent, modal);
        this.call = call;
        initComponents();
        int[] errors = new int[100];
        try {
            PacketTableModel model = new PacketTableModel(call.getRtp());
            packetTable.setModel(model);
            //int errorCount = call.getOutofSequence(errors);
            //FIXME
            int errorCount =0;
            stats.setText("Out of sequence packets=" + errorCount +
                    ", Average jitter=" + call.getAvgJitter());
            printErrors(errors, errorCount);
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printErrors(int[] errors, int count) {
        for (int i = 0; i < count; i++) {
            System.out.println(errors[i]);
        }
    }
    /** @return the return status of this dialog - one of RET_OK or RET_CANCEL */
    public int getReturnStatus() {
        return returnStatus;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        closeButton = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        packetTable = new javax.swing.JTable();
        jPanel3 = new javax.swing.JPanel();
        stats = new javax.swing.JLabel();

        setTitle("RTP Traffic");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jPanel1.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        jButton1.setText("Graph");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        jPanel1.add(jButton1);

        closeButton.setText("Close");
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });
        jPanel1.add(closeButton);

        getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);

        jPanel2.setLayout(new java.awt.BorderLayout());

        packetTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane1.setViewportView(packetTable);

        jPanel2.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        jPanel3.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        stats.setText("Stats");
        jPanel3.add(stats);

        jPanel2.add(jPanel3, java.awt.BorderLayout.SOUTH);

        getContentPane().add(jPanel2, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /** Closes the dialog */ 
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        doClose(RET_CANCEL);
    }//GEN-LAST:event_closeDialog

private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonActionPerformed
    doClose(RET_OK);
}//GEN-LAST:event_closeButtonActionPerformed

private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
    try {
        RtpTrafficGraph g = new RtpTrafficGraph(null, true, call);
        g.setVisible(true);
    } catch (Exception e) {
        e.printStackTrace();
    }
}//GEN-LAST:event_jButton1ActionPerformed

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        setVisible(false);
        dispose();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton closeButton;
    private javax.swing.JButton jButton1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable packetTable;
    private javax.swing.JLabel stats;
    // End of variables declaration//GEN-END:variables

    private int returnStatus = RET_CANCEL;
}
