/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.testsuite.general;

import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import javax.sdp.Attribute;
import javax.sdp.MediaDescription;
import javax.sdp.SdpException;
import javax.sdp.SdpFactory;
import javax.sdp.SessionDescription;
import org.apache.log4j.Logger;
import org.mobicents.media.server.testsuite.general.AbstractTestCase;
import org.mobicents.media.server.testsuite.general.CallState;
import org.mobicents.media.server.testsuite.general.rtp.RtpPacket;
import org.mobicents.mgcp.stack.JainMgcpExtendedListener;
import org.mobicents.mgcp.stack.JainMgcpStackProviderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCall
implements JainMgcpExtendedListener,
Runnable,
Serializable {
    protected transient Logger logger;
    public static final int _READ_PERIOD = 20;
    protected static final transient AtomicLong _GLOBAL_SEQ = new AtomicLong(-1L);
    protected final long sequence;
    protected CallState state;
    protected int avgJitter;
    protected int peakJitter;
    protected long lastDeliverTimeStamp;
    protected transient File dataFileName;
    protected transient FileOutputStream fos;
    protected transient ObjectOutputStream dataDumpChannel;
    protected transient List<RtpPacket> rtpTraffic;
    protected String endpointName;
    protected EndpointIdentifier endpointIdentifier;
    protected CallIdentifier callIdentifier;
    protected transient AbstractTestCase testCase;
    protected transient DatagramChannel datagramChannel;
    protected final transient ScheduledExecutorService readerThread;
    protected transient ScheduledFuture readerTask;
    protected transient boolean receiveRTP;
    protected transient JainMgcpStackProviderImpl provider;
    protected transient ScheduledFuture<?> timeoutHandle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCall(AbstractTestCase testCase) throws IOException {
        block13: {
            this.logger = Logger.getLogger(AbstractCall.class);
            this.state = CallState.INITIAL;
            this.rtpTraffic = new ArrayList<RtpPacket>();
            this.endpointName = "";
            this.readerThread = Executors.newSingleThreadScheduledExecutor();
            this.timeoutHandle = null;
            this.testCase = testCase;
            this.callIdentifier = testCase.getProvider().getUniqueCallIdentifier();
            boolean finished = false;
            try {
                this.sequence = _GLOBAL_SEQ.incrementAndGet();
                this.setDumpDir(this.testCase.getTestDumpDirectory());
                this.fos = new FileOutputStream(this.dataFileName);
                this.dataDumpChannel = new ObjectOutputStream(this.fos);
                this.provider = testCase.getProvider();
                finished = true;
                Object var4_3 = null;
                if (finished) break block13;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (!finished) {
                    try {
                        if (this.datagramChannel.isConnected() || this.datagramChannel.isOpen()) {
                            this.datagramChannel.close();
                        }
                        this.datagramChannel = null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (this.dataDumpChannel != null) {
                            this.dataDumpChannel.close();
                        }
                        this.dataDumpChannel = null;
                        this.fos = null;
                    }
                    catch (Exception e) {
                        this.logger.error((Object)e);
                    }
                }
                throw throwable;
            }
            try {
                if (this.datagramChannel.isConnected() || this.datagramChannel.isOpen()) {
                    this.datagramChannel.close();
                }
                this.datagramChannel = null;
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.dataDumpChannel != null) {
                    this.dataDumpChannel.close();
                }
                this.dataDumpChannel = null;
                this.fos = null;
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
    }

    void setDumpDir(File testDumpDirectory) {
        this.dataFileName = new File(testDumpDirectory, this.sequence + ".rtp");
    }

    protected void initSocket() throws IOException {
        this.datagramChannel = DatagramChannel.open();
        this.datagramChannel.configureBlocking(false);
        DatagramSocket socket = this.datagramChannel.socket();
        InetAddress bindAddress = this.testCase.getClientTestNodeAddress();
        for (int i = 1024; i < 65535; ++i) {
            try {
                InetSocketAddress address = new InetSocketAddress(bindAddress, i);
                socket.bind(address);
                this.logger.debug((Object)("Socket created port = " + socket.getLocalPort() + " address = " + socket.getLocalAddress()));
                return;
            }
            catch (SocketException e) {
                continue;
            }
        }
        throw new SocketException();
    }

    public List<RtpPacket> getRtp() throws IOException {
        List<RtpPacket> ll = this.loadRtp();
        return ll;
    }

    private List<RtpPacket> loadRtp() throws IOException {
        ArrayList<RtpPacket> list = new ArrayList<RtpPacket>();
        FileInputStream fin = new FileInputStream(this.dataFileName);
        ObjectInputStream in = new ObjectInputStream(fin);
        while (fin.available() > 0) {
            try {
                RtpPacket p = (RtpPacket)in.readObject();
                list.add(p);
            }
            catch (ClassNotFoundException e) {}
        }
        return list;
    }

    public CallState getState() {
        return this.state;
    }

    public int getAvgJitter() {
        return this.avgJitter;
    }

    public int getPeakJitter() {
        return this.peakJitter;
    }

    public EndpointIdentifier getEndpoint() {
        return this.endpointIdentifier;
    }

    public CallIdentifier getCallID() {
        return this.callIdentifier;
    }

    public long getSequence() {
        return this.sequence;
    }

    protected void setState(CallState state) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Dumping data to file. State = " + (Object)((Object)state)));
        }
        if (state == this.state) {
            return;
        }
        this.state = state;
        switch (this.state) {
            case ENDED: 
            case IN_ERROR: 
            case TIMED_OUT: {
                this.receiveRTP = false;
                try {
                    if (this.datagramChannel.isConnected() || this.datagramChannel.isOpen()) {
                        this.datagramChannel.close();
                    }
                    this.datagramChannel = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
                for (int index = 0; index < this.rtpTraffic.size(); ++index) {
                    RtpPacket packet = this.rtpTraffic.remove(0);
                    try {
                        this.dataDumpChannel.writeObject(packet);
                        continue;
                    }
                    catch (IOException ex) {
                        this.logger.error((Object)ex);
                    }
                }
                this.rtpTraffic = null;
                try {
                    if (this.dataDumpChannel != null) {
                        this.dataDumpChannel.close();
                    }
                    this.dataDumpChannel = null;
                    this.fos = null;
                }
                catch (Exception exception) {}
                break;
            }
        }
        this.testCase.callStateChanged(this);
    }

    protected String getLocalDescriptor(int port) {
        long sessionID;
        SessionDescription localSDP = null;
        String userName = "Mobicents-Call-Generator";
        long sessionVersion = sessionID = System.currentTimeMillis() & 0xFFFFFFL;
        String networkType = "IN";
        String addressType = "IP4";
        SdpFactory sdpFactory = this.testCase.getSdpFactory();
        try {
            localSDP = sdpFactory.createSessionDescription();
            localSDP.setVersion(sdpFactory.createVersion(0));
            localSDP.setOrigin(sdpFactory.createOrigin(userName, sessionID, sessionVersion, networkType, addressType, this.testCase.getClientTestNodeAddress().getHostAddress()));
            localSDP.setSessionName(sdpFactory.createSessionName("session"));
            localSDP.setConnection(sdpFactory.createConnection(networkType, addressType, this.testCase.getClientTestNodeAddress().getHostAddress()));
            Vector<Attribute> attributes = this.testCase.getSDPAttributes();
            int[] audioMap = new int[attributes.size()];
            for (int index = 0; index < audioMap.length; ++index) {
                String m = attributes.get(index).getValue().split(" ")[0];
                audioMap[index] = Integer.valueOf(m);
            }
            MediaDescription md = sdpFactory.createMediaDescription("audio", port, 1, "RTP/AVP", audioMap);
            md.setAttributes(attributes);
            Vector<MediaDescription> descriptions = new Vector<MediaDescription>();
            descriptions.add(md);
            localSDP.setMediaDescriptions(descriptions);
        }
        catch (SdpException e) {
            e.printStackTrace();
        }
        return localSDP.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.receiveRTP) {
                ByteBuffer packetBuffer = ByteBuffer.allocate(172);
                try {
                    long received = 0L;
                    int readMaxCount = 4;
                    for (int readCount = 0; received != 172L && readCount < readMaxCount; received += (long)this.datagramChannel.read(packetBuffer), ++readCount) {
                    }
                    packetBuffer.flip();
                    RtpPacket rtp = new RtpPacket(packetBuffer.array());
                    rtp.setTime(new Date(System.currentTimeMillis()));
                    if (this.rtpTraffic != null) {
                        this.rtpTraffic.add(rtp);
                    }
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (NotYetConnectedException e) {
                    e.printStackTrace();
                }
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            throw throwable;
        }
    }

    public abstract void start();

    public abstract void timeOut();

    public abstract void stop();

    public ScheduledFuture<?> getTimeoutHandle() {
        return this.timeoutHandle;
    }

    public void setTimeoutHandle(ScheduledFuture<?> timeoutHandle) {
        this.timeoutHandle = timeoutHandle;
    }
}

