/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.testsuite.general.ann;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.NotifyResponse;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.RequestedAction;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import jain.protocol.ip.mgcp.pkg.PackageName;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sdp.MediaDescription;
import javax.sdp.SdpException;
import javax.sdp.SdpParseException;
import javax.sdp.SessionDescription;
import org.mobicents.media.server.testsuite.general.AbstractCall;
import org.mobicents.media.server.testsuite.general.AbstractTestCase;
import org.mobicents.media.server.testsuite.general.CallState;
import org.mobicents.media.server.testsuite.general.ann.AnnCallState;

public class AnnCall
extends AbstractCall {
    protected transient org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(AnnCall.class);
    private AnnCallState localFlowState = AnnCallState.INITIAL;
    private String HELLO_WORLD = "";
    private ConnectionIdentifier allocatedConnection = null;
    private RequestIdentifier ri = null;

    public AnnCall(AbstractTestCase testCase, String fileToPlay) throws IOException {
        super(testCase);
        this.endpointName = "/mobicents/media/aap/$";
        this.HELLO_WORLD = fileToPlay;
    }

    protected void setLocalFlowState(AnnCallState state) {
        if (this.localFlowState == state) {
            return;
        }
        this.localFlowState = state;
    }

    public void transactionRxTimedOut(JainMgcpCommandEvent arg0) {
    }

    public void transactionTxTimedOut(JainMgcpCommandEvent arg0) {
        switch (this.localFlowState) {
            case SENT_CRCX: {
                this.setLocalFlowState(AnnCallState.TERMINATED);
                super.setState(CallState.IN_ERROR);
                break;
            }
            case SENT_ANN: {
                this.sendDelete();
                this.setLocalFlowState(AnnCallState.TERMINATED);
                super.setState(CallState.IN_ERROR);
                break;
            }
            case SENT_DLCX: {
                this.setLocalFlowState(AnnCallState.TERMINATED);
                super.setState(CallState.IN_ERROR);
            }
        }
    }

    public void transactionEnded(int arg0) {
    }

    public void processMgcpCommandEvent(JainMgcpCommandEvent mgcpCommand) {
        switch (this.localFlowState) {
            case SENT_ANN: {
                if (!(mgcpCommand instanceof Notify)) break;
                Notify notify = (Notify)mgcpCommand;
                ReturnCode rc = ReturnCode.Transaction_Executed_Normally;
                NotifyResponse notifyResponse = new NotifyResponse((Object)this, rc);
                notifyResponse.setTransactionHandle(notify.getTransactionHandle());
                this.provider.sendMgcpEvents(new JainMgcpEvent[]{notifyResponse});
                this.testCase.removeCall((JainMgcpEvent)mgcpCommand);
                this.testCase.removeCall(notify.getRequestIdentifier().toString());
                this.cancelTimeoutHandle();
                this.sendDelete();
                break;
            }
            default: {
                this.stop();
                this.sendDelete();
            }
        }
    }

    private String buildResponseHeader(JainMgcpResponseEvent response) {
        ReturnCode r = response.getReturnCode();
        String s = new String(r.getValue() + " " + response.getTransactionHandle() + " " + (r.getComment() == null ? "" : r.getComment()) + " " + this.getMGCPComand(response.getObjectIdentifier()) + "\n");
        return s;
    }

    private String getMGCPComand(int objectIdentifier) {
        String cmd = null;
        switch (objectIdentifier) {
            case 203: {
                cmd = "CRCX";
                break;
            }
            case 204: {
                cmd = "DLCX";
                break;
            }
            case 207: {
                cmd = "RQNT";
                break;
            }
            default: {
                cmd = "WTF";
            }
        }
        return cmd;
    }

    public void processMgcpResponseEvent(JainMgcpResponseEvent mgcpResponse) {
        int code = mgcpResponse.getReturnCode().getValue();
        int objId = mgcpResponse.getObjectIdentifier();
        this.testCase.removeCall((JainMgcpEvent)mgcpResponse);
        switch (this.localFlowState) {
            case SENT_CRCX: {
                if (objId == 203) {
                    CreateConnectionResponse ccr = (CreateConnectionResponse)mgcpResponse;
                    if (99 < code && code < 200) break;
                    if (199 < code && code < 300) {
                        try {
                            this.endpointIdentifier = ccr.getSpecificEndpointIdentifier();
                            this.allocatedConnection = ccr.getConnectionIdentifier();
                            ConnectionDescriptor cd = ccr.getLocalConnectionDescriptor();
                            SessionDescription sessionDesc = this.testCase.getSdpFactory().createSessionDescription(cd.toString());
                            this.connectToPeer(sessionDesc);
                            this.receiveRTP = true;
                            this.readerTask = this.readerThread.scheduleAtFixedRate(this, 0L, 20L, TimeUnit.MILLISECONDS);
                            this.ri = this.provider.getUniqueRequestIdentifier();
                            NotificationRequest notificationRequest = new NotificationRequest((Object)this, this.endpointIdentifier, this.ri);
                            EventName[] signalRequests = new EventName[]{new EventName(PackageName.Announcement, MgcpEvent.ann.withParm(this.HELLO_WORLD), null)};
                            notificationRequest.setSignalRequests(signalRequests);
                            RequestedAction[] actions = new RequestedAction[]{RequestedAction.NotifyImmediately};
                            RequestedEvent[] requestedEvents = new RequestedEvent[]{new RequestedEvent(new EventName(PackageName.Announcement, MgcpEvent.oc, null), actions)};
                            notificationRequest.setRequestedEvents(requestedEvents);
                            NotifiedEntity notifiedEntity = new NotifiedEntity(this.testCase.getClientTestNodeAddress().getHostAddress(), this.testCase.getClientTestNodeAddress().getHostAddress(), this.testCase.getCallDisplayInterface().getLocalPort());
                            notificationRequest.setNotifiedEntity(notifiedEntity);
                            notificationRequest.setTransactionHandle(this.provider.getUniqueTransactionHandler());
                            this.testCase.addCall((JainMgcpEvent)notificationRequest, (AbstractCall)this);
                            this.testCase.addCall(this.ri.toString(), (AbstractCall)this);
                            this.provider.sendMgcpEvents((JainMgcpEvent[])new JainMgcpCommandEvent[]{notificationRequest});
                            super.setState(CallState.ESTABILISHED);
                            this.setLocalFlowState(AnnCallState.SENT_ANN);
                        }
                        catch (Exception ex) {
                            Logger.getLogger(AnnCall.class.getName()).log(Level.SEVERE, null, ex);
                            this.setLocalFlowState(AnnCallState.TERMINATED);
                            super.setState(CallState.IN_ERROR);
                        }
                        break;
                    }
                    this.setLocalFlowState(AnnCallState.TERMINATED);
                    super.setState(CallState.IN_ERROR);
                    this.logger.error((Object)("FAILED[" + (Object)((Object)this.localFlowState) + "] ON CRCX RESPONSE: " + this.buildResponseHeader(mgcpResponse)));
                    break;
                }
                this.setLocalFlowState(AnnCallState.TERMINATED);
                super.setState(CallState.IN_ERROR);
                this.logger.error((Object)("FAILED[" + (Object)((Object)this.localFlowState) + "] ON RESPONSE: " + this.buildResponseHeader(mgcpResponse)));
                break;
            }
            case SENT_ANN: {
                if (objId == 207) {
                    if (99 < code && code < 200 || 199 < code && code < 300) break;
                    this.setLocalFlowState(AnnCallState.TERMINATED);
                    super.setState(CallState.IN_ERROR);
                    this.logger.error((Object)("FAILED[" + (Object)((Object)this.localFlowState) + "] ON RESPONSE: " + this.buildResponseHeader(mgcpResponse)));
                    break;
                }
                this.setLocalFlowState(AnnCallState.TERMINATED);
                super.setState(CallState.IN_ERROR);
                this.logger.error((Object)("FAILED[" + (Object)((Object)this.localFlowState) + "] ON CRCX RESPONSE: " + this.buildResponseHeader(mgcpResponse) + " objId1 = " + objId));
                break;
            }
            case SENT_DLCX: {
                if (objId == 204) {
                    if (99 < code && code < 200) break;
                    if (199 < code && code < 300) {
                        this.stop();
                        break;
                    }
                    this.setLocalFlowState(AnnCallState.TERMINATED);
                    super.setState(CallState.IN_ERROR);
                    this.logger.error((Object)("FAILED[" + (Object)((Object)this.localFlowState) + "] ON DLCX RESPONSE: " + this.buildResponseHeader(mgcpResponse)));
                    break;
                }
                this.setLocalFlowState(AnnCallState.TERMINATED);
                super.setState(CallState.IN_ERROR);
                this.logger.error((Object)("FAILED[" + (Object)((Object)this.localFlowState) + "] ON CRCX RESPONSE: " + this.buildResponseHeader(mgcpResponse) + " objId = " + objId));
                break;
            }
            default: {
                this.logger.error((Object)("GOT RESPONSE UNKONWN[" + (Object)((Object)this.localFlowState) + "] ON CRCX RESPONSE: " + this.buildResponseHeader(mgcpResponse)));
            }
        }
    }

    public void start() {
        try {
            super.initSocket();
            EndpointIdentifier ei = new EndpointIdentifier(this.endpointName, this.testCase.getServerJbossBindAddress().getHostAddress() + ":" + this.testCase.getCallDisplayInterface().getRemotePort());
            CreateConnection crcx = new CreateConnection((Object)this, this.callIdentifier, ei, ConnectionMode.SendRecv);
            int localPort = this.datagramChannel.socket().getLocalPort();
            crcx.setRemoteConnectionDescriptor(new ConnectionDescriptor(super.getLocalDescriptor(localPort)));
            crcx.setTransactionHandle(this.provider.getUniqueTransactionHandler());
            this.provider.sendMgcpEvents(new JainMgcpEvent[]{crcx});
            this.testCase.addCall((JainMgcpEvent)crcx, (AbstractCall)this);
            this.setLocalFlowState(AnnCallState.SENT_CRCX);
            super.setState(CallState.INITIAL);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setLocalFlowState(AnnCallState.TERMINATED);
            super.setState(CallState.IN_ERROR);
        }
    }

    private void cancelTimeoutHandle() {
        if (super.getTimeoutHandle() != null) {
            super.getTimeoutHandle().cancel(false);
        }
    }

    public void stop() {
        this.cancelTimeoutHandle();
        if (this.ri != null) {
            this.testCase.removeCall(this.ri.toString());
        }
        this.receiveRTP = false;
        if (this.readerTask != null) {
            this.readerTask.cancel(true);
        }
        if (this.state != CallState.IN_ERROR) {
            super.setState(CallState.ENDED);
            this.setLocalFlowState(AnnCallState.TERMINATED);
        }
    }

    public void timeOut() {
        this.sendDelete();
    }

    private void sendDelete() {
        DeleteConnection dlcx = new DeleteConnection((Object)this, this.endpointIdentifier);
        dlcx.setCallIdentifier(this.callIdentifier);
        dlcx.setConnectionIdentifier(this.allocatedConnection);
        dlcx.setTransactionHandle(this.provider.getUniqueTransactionHandler());
        this.testCase.addCall((JainMgcpEvent)dlcx, (AbstractCall)this);
        this.setLocalFlowState(AnnCallState.SENT_DLCX);
        this.provider.sendMgcpEvents((JainMgcpEvent[])new JainMgcpCommandEvent[]{dlcx});
    }

    private void connectToPeer(SessionDescription sd) throws SdpParseException, SdpException, UnknownHostException, IOException {
        String cAddress = sd.getConnection().getAddress();
        Vector v = sd.getMediaDescriptions(true);
        MediaDescription md = (MediaDescription)v.get(0);
        int port = md.getMedia().getMediaPort();
        InetSocketAddress sa = new InetSocketAddress(InetAddress.getAllByName(cAddress)[0], port);
        this.datagramChannel.connect(sa);
    }
}

