/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.testsuite.gui.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.mobicents.media.server.testsuite.general.AbstractCall;
import org.mobicents.media.server.testsuite.general.rtp.PacketTableModel;
import org.mobicents.media.server.testsuite.gui.graph.RtpTrafficGraph;

public class RtpTrafficDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private AbstractCall call;
    private JButton closeButton;
    private JButton jButton1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JTable packetTable;
    private JLabel stats;
    private int returnStatus = 0;

    public RtpTrafficDialog(Frame parent, boolean modal, AbstractCall call) {
        super(parent, modal);
        this.call = call;
        this.initComponents();
        int[] errors = new int[100];
        try {
            PacketTableModel model = new PacketTableModel(call.getRtp());
            this.packetTable.setModel(model);
            int errorCount = 0;
            this.stats.setText("Out of sequence packets=" + errorCount + ", Average jitter=" + call.getAvgJitter());
            this.printErrors(errors, errorCount);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printErrors(int[] errors, int count) {
        for (int i = 0; i < count; ++i) {
            System.out.println(errors[i]);
        }
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.closeButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.packetTable = new JTable();
        this.jPanel3 = new JPanel();
        this.stats = new JLabel();
        this.setTitle("RTP Traffic");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                RtpTrafficDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButton1.setText("Graph");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RtpTrafficDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton1);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RtpTrafficDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.closeButton);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setLayout(new BorderLayout());
        this.packetTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.packetTable);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.jPanel3.setLayout(new FlowLayout(0));
        this.stats.setText("Stats");
        this.jPanel3.add(this.stats);
        this.jPanel2.add((Component)this.jPanel3, "South");
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            RtpTrafficGraph g = new RtpTrafficGraph(null, true, this.call);
            g.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

