/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.cli;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.mobicents.slee.container.management.jmx.SleeCommandInterface;

public class MobicentsCLI {
    private static Logger logger = Logger.getLogger(MobicentsCLI.class.getName());

    public static void usage() {
        System.out.println("Usage: java -jar mobicents-cli.jar [options] <command> <args>");
        System.out.println("options:");
        System.out.println("-user");
        System.out.println("-password");
        System.out.println("-host");
        System.out.println("-jnpPort");
        System.out.println("");
        System.out.println("Valid commands:");
        System.out.println("-startSlee");
        System.out.println("-stopSlee");
        System.out.println("-getSleeState");
        System.out.println("-install <url>");
        System.out.println("-uninstall <Deployment ID>");
        System.out.println("-uninstall <url>");
        System.out.println("-getDescriptor <Deployment ID>");
        System.out.println("-getDeploymentId <file url>");
        System.out.println("-activateService <Service ID>");
        System.out.println("-deactivateService <Service ID>");
        System.out.println("-getServiceState <Service ID>");
        System.out.println("-setTraceLevel <Component ID> <level>");
        System.out.println("-getTraceLevel <Component ID>");
        System.out.println("-createRaEntity <ResourceAdaptor ID> <entity name> <props>");
        System.out.println("-activateRaEntity <entity name>");
        System.out.println("-deactivateRaEntity <entity name>");
        System.out.println("-removeRaEntity <entity name>");
        System.out.println("-createEntityLink <link name> <entity name>");
        System.out.println("-removeEntityLink <link name>");
        System.out.println("-createProfileTable <ProfileSpecification ID> <profile table name>");
        System.out.println("-removeProfileTable <profile table name>");
        System.out.println("-createProfile <profile table name> <profile name>");
        System.out.println("-removeProfile <profile table name> <profile name>");
    }

    public static void main(String[] args) {
        String jnpPort;
        String host;
        int k;
        String user = null;
        String password = null;
        String data1 = null;
        String data2 = null;
        String data3 = null;
        if (args.length < 1) {
            MobicentsCLI.usage();
            System.exit(1);
        }
        if (args[k = 0].equals("-user")) {
            user = args[k + 1];
            k += 2;
        }
        if (args[k].equals("-password")) {
            password = args[k + 1];
            k += 2;
        }
        if (args[k].equals("-host")) {
            host = args[k + 1];
            k += 2;
        } else {
            host = "localhost";
        }
        if (args[k].equals("-jnpPort")) {
            jnpPort = args[k + 1];
            k += 2;
        } else {
            jnpPort = "1099";
        }
        String command = args[k];
        if (args.length >= k + 2) {
            data1 = args[k + 1];
        }
        if (args.length >= k + 3) {
            data2 = args[2 + k];
        }
        if (args.length >= 4 + k) {
            data3 = args[3 + k];
        }
        try {
            SleeCommandInterface sleeCommandInterface = new SleeCommandInterface("jnp://" + host + ":" + jnpPort);
            Object result = sleeCommandInterface.invokeOperation(command, data1, data2, data3);
            if (result == null) {
                logger.info("No response");
            } else {
                logger.info(result.toString());
            }
        }
        catch (SecurityException seEx) {
            seEx.printStackTrace();
            logger.log(Level.WARNING, "Security Exception: " + seEx.getMessage() + " Cause = " + seEx.getCause().toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.log(Level.WARNING, "Bad result: " + ex.getCause().toString());
        }
    }
}

