/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.accessor.http;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ContentType {
    public static final String CHARSET_KEY = "charset";
    private String mimeType;
    private HashMap parameterMap = new HashMap(4);

    public static String getMimeType(String string) {
        ContentType contentType = new ContentType(string);
        return contentType.getMimeType();
    }

    public ContentType(String string) {
        this.processContentType(string);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getParameter(String string) {
        return (String)this.parameterMap.get(string.toLowerCase());
    }

    public Map getParameters() {
        return Collections.unmodifiableMap(this.parameterMap);
    }

    public String getCharset() {
        return this.getParameter(CHARSET_KEY);
    }

    private void processContentType(String string) {
        int n = string.indexOf(59);
        if (n == -1) {
            this.mimeType = string.trim();
        } else {
            this.mimeType = string.substring(0, n).trim();
            int n2 = string.indexOf(59, n + 1);
            while (n2 != -1) {
                this.processParameter(string.substring(n + 1, n2));
                n = n2;
                n2 = string.indexOf(59, n + 1);
            }
            this.processParameter(string.substring(n + 1));
        }
    }

    private void processParameter(String string) {
        int n = string.indexOf(61);
        if (n >= 1) {
            String string2 = string.substring(0, n).trim().toLowerCase();
            String string3 = string.substring(n + 1).trim();
            this.parameterMap.put(string2, string3);
        } else if (!this.parameterMap.containsKey(CHARSET_KEY)) {
            this.parameterMap.put(CHARSET_KEY, string.trim());
        }
    }
}

