/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.search;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.transaction.xa.XAResource;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.CompositeRequest;
import org.modeshape.graph.request.CompositeRequestChannel;
import org.modeshape.graph.request.FullTextSearchRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.processor.RequestProcessor;
import org.modeshape.graph.search.SearchEngine;
import org.modeshape.graph.search.SearchEngineProcessor;

@ThreadSafe
public class SearchableRepositorySource
implements RepositorySource {
    private static final long serialVersionUID = 1L;
    private final RepositorySource delegate;
    private final boolean executeAsynchronously;
    private final boolean updateIndexesAsynchronously;
    private final transient ExecutorService executorService;
    private final transient SearchEngine searchEngine;

    public SearchableRepositorySource(RepositorySource wrapped, SearchEngine searchEngine, ExecutorService executorService, boolean executeAsynchronously, boolean updateIndexesAsynchronously) {
        CheckArg.isNotNull((Object)wrapped, (String)"wrapped");
        CheckArg.isNotNull((Object)searchEngine, (String)"searchEngine");
        this.delegate = wrapped;
        this.executorService = executorService;
        this.searchEngine = searchEngine;
        this.updateIndexesAsynchronously = this.executorService != null && updateIndexesAsynchronously;
        this.executeAsynchronously = this.executorService != null && executeAsynchronously;
    }

    public SearchableRepositorySource(RepositorySource wrapped, SearchEngine searchEngine) {
        this(wrapped, searchEngine, null, false, false);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public void close() {
        this.delegate.close();
    }

    public RepositorySourceCapabilities getCapabilities() {
        return new RepositorySourceCapabilities(this.delegate.getCapabilities()){

            public boolean supportsQueries() {
                return true;
            }

            public boolean supportsSearches() {
                return true;
            }
        };
    }

    public RepositoryConnection getConnection() throws RepositorySourceException {
        if (this.executeRequestsAsynchronously()) {
            assert (this.executorService != null);
            return new ParallelConnection(this.executorService);
        }
        return new SynchronousConnection();
    }

    public int getRetryLimit() {
        return this.delegate.getRetryLimit();
    }

    public void initialize(final RepositoryContext context) throws RepositorySourceException {
        final String delegateSourceName = this.delegate.getName();
        final RepositoryConnectionFactory originalConnectionFactory = context.getRepositoryConnectionFactory();
        final RepositoryConnectionFactory connectionFactory = new RepositoryConnectionFactory(){

            public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                if (delegateSourceName.equals(sourceName)) {
                    return SearchableRepositorySource.this.delegate().getConnection();
                }
                return originalConnectionFactory.createConnection(sourceName);
            }
        };
        final Observer observer = new Observer(){

            public void notify(final Changes changes) {
                if (changes != null) {
                    if (SearchableRepositorySource.this.updateIndexesAsynchronously()) {
                        SearchableRepositorySource.this.executorService().submit(new Runnable(){

                            public void run() {
                                SearchableRepositorySource.this.process(context.getExecutionContext(), changes);
                            }
                        });
                    } else {
                        SearchableRepositorySource.this.process(context.getExecutionContext(), changes);
                    }
                }
            }
        };
        RepositoryContext newContext = new RepositoryContext(){

            public Subgraph getConfiguration(int depth) {
                return context.getConfiguration(depth);
            }

            public ExecutionContext getExecutionContext() {
                return context.getExecutionContext();
            }

            public Observer getObserver() {
                return observer;
            }

            public RepositoryConnectionFactory getRepositoryConnectionFactory() {
                return connectionFactory;
            }
        };
        this.delegate.initialize(newContext);
    }

    protected final SearchEngine searchEngine() {
        assert (this.searchEngine != null);
        return this.searchEngine;
    }

    protected final boolean updateIndexesAsynchronously() {
        return this.executorService != null && this.updateIndexesAsynchronously;
    }

    protected final boolean executeRequestsAsynchronously() {
        return this.executorService != null && this.executeAsynchronously;
    }

    protected final ExecutorService executorService() {
        assert (this.executorService != null);
        return this.executorService;
    }

    protected final RepositorySource delegate() {
        return this.delegate;
    }

    protected void process(ExecutionContext context, Changes changes) {
        assert (context != null);
        assert (changes != null);
        if (this.searchEngine == null) {
            return;
        }
        this.searchEngine.index(context, changes.getChangeRequests());
    }

    public void setRetryLimit(int limit) {
        this.delegate.setRetryLimit(limit);
    }

    public Reference getReference() throws NamingException {
        return this.delegate.getReference();
    }

    @NotThreadSafe
    protected class SynchronousConnection
    extends AbstractConnection {
        protected SynchronousConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
            SearchEngineProcessor searchProcessor = null;
            switch (request.getType()) {
                case ACCESS_QUERY: {
                    AccessQueryRequest queryRequest = (AccessQueryRequest)request;
                    searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                    try {
                        searchProcessor.process(queryRequest);
                        Object var6_6 = null;
                        ((RequestProcessor)searchProcessor).close();
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        ((RequestProcessor)searchProcessor).close();
                        throw throwable;
                    }
                }
                case FULL_TEXT_SEARCH: {
                    FullTextSearchRequest searchRequest = (FullTextSearchRequest)request;
                    searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                    try {
                        searchProcessor.process(searchRequest);
                        Object var8_12 = null;
                        ((RequestProcessor)searchProcessor).close();
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        ((RequestProcessor)searchProcessor).close();
                        throw throwable;
                    }
                }
                case COMPOSITE: {
                    CompositeRequest composite = (CompositeRequest)request;
                    LinkedList<Request> delegateRequests = null;
                    try {
                        Request delegateRequest = composite;
                        block15: for (Request nested : composite) {
                            switch (nested.getType()) {
                                case ACCESS_QUERY: {
                                    AccessQueryRequest queryRequest = (AccessQueryRequest)request;
                                    if (searchProcessor == null) {
                                        searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                                    }
                                    searchProcessor.process(queryRequest);
                                    delegateRequest = null;
                                    continue block15;
                                }
                                case FULL_TEXT_SEARCH: {
                                    FullTextSearchRequest searchRequest = (FullTextSearchRequest)request;
                                    if (searchProcessor == null) {
                                        searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                                    }
                                    searchProcessor.process(searchRequest);
                                    delegateRequest = null;
                                    continue block15;
                                }
                            }
                            if (delegateRequests == null) {
                                delegateRequests = new LinkedList<Request>();
                            }
                            delegateRequests.add(request);
                        }
                        if (delegateRequest == null) {
                            if (delegateRequests != null) {
                                assert (!delegateRequests.isEmpty());
                                delegateRequest = CompositeRequest.with((List<? extends Request>)delegateRequests);
                                this.delegateConnection().execute(context, delegateRequest);
                            }
                        } else {
                            this.delegateConnection().execute(context, request);
                        }
                        Object var12_19 = null;
                        if (searchProcessor == null) break;
                        ((RequestProcessor)searchProcessor).close();
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var12_20 = null;
                        if (searchProcessor != null) {
                            ((RequestProcessor)searchProcessor).close();
                        }
                        throw throwable;
                    }
                }
                default: {
                    this.delegateConnection().execute(context, request);
                }
            }
        }
    }

    @NotThreadSafe
    protected class ParallelConnection
    extends AbstractConnection {
        private final ExecutorService executorService;

        protected ParallelConnection(ExecutorService executorService) {
            this.executorService = executorService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
            searchProcessor = null;
            switch (5.$SwitchMap$org$modeshape$graph$request$RequestType[request.getType().ordinal()]) {
                case 1: {
                    queryRequest = (AccessQueryRequest)request;
                    searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                    try {
                        searchProcessor.process(queryRequest);
                        return;
                    }
                    finally {
                        searchProcessor.close();
                    }
                }
                case 2: {
                    searchRequest = (FullTextSearchRequest)request;
                    searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                    try {
                        searchProcessor.process(searchRequest);
                        return;
                    }
                    finally {
                        searchProcessor.close();
                    }
                }
                case 3: {
                    composite = (CompositeRequest)request;
                    channel = null;
                    try {
                        block36: for (Request nested : composite) {
                            switch (5.$SwitchMap$org$modeshape$graph$request$RequestType[nested.getType().ordinal()]) {
                                case 1: {
                                    queryRequest = (AccessQueryRequest)request;
                                    if (searchProcessor == null) {
                                        searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                                    }
                                    searchProcessor.process(queryRequest);
                                    continue block36;
                                }
                                case 2: {
                                    searchRequest = (FullTextSearchRequest)request;
                                    if (searchProcessor == null) {
                                        searchProcessor = SearchableRepositorySource.this.searchEngine().createProcessor(context, null, true);
                                    }
                                    searchProcessor.process(searchRequest);
                                    continue block36;
                                }
                            }
                            if (channel == null) {
                                connectionFactory = new RepositoryConnectionFactory(){

                                    public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                                        assert (SearchableRepositorySource.this.delegate().getName().equals(sourceName));
                                        return ParallelConnection.this.delegateConnection();
                                    }
                                };
                                channel = new CompositeRequestChannel(SearchableRepositorySource.this.delegate().getName());
                                channel.start(this.executorService, context, connectionFactory);
                            }
                            channel.add(request);
                        }
                        var12_15 = null;
                        ** GOTO lbl83
                    }
                    catch (Throwable var11_43) {
                        var12_16 = null;
                        try {
                            if (searchProcessor != null) {
                                searchProcessor.close();
                            }
                            v0 = null;
                        }
                        catch (Throwable var13_18) {
                            v0 = null;
                        }
                        var14_20 = v0;
                        if (channel == null) throw var11_43;
                        try {
                            channel.close();
                            var16_23 = null;
                        }
                        catch (Throwable var15_42) {
                            var16_24 = null;
                            try {
                                channel.await();
                                throw var15_42;
                            }
                            catch (CancellationException err) {
                                composite.cancel();
                                throw var15_42;
                            }
                            catch (ExecutionException err) {
                                composite.setError(err);
                                throw var15_42;
                            }
                            catch (InterruptedException err) {
                                Thread.interrupted();
                                msg = GraphI18n.interruptedWhileClosingChannel;
                                Logger.getLogger(this.getClass()).warn((Throwable)err, msg, new Object[]{SearchableRepositorySource.this.delegate().getName()});
                                composite.setError(err);
                            }
                            throw var15_42;
                        }
lbl83:
                        // 1 sources

                        ** try [egrp 3[TRYBLOCK] [6 : 355->369)] { 
lbl84:
                        // 1 sources

                        if (searchProcessor != null) {
                            searchProcessor.close();
                        }
                        v1 = null;
                        ** GOTO lbl90
lbl88:
                        // 1 sources

                        catch (Throwable var13_17) {
                            v1 = null;
                        }
lbl90:
                        // 2 sources

                        var14_19 = v1;
                        if (channel == null) return;
                        try {}
                        catch (Throwable var15_41) {
                            var16_22 = null;
                            ** try [egrp 5[TRYBLOCK] [10, 11, 12 : 405->413)] { 
lbl97:
                            // 1 sources

                            channel.await();
                            throw var15_41;
lbl99:
                            // 1 sources

                            catch (CancellationException err) {
                                composite.cancel();
                                throw var15_41;
                            }
lbl102:
                            // 1 sources

                            catch (ExecutionException err) {
                                composite.setError(err);
                                throw var15_41;
                            }
lbl105:
                            // 1 sources

                            catch (InterruptedException err) {
                                Thread.interrupted();
                                msg = GraphI18n.interruptedWhileClosingChannel;
                                Logger.getLogger(this.getClass()).warn((Throwable)err, msg, new Object[]{SearchableRepositorySource.this.delegate().getName()});
                                composite.setError(err);
                            }
                            throw var15_41;
                        }
                        channel.close();
                        var16_21 = null;
                        ** try [egrp 5[TRYBLOCK] [10, 11, 12 : 405->413)] { 
lbl117:
                        // 1 sources

                        channel.await();
                        return;
lbl119:
                        // 1 sources

                        catch (CancellationException err) {
                            composite.cancel();
                            return;
                        }
lbl122:
                        // 1 sources

                        catch (ExecutionException err) {
                            composite.setError(err);
                            return;
                        }
lbl125:
                        // 1 sources

                        catch (InterruptedException err) {
                            Thread.interrupted();
                            msg = GraphI18n.interruptedWhileClosingChannel;
                            Logger.getLogger(this.getClass()).warn((Throwable)err, msg, new Object[]{SearchableRepositorySource.this.delegate().getName()});
                            composite.setError(err);
                            return;
                        }
                        ** try [egrp 5[TRYBLOCK] [10, 11, 12 : 405->413)] { 
lbl133:
                        // 1 sources

                        channel.await();
                        throw var11_43;
lbl135:
                        // 1 sources

                        catch (CancellationException err) {
                            composite.cancel();
                            throw var11_43;
                        }
lbl138:
                        // 1 sources

                        catch (ExecutionException err) {
                            composite.setError(err);
                            throw var11_43;
                        }
lbl141:
                        // 1 sources

                        catch (InterruptedException err) {
                            Thread.interrupted();
                            msg = GraphI18n.interruptedWhileClosingChannel;
                            Logger.getLogger(this.getClass()).warn((Throwable)err, msg, new Object[]{SearchableRepositorySource.this.delegate().getName()});
                            composite.setError(err);
                            throw var11_43;
                        }
                    }
                }
            }
            this.delegateConnection().execute(context, request);
        }
    }

    @NotThreadSafe
    protected abstract class AbstractConnection
    implements RepositoryConnection {
        private RepositoryConnection delegateConnection;

        protected AbstractConnection() {
        }

        protected RepositoryConnection delegateConnection() {
            if (this.delegateConnection == null) {
                this.delegateConnection = SearchableRepositorySource.this.delegate().getConnection();
            }
            return this.delegateConnection;
        }

        public boolean ping(long time, TimeUnit unit) throws InterruptedException {
            return this.delegateConnection().ping(time, unit);
        }

        public CachePolicy getDefaultCachePolicy() {
            return this.delegateConnection().getDefaultCachePolicy();
        }

        public String getSourceName() {
            return SearchableRepositorySource.this.delegate().getName();
        }

        public XAResource getXAResource() {
            return this.delegateConnection().getXAResource();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.delegateConnection != null) {
                try {
                    this.delegateConnection.close();
                }
                finally {
                    this.delegateConnection = null;
                }
            }
        }
    }
}

