/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.accessor.http;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.accessor.DataAccessor;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.UrlNotFoundException;
import org.semanticdesktop.aperture.accessor.base.FileDataObjectBase;
import org.semanticdesktop.aperture.accessor.http.ContentType;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.HttpClientUtil;
import org.semanticdesktop.aperture.util.UrlUtil;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAccessor
implements DataAccessor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ACCESSED_KEY = "accessed";
    private static final int MAX_REDIRECTIONS = 20;
    private int connectTimeout = 20000;
    private int readTimeout = 20000;

    public void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public DataObject getDataObject(String string, DataSource dataSource, Map map, RDFContainerFactory rDFContainerFactory) throws UrlNotFoundException, IOException {
        return this.get(string, dataSource, null, map, rDFContainerFactory);
    }

    public DataObject getDataObjectIfModified(String string, DataSource dataSource, AccessData accessData, Map map, RDFContainerFactory rDFContainerFactory) throws UrlNotFoundException, IOException {
        return this.get(string, dataSource, accessData, map, rDFContainerFactory);
    }

    private DataObject get(String string, DataSource dataSource, AccessData accessData, Map map, RDFContainerFactory rDFContainerFactory) throws UrlNotFoundException, IOException {
        int n;
        Object object;
        HttpURLConnection httpURLConnection;
        URIImpl uRIImpl;
        block10: {
            String string2;
            uRIImpl = null;
            try {
                uRIImpl = new URIImpl(string);
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
            String string3 = string;
            httpURLConnection = null;
            int n2 = 0;
            do {
                if (n2 > 20) {
                    throw new IOException("too many redirections, max = 20, url = " + string3);
                }
                object = new URL(string);
                object = UrlUtil.normalizeURL((URL)object);
                string = ((URL)object).toExternalForm();
                Date date = accessData == null ? null : this.getIfModifiedSince(string, accessData);
                try {
                    httpURLConnection = this.createConnection((URL)object, date);
                    httpURLConnection.connect();
                }
                catch (Exception exception) {
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    throw new UrlNotFoundException(string3, "connection resulted in a " + exception.getClass() + " exception");
                }
                n = httpURLConnection.getResponseCode();
                if (!this.isRedirected(n)) break block10;
                string2 = string;
                string = this.getRedirectedUrl((URL)object, httpURLConnection);
                ++n2;
                if (accessData == null) continue;
                accessData.remove(string2, "date");
                accessData.remove(string2, ACCESSED_KEY);
                accessData.put(string2, "redirectsTo", string);
            } while (!string.equals(string2));
            throw new UrlNotFoundException("url redirects to itself: " + string);
        }
        if (n == 404) {
            throw new UrlNotFoundException(string);
        }
        if (n == 304) {
            return null;
        }
        if (n != 200) {
            throw new IOException("Http connection error, response code = " + n + ", url = " + object);
        }
        object = this.createDataObject((URI)uRIImpl, dataSource, httpURLConnection, rDFContainerFactory);
        this.updateAccessData(accessData, string, httpURLConnection.getDate());
        return object;
    }

    private Date getIfModifiedSince(String string, AccessData accessData) {
        if (accessData == null) {
            return null;
        }
        String string2 = accessData.get(string, "date");
        if (string2 == null) {
            return null;
        }
        try {
            long l = Long.parseLong(string2);
            return new Date(l);
        }
        catch (NumberFormatException numberFormatException) {
            this.logger.error("invalid long: " + string2, (Throwable)numberFormatException);
            return null;
        }
    }

    private HttpURLConnection createConnection(URL uRL, Date date) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(this.connectTimeout);
        httpURLConnection.setReadTimeout(this.readTimeout);
        HttpClientUtil.setAcceptGZIPEncoding(httpURLConnection);
        httpURLConnection.setInstanceFollowRedirects(false);
        if (date != null) {
            httpURLConnection.setIfModifiedSince(date.getTime());
        }
        return httpURLConnection;
    }

    private boolean isRedirected(int n) {
        return n == 300 || n == 301 || n == 302 || n == 303;
    }

    private String getRedirectedUrl(URL uRL, HttpURLConnection httpURLConnection) throws IOException {
        String string = httpURLConnection.getHeaderField("Location");
        if (string == null) {
            throw new IOException("missing redirection location");
        }
        return new URL(uRL, string).toString();
    }

    private DataObject createDataObject(URI uRI, DataSource dataSource, HttpURLConnection httpURLConnection, RDFContainerFactory rDFContainerFactory) throws IOException {
        long l;
        long l2;
        RDFContainer rDFContainer = rDFContainerFactory.getRDFContainer(uRI);
        InputStream inputStream = HttpClientUtil.getInputStream(httpURLConnection);
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream, 8192);
        }
        FileDataObjectBase fileDataObjectBase = new FileDataObjectBase(uRI, dataSource, rDFContainer, inputStream);
        String string = null;
        String string2 = null;
        String string3 = httpURLConnection.getContentType();
        if (string3 != null) {
            ContentType contentType = new ContentType(string3);
            string = contentType.getCharset();
            string2 = contentType.getMimeType();
        }
        if (string == null) {
            string = "ISO-8859-1";
        }
        rDFContainer.add(RDF.type, (Node)NFO.RemoteDataObject);
        rDFContainer.add(RDF.type, (Node)NIE.InformationElement);
        rDFContainer.add(NIE.characterSet, string);
        if (string2 != null) {
            rDFContainer.add(NIE.mimeType, string2);
        }
        if ((l2 = (long)httpURLConnection.getContentLength()) >= 0L) {
            rDFContainer.add(NIE.byteSize, l2);
        }
        if ((l = httpURLConnection.getLastModified()) != 0L) {
            rDFContainer.add(NIE.contentLastModified, new Date(l));
        }
        return fileDataObjectBase;
    }

    private void updateAccessData(AccessData accessData, String string, long l) {
        if (accessData != null) {
            accessData.remove(string, ACCESSED_KEY);
            accessData.remove(string, "date");
            accessData.remove(string, "redirectsTo");
            if (l == 0L) {
                accessData.remove(string, "date");
                accessData.remove(string, "redirectsTo");
                accessData.put(string, ACCESSED_KEY, "");
            } else {
                accessData.remove(string, ACCESSED_KEY);
                accessData.remove(string, "redirectsTo");
                accessData.put(string, "date", String.valueOf(l));
            }
        }
    }
}

