/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.mime.identifier.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.semanticdesktop.aperture.mime.identifier.MimeTypeIdentifierFactory;
import org.semanticdesktop.aperture.mime.identifier.impl.MimeTypeIdentifierRegistryImpl;
import org.semanticdesktop.aperture.util.ResourceUtil;
import org.semanticdesktop.aperture.util.SimpleSAXAdapter;
import org.semanticdesktop.aperture.util.SimpleSAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DefaultMimeTypeIdentifierRegistry
extends MimeTypeIdentifierRegistryImpl {
    private static final String DEFAULT_FILE = "org/semanticdesktop/aperture/mime/identifier/impl/defaults.xml";
    private static final String IDENTIFIER_FACTORY_TAG = "mimeTypeIdentifierFactory";
    private static final String NAME_TAG = "name";

    public DefaultMimeTypeIdentifierRegistry() {
        try {
            InputStream inputStream = ResourceUtil.getInputStream(DEFAULT_FILE, DefaultMimeTypeIdentifierRegistry.class);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            this.parse(bufferedInputStream);
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("unable to parse org/semanticdesktop/aperture/mime/identifier/impl/defaults.xml", iOException);
        }
    }

    public DefaultMimeTypeIdentifierRegistry(InputStream inputStream) throws IOException {
        this.parse(inputStream);
    }

    private void parse(InputStream inputStream) throws IOException {
        try {
            SimpleSAXParser simpleSAXParser = new SimpleSAXParser();
            simpleSAXParser.setListener(new IdentifierParser());
            simpleSAXParser.parse(inputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException(parserConfigurationException.getMessage());
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException(sAXException.getMessage());
            iOException.initCause(sAXException);
            throw iOException;
        }
    }

    private class IdentifierParser
    extends SimpleSAXAdapter {
        private Logger logger = LoggerFactory.getLogger(this.getClass());
        private boolean insideFactoryElement = false;

        private IdentifierParser() {
        }

        public void startTag(String string, Map map, String string2) throws SAXException {
            if (DefaultMimeTypeIdentifierRegistry.IDENTIFIER_FACTORY_TAG.equals(string)) {
                this.insideFactoryElement = true;
            } else if (DefaultMimeTypeIdentifierRegistry.NAME_TAG.equals(string) && this.insideFactoryElement && string2 != null) {
                this.processClassName(string2);
            }
        }

        public void endTag(String string) {
            if (DefaultMimeTypeIdentifierRegistry.IDENTIFIER_FACTORY_TAG.equals(string)) {
                this.insideFactoryElement = false;
            }
        }

        private void processClassName(String string) {
            if (!(string = string.trim()).equals("")) {
                try {
                    Class<?> clazz = Class.forName(string);
                    Object obj = clazz.newInstance();
                    MimeTypeIdentifierFactory mimeTypeIdentifierFactory = (MimeTypeIdentifierFactory)obj;
                    DefaultMimeTypeIdentifierRegistry.this.add(mimeTypeIdentifierFactory);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.logger.warn("unable to find class " + string + ", ignoring", (Throwable)classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    this.logger.warn("unable to instantiate class " + string + ", ignoring", (Throwable)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.logger.warn("unable to access class " + string + ", ignoring", (Throwable)illegalAccessException);
                }
                catch (ClassCastException classCastException) {
                    this.logger.warn("unable to cast instance to " + MimeTypeIdentifierFactory.class.getName() + ", ignoring", (Throwable)classCastException);
                }
            }
        }
    }
}

