/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.websites.flickr;

import com.aetrion.flickr.Flickr;
import com.aetrion.flickr.FlickrException;
import com.aetrion.flickr.REST;
import com.aetrion.flickr.Transport;
import com.aetrion.flickr.contacts.Contact;
import com.aetrion.flickr.contacts.ContactsInterface;
import com.aetrion.flickr.people.PeopleInterface;
import com.aetrion.flickr.people.User;
import com.aetrion.flickr.photos.Photo;
import com.aetrion.flickr.photos.PhotoList;
import com.aetrion.flickr.photosets.Photoset;
import com.aetrion.flickr.photosets.PhotosetsInterface;
import com.aetrion.flickr.tags.Tag;
import com.aetrion.flickr.tags.TagsInterface;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.semanticdesktop.aperture.websites.AbstractTagCrawler;
import org.semanticdesktop.aperture.websites.flickr.FlickrDataSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlickrCrawler
extends AbstractTagCrawler {
    Flickr flickr;
    User user;
    String username;
    private final String API_ID = "f47691529440669449065e6962e1346a";
    private static final Logger LOGGER = Logger.getLogger(FlickrCrawler.class.getName());
    private final String FLICKR_URI = "http://www.flickr.com/photos/";
    public static final String PHOTONS = "http://example.com/photos#";

    public FlickrCrawler(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    private boolean crawlFriends(String string, Flickr flickr) throws IOException, SAXException, FlickrException {
        ContactsInterface contactsInterface = flickr.getContactsInterface();
        Collection collection = contactsInterface.getPublicList(string);
        for (Contact contact : collection) {
            LOGGER.info("frient found: " + contact.getId() + " ," + contact.getUsername());
        }
        return true;
    }

    @Override
    protected List<String> crawlTags(String string, String string2) throws IOException, SAXException, FlickrException, ParserConfigurationException {
        this.username = string;
        LOGGER.fine("Starting import images from Flickr...");
        TagsInterface tagsInterface = this.getFlickr().getTagsInterface();
        Collection collection = tagsInterface.getListUser(this.getUser().getId());
        LOGGER.fine("Found " + collection.size() + " tags for flickr user " + string);
        Vector<String> vector = new Vector<String>();
        for (Tag tag : collection) {
            String string3 = "http://www.flickr.com/photos/" + string + "/tags/" + tag.getValue();
            vector.add(string3);
        }
        return vector;
    }

    private boolean crawlImages() throws IOException, SAXException, FlickrException, ParserConfigurationException {
        Collection collection = this.flickr.getPhotosetsInterface().getList(this.getUser().getId()).getPhotosets();
        for (Photoset photoset : collection) {
            String string = photoset.getId();
            this.getPhotosFromSet(string, this.getFlickr());
        }
        this.addPhotosNotInSet();
        return true;
    }

    private void addPhotosNotInSet() throws IOException, SAXException, FlickrException {
        int n = 500;
        int n2 = 0;
        PhotoList photoList = this.flickr.getPhotosInterface().getNotInSet(n, n2);
        for (Photo photo : photoList) {
            LOGGER.info("photo found: " + photo.getId() + " ," + photo.getDescription());
        }
    }

    private void getPhotosFromSet(String string, Flickr flickr) throws IOException, SAXException, FlickrException {
        PhotosetsInterface photosetsInterface = flickr.getPhotosetsInterface();
        PhotoList photoList = photosetsInterface.getPhotos(string, 0, Integer.MAX_VALUE);
        for (Photo photo : photoList) {
            LOGGER.info("photo found: " + photo.getId() + " ," + photo.getDescription());
            this.crawlPhoto(photo);
        }
    }

    private void crawlPhoto(Photo photo) throws FlickrException, IOException, SAXException {
        LOGGER.finest("handling original url: " + photo.getOriginalUrl());
        URIImpl uRIImpl = new URIImpl(photo.getOriginalUrl());
        RDFContainer rDFContainer = this.getRDFContainerFactory(photo.getUrl()).getRDFContainer((URI)uRIImpl);
        rDFContainer.add(RDF.type, (Node)new URIImpl("http://example.com/photos#Photo"));
        String string = photo.getTitle();
        if (string != null) {
            rDFContainer.put(NIE.title, string);
            rDFContainer.put(RDFS.label, string);
        }
        photo = this.flickr.getPhotosInterface().getPhoto(photo.getId(), photo.getSecret());
        photo.getDateAdded();
        photo.getGeoData();
        DataObjectBase dataObjectBase = new DataObjectBase((URI)uRIImpl, this.source, rDFContainer);
        this.reportNewDataObject(dataObjectBase);
    }

    @Override
    protected void crawlTheRest(String string, String string2) throws Exception {
        FlickrDataSource.CrawlType crawlType = ((FlickrDataSource)this.source).getCrawlType();
        if (crawlType != null && (crawlType.equals((Object)FlickrDataSource.CrawlType.ItemsAndTagsCrawlType) || crawlType.equals((Object)FlickrDataSource.CrawlType.ItemsAndTagsCrawlType))) {
            this.username = string;
            this.crawlImages();
        }
    }

    public Flickr getFlickr() throws ParserConfigurationException {
        if (this.flickr == null) {
            this.flickr = new Flickr("f47691529440669449065e6962e1346a", (Transport)new REST("www.flickr.com", 80));
        }
        return this.flickr;
    }

    public User getUser() throws IOException, SAXException, FlickrException {
        if (this.user == null) {
            PeopleInterface peopleInterface = this.flickr.getPeopleInterface();
            this.user = peopleInterface.findByUsername(this.username);
        }
        return this.user;
    }
}

