/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.disk;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.Base64;
import org.modeshape.common.util.FileUtil;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.ObjectUtil;
import org.modeshape.connector.disk.DiskNode;
import org.modeshape.connector.disk.DiskRepository;
import org.modeshape.graph.connector.base.MapNode;
import org.modeshape.graph.connector.base.MapWorkspace;
import org.modeshape.graph.connector.base.Node;
import org.modeshape.graph.connector.base.NodeCachingWorkspace;
import org.modeshape.graph.connector.base.cache.NodeCache;
import org.modeshape.graph.connector.base.cache.NodeCachePolicy;
import org.modeshape.graph.connector.base.cache.NodeCachePolicyChangedEvent;
import org.modeshape.graph.connector.base.cache.NodeCachePolicyChangedListener;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.BinaryFactory;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.basic.FileSystemBinary;

public class DiskWorkspace
extends MapWorkspace<DiskNode>
implements NodeCachingWorkspace<UUID, DiskNode> {
    private static final byte CURRENT_VERSION = 1;
    private static final String DATA_EXTENSION = ".dat";
    private static final String BACK_REFERENCE_EXTENSION = ".ref";
    private final File workspaceRoot;
    private final DiskRepository repository;
    private final BinaryFactory binFactory;
    private final PropertyFactory propFactory;
    private NodeCache<UUID, DiskNode> cache;
    private NodeCachePolicy<UUID, DiskNode> policy;

    public DiskWorkspace(String name, File workspaceRoot, DiskNode rootNode, DiskRepository repository) {
        super(name, (MapNode)rootNode);
        assert (repository != null);
        assert (rootNode != null);
        assert (workspaceRoot != null);
        this.workspaceRoot = workspaceRoot;
        this.repository = repository;
        this.propFactory = repository.getContext().getPropertyFactory();
        this.binFactory = repository.getContext().getValueFactories().getBinaryFactory();
        this.policy = repository.diskSource().getNodeCachePolicy();
        this.cache = this.policy.newCache();
        File rootNodeFile = this.fileFor(rootNode.getUuid());
        if (!rootNodeFile.exists()) {
            this.putNode(rootNode);
        }
        repository.diskSource().addNodeCachePolicyChangedListener((NodeCachePolicyChangedListener)this);
    }

    public DiskWorkspace(String name, File workspaceRoot, DiskWorkspace originalToClone) {
        super(name, (MapWorkspace)originalToClone);
        assert (originalToClone != null);
        assert (workspaceRoot != null);
        this.workspaceRoot = workspaceRoot;
        this.repository = originalToClone.repository;
        this.policy = this.repository.diskSource().getNodeCachePolicy();
        this.cache = this.policy.newCache();
        this.propFactory = this.repository.getContext().getPropertyFactory();
        this.binFactory = this.repository.getContext().getValueFactories().getBinaryFactory();
        this.repository.diskSource().addNodeCachePolicyChangedListener((NodeCachePolicyChangedListener)this);
    }

    public void destroy() {
        FileUtil.delete((File)this.workspaceRoot);
        this.repository.diskSource().removeNodeCachePolicyChangedListener((NodeCachePolicyChangedListener)this);
    }

    public void shutdown() {
        this.cache.close();
    }

    public void cachePolicyChanged(NodeCachePolicyChangedEvent<UUID, DiskNode> event) {
        this.policy = event.getNewPolicy();
        this.cache = this.policy.newCache();
    }

    public NodeCache<UUID, DiskNode> getCache() {
        return this.cache;
    }

    public DiskNode getNode(UUID uuid) {
        DiskNode node = (DiskNode)this.cache.get((Object)uuid);
        if (node != null) {
            return node;
        }
        File nodeFile = this.fileFor(uuid);
        if (!nodeFile.exists()) {
            return null;
        }
        node = this.nodeFor(nodeFile);
        if (node != null) {
            this.cache.put((Object)uuid, (Node)node);
        }
        return node;
    }

    public DiskNode putNode(DiskNode node) {
        this.writeNode(node);
        this.cache.put((Object)node.getUuid(), (Node)node);
        return node;
    }

    public void removeAll() {
        this.workspaceRoot.delete();
        this.workspaceRoot.mkdir();
        this.cache = this.policy.newCache();
    }

    public DiskNode removeNode(UUID uuid) {
        File nodeFile = this.fileFor(uuid);
        if (!nodeFile.exists()) {
            return null;
        }
        DiskNode node = this.nodeFor(nodeFile);
        nodeFile.delete();
        this.cache.remove((Object)uuid);
        return node;
    }

    private File fileFor(UUID uuid) {
        String uuidAsString = uuid.toString();
        File firstLevel = new File(this.workspaceRoot, uuidAsString.substring(0, 2));
        File secondLevel = new File(firstLevel, uuidAsString.substring(2, 4));
        File file = new File(secondLevel, uuidAsString);
        if (!file.exists() && !secondLevel.exists()) {
            if (!firstLevel.exists()) {
                firstLevel.mkdir();
            }
            secondLevel.mkdir();
        }
        return file;
    }

    private DiskNode nodeFor(File nodeFile) {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(nodeFile));
            byte version = ois.readByte();
            assert (version == 1);
            UUID uuid = (UUID)ois.readObject();
            Path.Segment name = (Path.Segment)ois.readObject();
            UUID parent = (UUID)ois.readObject();
            List children = (List)ois.readObject();
            Map rawProps = (Map)ois.readObject();
            DiskNode diskNode = new DiskNode(uuid, name, parent, rawProps, (List<UUID>)children);
            return diskNode;
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException(cnfe);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception ignore) {}
        }
    }

    private Object adjustValueForLargeValueThreshold(Object value, long largeValueThreshold, Collection<String> largeValueKeysInUse, UUID nodeUuid) throws IOException, ClassNotFoundException {
        if (value != null && value instanceof Binary) {
            Binary binValue = (Binary)value;
            if (value instanceof FileSystemBinary) {
                String key = this.keyFor(binValue);
                if (binValue.getSize() <= largeValueThreshold) {
                    Object newValue = this.binFactory.create(binValue.getStream(), binValue.getSize());
                    return newValue;
                }
                largeValueKeysInUse.add(key);
            } else if (binValue.getSize() > largeValueThreshold) {
                File largeValueFile = this.addOrUpdateLargeValueAreaFor(binValue, nodeUuid);
                largeValueKeysInUse.add(this.keyFor(binValue));
                return new FileSystemBinary(largeValueFile);
            }
        }
        return value;
    }

    private File addOrUpdateLargeValueAreaFor(Binary binary, UUID nodeUuid) throws IOException, ClassNotFoundException {
        String key = this.keyFor(binary);
        File largeValueFile = new File(this.repository.largeValuesRoot(), key + DATA_EXTENSION);
        File largeValueFileRefs = new File(this.repository.largeValuesRoot(), key + BACK_REFERENCE_EXTENSION);
        if (largeValueFile.exists()) {
            assert (largeValueFileRefs.exists());
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(largeValueFileRefs));
            ValueReferences valueRefs = (ValueReferences)ois.readObject();
            ois.close();
            assert (valueRefs != null);
            ValueReference valueRef = new ValueReference(this.getName(), nodeUuid);
            if (!valueRefs.hasReference(valueRef)) {
                valueRefs = valueRefs.withReference(valueRef);
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(largeValueFileRefs));
                oos.writeObject(valueRefs);
                oos.close();
            }
        } else {
            FileOutputStream fos = new FileOutputStream(largeValueFile);
            IoUtil.write((InputStream)binary.getStream(), (OutputStream)fos);
            fos.close();
            ValueReference valueRef = new ValueReference(this.getName(), nodeUuid);
            ValueReferences valueRefs = new ValueReferences(valueRef);
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(largeValueFileRefs));
            oos.writeObject(valueRefs);
            oos.close();
        }
        return largeValueFile;
    }

    private String keyFor(Binary value) {
        try {
            String key = Base64.encodeBytes((byte[])value.getHash(), (int)16);
            assert (key.indexOf(47) == -1) : "Bad hash " + key + " for value " + new String(value.getBytes());
            return key;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private Map<Name, Property> adjustedPropertiesFor(DiskNode node) throws IOException, ClassNotFoundException {
        HashMap<Name, Property> adjustedProps;
        HashSet<String> largeValueKeysInUse = new HashSet<String>();
        long largeValueThreshold = this.repository.diskSource().getLargeValueSizeInBytes();
        if (largeValueThreshold > 0L) {
            adjustedProps = new HashMap<Name, Property>(node.getProperties().size());
            for (Map.Entry entry : node.getProperties().entrySet()) {
                Property prop = (Property)entry.getValue();
                ArrayList<Object> newValues = new ArrayList<Object>(prop.size());
                boolean requiresChange = false;
                for (Object value : prop) {
                    Object newValue = this.adjustValueForLargeValueThreshold(value, largeValueThreshold, largeValueKeysInUse, node.getUuid());
                    if (newValue != value) {
                        requiresChange = true;
                        newValues.add(newValue);
                        continue;
                    }
                    newValues.add(value);
                }
                if (requiresChange) {
                    adjustedProps.put((Name)entry.getKey(), this.propFactory.create((Name)entry.getKey(), newValues));
                    continue;
                }
                adjustedProps.put((Name)entry.getKey(), (Property)entry.getValue());
            }
        } else {
            adjustedProps = node.getProperties();
        }
        HashSet<String> removedKeys = new HashSet<String>(node.largeValueHashesInUse());
        removedKeys.removeAll(largeValueKeysInUse);
        for (String key : removedKeys) {
            File largeValueFileRefs = new File(this.repository.largeValuesRoot(), key + BACK_REFERENCE_EXTENSION);
            assert (largeValueFileRefs.exists());
            ValueReferences valueRefs = null;
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(largeValueFileRefs));
                valueRefs = (ValueReferences)ois.readObject();
                ois.close();
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalStateException(cnfe);
            }
            assert (valueRefs != null);
            ValueReference valueRef = new ValueReference(this.getName(), node.getUuid());
            if ((valueRefs = valueRefs.withoutReference(valueRef)).hasRemainingReferences()) {
                ObjectOutputStream roos = new ObjectOutputStream(new FileOutputStream(largeValueFileRefs));
                roos.writeObject(valueRefs);
                roos.close();
                continue;
            }
            File largeValueFile = new File(this.repository.largeValuesRoot(), key + DATA_EXTENSION);
            largeValueFileRefs.delete();
            largeValueFile.delete();
        }
        return adjustedProps;
    }

    private File writeNode(DiskNode node) {
        ObjectOutputStream oos = null;
        try {
            Map<Name, Property> adjustedProps = this.adjustedPropertiesFor(node);
            File nodeFile = this.fileFor(node.getUuid());
            oos = new ObjectOutputStream(new FileOutputStream(nodeFile));
            oos.writeByte(1);
            oos.writeObject(node.getUuid());
            oos.writeObject(node.getName());
            oos.writeObject(node.getParent());
            oos.writeObject(node.getChildren());
            oos.writeObject(adjustedProps);
            File file = nodeFile;
            return file;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException(cnfe);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception ignore) {}
        }
    }

    @NotThreadSafe
    static class ValueReferences
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Set<ValueReference> references;

        ValueReferences(ValueReference reference) {
            this.references = new HashSet<ValueReference>();
            this.references.add(reference);
        }

        ValueReferences(Set<ValueReference> references) {
            this.references = references;
        }

        ValueReferences withoutReference(ValueReference reference) {
            if (!this.references.contains(reference)) {
                return this;
            }
            HashSet<ValueReference> newRefs = new HashSet<ValueReference>(this.references);
            newRefs.remove(reference);
            return new ValueReferences(newRefs);
        }

        ValueReferences withReference(ValueReference reference) {
            if (this.references.contains(reference)) {
                return this;
            }
            HashSet<ValueReference> newRefs = new HashSet<ValueReference>(this.references);
            newRefs.add(reference);
            return new ValueReferences(newRefs);
        }

        boolean hasRemainingReferences() {
            return !this.references.isEmpty();
        }

        boolean hasReference(ValueReference ref) {
            return this.references.contains(ref);
        }

        public int hashCode() {
            return ((Object)this.references).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ValueReferences) {
                ValueReferences that = (ValueReferences)obj;
                return ((Object)this.references).equals(that.references);
            }
            return false;
        }

        public String toString() {
            return this.references.toString();
        }
    }

    @Immutable
    static class ValueReference
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String workspaceName;
        private final UUID owningNodeUuid;

        ValueReference(String workspaceName, UUID owningNodeUuid) {
            this.workspaceName = workspaceName;
            this.owningNodeUuid = owningNodeUuid;
        }

        public int hashCode() {
            return this.owningNodeUuid.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ValueReference) {
                ValueReference other = (ValueReference)obj;
                return ObjectUtil.isEqualWithNulls((Object)this.owningNodeUuid, (Object)other.owningNodeUuid) && ObjectUtil.isEqualWithNulls((Object)this.workspaceName, (Object)other.workspaceName);
            }
            return false;
        }

        public String toString() {
            return this.owningNodeUuid + " @ " + this.workspaceName;
        }
    }
}

