/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.modeshape.common.annotation.ThreadSafe;

@ThreadSafe
public class EntityManagers {
    private final Map<EntityManager, AtomicInteger> referenceCounts = new HashMap<EntityManager, AtomicInteger>();
    private EntityManagerFactory factory;
    private boolean canClose = false;

    EntityManagers(EntityManagerFactory factory) {
        this.factory = factory;
    }

    public synchronized EntityManager checkout() {
        EntityManager manager;
        if (this.factory == null) {
            assert (this.referenceCounts.isEmpty());
            this.canClose = false;
        }
        if (this.referenceCounts.containsKey(manager = this.factory.createEntityManager())) {
            this.referenceCounts.get(manager).incrementAndGet();
        } else {
            this.referenceCounts.put(manager, new AtomicInteger(1));
        }
        return manager;
    }

    public synchronized void checkin(EntityManager manager) {
        if (manager == null) {
            return;
        }
        AtomicInteger count = this.referenceCounts.get(manager);
        assert (count != null);
        count.decrementAndGet();
        assert (count.get() >= 0);
        if (count.get() == 0 && this.referenceCounts.remove(manager) != null) {
            manager.close();
        }
        this.closeFactoryIfNoManagersCheckedOut();
    }

    public synchronized void close() {
        this.canClose = true;
        this.closeFactoryIfNoManagersCheckedOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeNow() {
        this.canClose = true;
        try {
            for (EntityManager manager : this.referenceCounts.keySet()) {
                manager.close();
            }
            this.referenceCounts.clear();
        }
        finally {
            try {
                this.factory.close();
            }
            finally {
                this.factory = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFactoryIfNoManagersCheckedOut() {
        if (this.referenceCounts.isEmpty() && this.canClose && this.factory != null) {
            try {
                this.factory.close();
            }
            finally {
                this.factory = null;
            }
        }
    }
}

