/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.image;

import java.io.InputStream;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.image.ImageMetadata;
import org.modeshape.sequencer.image.ImageMetadataLexicon;

public class ImageMetadataSequencer
implements StreamSequencer {
    public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
        ImageMetadata metadata = new ImageMetadata();
        metadata.setInput(stream);
        metadata.setDetermineImageNumber(true);
        metadata.setCollectComments(true);
        if (!metadata.check()) {
            metadata = null;
        }
        if (metadata != null) {
            PathFactory pathFactory = context.getValueFactories().getPathFactory();
            Path metadataNode = pathFactory.createRelativePath(new Name[]{ImageMetadataLexicon.METADATA_NODE});
            output.setProperty(metadataNode, JcrLexicon.PRIMARY_TYPE, new Object[]{"image:metadata"});
            output.setProperty(metadataNode, JcrLexicon.MIMETYPE, new Object[]{metadata.getMimeType()});
            output.setProperty(metadataNode, ImageMetadataLexicon.FORMAT_NAME, new Object[]{metadata.getFormatName()});
            output.setProperty(metadataNode, ImageMetadataLexicon.WIDTH, new Object[]{metadata.getWidth()});
            output.setProperty(metadataNode, ImageMetadataLexicon.HEIGHT, new Object[]{metadata.getHeight()});
            output.setProperty(metadataNode, ImageMetadataLexicon.BITS_PER_PIXEL, new Object[]{metadata.getBitsPerPixel()});
            output.setProperty(metadataNode, ImageMetadataLexicon.PROGRESSIVE, new Object[]{metadata.isProgressive()});
            output.setProperty(metadataNode, ImageMetadataLexicon.NUMBER_OF_IMAGES, new Object[]{metadata.getNumberOfImages()});
            output.setProperty(metadataNode, ImageMetadataLexicon.PHYSICAL_WIDTH_DPI, new Object[]{metadata.getPhysicalWidthDpi()});
            output.setProperty(metadataNode, ImageMetadataLexicon.PHYSICAL_HEIGHT_DPI, new Object[]{metadata.getPhysicalHeightDpi()});
            output.setProperty(metadataNode, ImageMetadataLexicon.PHYSICAL_WIDTH_INCHES, new Object[]{Float.valueOf(metadata.getPhysicalWidthInch())});
            output.setProperty(metadataNode, ImageMetadataLexicon.PHYSICAL_HEIGHT_INCHES, new Object[]{Float.valueOf(metadata.getPhysicalHeightInch())});
        }
    }
}

