/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.accessor.base;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.semanticdesktop.aperture.accessor.AccessData;
import org.semanticdesktop.aperture.util.ArrayMap;

public class AccessDataImpl
implements AccessData {
    private static final String TIMESTAMP_KEY = "aperture.timestamp";
    private String crawlIdentifier;
    protected Map<String, Map<String, String>> idMap;
    protected Map<String, Set<String>> referredIDMap;
    protected Map<String, AggregationNode> aggregatedIDMap;

    public void initialize() throws IOException {
        if (this.idMap == null) {
            this.idMap = new HashMap<String, Map<String, String>>(1024);
        }
        if (this.referredIDMap == null) {
            this.referredIDMap = new HashMap<String, Set<String>>(1024);
        }
        if (this.aggregatedIDMap == null) {
            this.aggregatedIDMap = new HashMap<String, AggregationNode>(1024);
        }
        this.crawlIdentifier = UUID.randomUUID().toString();
    }

    public void store() throws IOException {
    }

    public void clear() throws IOException {
        this.idMap = null;
        this.referredIDMap = null;
        this.aggregatedIDMap = null;
    }

    public int getSize() {
        return this.getStoredIDs().size();
    }

    public Set getStoredIDs() {
        HashSet<String> hashSet = new HashSet<String>(this.idMap.keySet());
        hashSet.addAll(this.referredIDMap.keySet());
        hashSet.addAll(this.aggregatedIDMap.keySet());
        return hashSet;
    }

    public boolean isKnownId(String string) {
        return this.idMap.containsKey(string) || this.referredIDMap.containsKey(string) || this.aggregatedIDMap.containsKey(string);
    }

    public void put(String string, String string2, String string3) {
        ArrayMap arrayMap = this.createInfoMap(string);
        arrayMap.put(string2, string3);
    }

    public void putReferredID(String string, String string2) {
        Set<String> set = this.referredIDMap.get(string);
        if (set == null) {
            set = new HashSet<String>();
            this.referredIDMap.put(string, set);
        }
        set.add(string2);
    }

    public String get(String string, String string2) {
        ArrayMap arrayMap = (ArrayMap)this.idMap.get(string);
        if (arrayMap == null) {
            return null;
        }
        return (String)arrayMap.get(string2);
    }

    public Set getReferredIDs(String string) {
        return this.referredIDMap.get(string);
    }

    public void remove(String string, String string2) {
        ArrayMap arrayMap = (ArrayMap)this.idMap.get(string);
        if (arrayMap != null) {
            arrayMap.remove(string2);
        }
    }

    public void removeReferredID(String string, String string2) {
        HashSet hashSet = (HashSet)this.referredIDMap.get(string);
        if (hashSet != null) {
            hashSet.remove(string2);
            if (hashSet.isEmpty()) {
                this.referredIDMap.remove(string);
            }
        }
    }

    public void removeReferredIDs(String string) {
        this.referredIDMap.remove(string);
    }

    public void remove(String string) {
        this.idMap.remove(string);
        this.referredIDMap.remove(string);
        AggregationNode aggregationNode = this.aggregatedIDMap.get(string);
        if (aggregationNode != null) {
            if (aggregationNode.parent != null) {
                this.aggregatedIDMap.get(aggregationNode.parent).children.remove(string);
            }
            Set set = this.getAggregatedIDs(string);
            for (Object e : set) {
                this.remove(e.toString());
            }
            this.aggregatedIDMap.remove(string);
        }
    }

    private ArrayMap createInfoMap(String string) {
        ArrayMap arrayMap = (ArrayMap)this.idMap.get(string);
        if (arrayMap == null) {
            arrayMap = new ArrayMap();
            this.idMap.put(string, arrayMap);
        }
        return arrayMap;
    }

    public Set getAggregatedIDs(String string) {
        AggregationNode aggregationNode = this.aggregatedIDMap.get(string);
        if (aggregationNode == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(aggregationNode.children);
    }

    public void putAggregatedID(String string, String string2) {
        AggregationNode aggregationNode = this.aggregatedIDMap.get(string);
        AggregationNode aggregationNode2 = this.aggregatedIDMap.get(string2);
        if (aggregationNode == null) {
            aggregationNode = new AggregationNode(null);
            this.aggregatedIDMap.put(string, aggregationNode);
        }
        if (aggregationNode2 == null) {
            aggregationNode2 = new AggregationNode(string);
            this.aggregatedIDMap.put(string2, aggregationNode2);
        } else {
            String string3 = aggregationNode2.parent;
            if (string3 != null && !string3.equals(string)) {
                AggregationNode aggregationNode3 = this.aggregatedIDMap.get(string3);
                aggregationNode3.children.remove(string2);
                aggregationNode2.parent = string;
            }
        }
        aggregationNode.children.add(string2);
    }

    public void removeAggregatedID(String string, String string2) {
        AggregationNode aggregationNode = this.aggregatedIDMap.get(string);
        AggregationNode aggregationNode2 = this.aggregatedIDMap.get(string2);
        if (aggregationNode != null) {
            aggregationNode.children.remove(string2);
        }
        this.aggregatedIDMap.remove(string2);
    }

    public ClosableIterator getUntouchedIDsIterator() {
        return new UntouchedIterator(this.idMap.keySet().iterator());
    }

    public void removeUntouchedIDs() {
        Iterator<Map.Entry<String, Map<String, String>>> iterator = this.idMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Map<String, String>> entry = iterator.next();
            String string = entry.getKey();
            if (this.isTouched(string)) continue;
            iterator.remove();
            this.referredIDMap.remove(string);
            this.detachFromParent(string);
            this.aggregatedIDMap.remove(string);
        }
    }

    public void touchRecursively(String string) {
        this.touch(string);
        AggregationNode aggregationNode = this.aggregatedIDMap.get(string);
        if (aggregationNode != null) {
            for (String string2 : aggregationNode.children) {
                this.touchRecursively(string2);
            }
        }
    }

    public void touch(String string) {
        ArrayMap arrayMap = this.createInfoMap(string);
        arrayMap.put(TIMESTAMP_KEY, this.crawlIdentifier);
        arrayMap = null;
    }

    public ClosableIterator getAggregatedIDsClosure(String string) {
        return new AggregatedClosureIterator(string);
    }

    public boolean isTouched(String string) {
        ArrayMap arrayMap = (ArrayMap)this.idMap.get(string);
        return arrayMap != null && arrayMap.get(TIMESTAMP_KEY) != null && arrayMap.get(TIMESTAMP_KEY).equals(this.crawlIdentifier);
    }

    void detachFromParent(String string) {
        AggregationNode aggregationNode = this.aggregatedIDMap.get(string);
        if (aggregationNode != null && aggregationNode.parent != null) {
            AggregationNode aggregationNode2 = this.aggregatedIDMap.get(aggregationNode.parent);
            if (aggregationNode2 != null) {
                aggregationNode2.children.remove(string);
            }
            aggregationNode.parent = null;
        }
    }

    private class AggregatedClosureIterator
    implements ClosableIterator {
        private List<Iterator<String>> iteratorStack;
        private String nextValue;

        public AggregatedClosureIterator(String string) {
            this.nextValue = string;
            this.iteratorStack = new LinkedList<Iterator<String>>();
        }

        public boolean hasNext() {
            return this.nextValue != null;
        }

        public Object next() {
            String string = this.nextValue;
            this.nextValue = null;
            AggregationNode aggregationNode = AccessDataImpl.this.aggregatedIDMap.get(string);
            if (aggregationNode != null) {
                this.iteratorStack.add(0, aggregationNode.children.iterator());
            }
            while (this.iteratorStack.size() > 0) {
                Iterator<String> iterator = this.iteratorStack.get(0);
                if (iterator.hasNext()) {
                    this.nextValue = iterator.next();
                    break;
                }
                this.iteratorStack.remove(0);
            }
            return string;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }
    }

    private class UntouchedIterator
    implements ClosableIterator {
        private Iterator wrappedIterator;
        private Object nextValue;

        public UntouchedIterator(Iterator iterator) {
            this.wrappedIterator = iterator;
        }

        public boolean hasNext() {
            this.getNextUntouched();
            return this.nextValue != null;
        }

        public Object next() {
            this.getNextUntouched();
            Object object = this.nextValue;
            this.nextValue = null;
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }

        private void getNextUntouched() {
            if (this.nextValue == null) {
                while (this.wrappedIterator.hasNext()) {
                    String string = (String)this.wrappedIterator.next();
                    if (AccessDataImpl.this.isTouched(string)) continue;
                    this.nextValue = string;
                    break;
                }
            }
        }
    }

    private static class AggregationNode {
        private String parent;
        private Set<String> children;

        public AggregationNode(String string) {
            this.parent = string;
            this.children = new HashSet<String>();
        }
    }
}

