/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.accessor.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticdesktop.aperture.accessor.DataAccessorFactory;
import org.semanticdesktop.aperture.accessor.DataAccessorRegistry;

public class DataAccessorRegistryImpl
implements DataAccessorRegistry {
    private HashMap factories = new HashMap();

    public void add(DataAccessorFactory dataAccessorFactory) {
        if (dataAccessorFactory == null) {
            throw new IllegalArgumentException("factory is not allowed to be null");
        }
        for (String string : dataAccessorFactory.getSupportedSchemes()) {
            HashSet<DataAccessorFactory> hashSet = (HashSet<DataAccessorFactory>)this.factories.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<DataAccessorFactory>();
                this.factories.put(string, hashSet);
            }
            hashSet.add(dataAccessorFactory);
        }
    }

    public void remove(DataAccessorFactory dataAccessorFactory) {
        for (String string : dataAccessorFactory.getSupportedSchemes()) {
            Set set = (Set)this.factories.get(string);
            if (set == null) continue;
            set.remove(dataAccessorFactory);
            if (!set.isEmpty()) continue;
            this.factories.remove(string);
        }
    }

    public Set getAll() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.factories.values().iterator();
        while (iterator.hasNext()) {
            hashSet.addAll((Set)iterator.next());
        }
        return hashSet;
    }

    public Set get(String string) {
        Set set = (Set)this.factories.get(string);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(set);
    }
}

