/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.semanticdesktop.aperture.crawler.CrawlReport;
import org.semanticdesktop.aperture.crawler.ExitCode;
import org.semanticdesktop.aperture.util.DateUtil;
import org.semanticdesktop.aperture.util.SimpleSAXAdapter;
import org.semanticdesktop.aperture.util.SimpleSAXParser;
import org.semanticdesktop.aperture.util.XmlWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class CrawlReportBase
implements CrawlReport {
    public static final String CRAWL_REPORT_TAG = "crawlReport";
    public static final String VERSION_ATTR = "version";
    public static final String CRAWL_STARTED_TAG = "crawlStarted";
    public static final String CRAWL_STOPPED_TAG = "crawlStopped";
    public static final String EXIT_CODE_TAG = "exitCode";
    public static final String COMPLETED_VALUE = "completed";
    public static final String STOP_REQUESTED_VALUE = "stopRequested";
    public static final String FATAL_ERROR_VALUE = "fatalError";
    public static final String NEW_COUNT_TAG = "newCount";
    public static final String CHANGED_COUNT_TAG = "changedCount";
    public static final String REMOVED_COUNT_TAG = "removedCount";
    public static final String UNCHANGED_COUNT_TAG = "unchangedCount";
    private long crawlStarted = -1L;
    private long crawlStopped = -1L;
    private ExitCode exitCode = null;
    private int newCount = 0;
    private int changedCount = 0;
    private int removedCount = 0;
    private int unchangedCount = 0;

    public void setCrawlStarted(long l) {
        this.crawlStarted = l;
    }

    public long getCrawlStarted() {
        return this.crawlStarted;
    }

    public void setCrawlStopped(long l) {
        this.crawlStopped = l;
    }

    public long getCrawlStopped() {
        return this.crawlStopped;
    }

    public void setExitCode(ExitCode exitCode) {
        this.exitCode = exitCode;
    }

    public ExitCode getExitCode() {
        return this.exitCode;
    }

    public void setNewCount(int n) {
        this.newCount = n;
    }

    public void increaseNewCount() {
        ++this.newCount;
    }

    public int getNewCount() {
        return this.newCount;
    }

    public void setChangedCount(int n) {
        this.changedCount = n;
    }

    public void increaseChangedCount() {
        ++this.changedCount;
    }

    public int getChangedCount() {
        return this.changedCount;
    }

    public void setRemovedCount(int n) {
        this.removedCount = n;
    }

    public void increaseRemovedCount() {
        ++this.removedCount;
    }

    public int getRemovedCount() {
        return this.removedCount;
    }

    public void setUnchangedCount(int n) {
        this.unchangedCount = n;
    }

    public void increaseUnchangedCount() {
        ++this.unchangedCount;
    }

    public int getUnchangedCount() {
        return this.unchangedCount;
    }

    public int getTotalCount() {
        return this.newCount + this.changedCount + this.unchangedCount;
    }

    public String toString() {
        return "CrawlReport[crawlStarted=" + this.crawlStarted + ", crawlStopped=" + this.crawlStopped + ", exitCode=" + this.exitCode + ", newCount=" + this.newCount + ", changedCount=" + this.changedCount + ", removedCount=" + this.removedCount + ", unchangedCount=" + this.unchangedCount + "]";
    }

    public void write(OutputStream outputStream) throws IOException {
        Object object;
        XmlWriter xmlWriter = new XmlWriter(outputStream);
        xmlWriter.setPrettyPrint(true);
        xmlWriter.startDocument();
        xmlWriter.setAttribute(VERSION_ATTR, "1.0");
        xmlWriter.startTag(CRAWL_REPORT_TAG);
        if (this.crawlStarted >= 0L) {
            object = new Date(this.crawlStarted);
            xmlWriter.textElement(CRAWL_STARTED_TAG, DateUtil.dateTime2String((Date)object));
        }
        if (this.crawlStopped >= 0L) {
            object = new Date(this.crawlStopped);
            xmlWriter.textElement(CRAWL_STOPPED_TAG, DateUtil.dateTime2String((Date)object));
        }
        if (this.exitCode != null) {
            object = null;
            if (this.exitCode.equals(ExitCode.COMPLETED)) {
                object = COMPLETED_VALUE;
            } else if (this.exitCode.equals(ExitCode.STOP_REQUESTED)) {
                object = STOP_REQUESTED_VALUE;
            } else if (this.exitCode.equals(ExitCode.FATAL_ERROR)) {
                object = FATAL_ERROR_VALUE;
            }
            if (object != null) {
                xmlWriter.textElement(EXIT_CODE_TAG, (String)object);
            }
        }
        if (this.newCount >= 0) {
            xmlWriter.textElement(NEW_COUNT_TAG, String.valueOf(this.newCount));
        }
        if (this.changedCount >= 0) {
            xmlWriter.textElement(CHANGED_COUNT_TAG, String.valueOf(this.changedCount));
        }
        if (this.removedCount >= 0) {
            xmlWriter.textElement(REMOVED_COUNT_TAG, String.valueOf(this.removedCount));
        }
        if (this.unchangedCount >= 0) {
            xmlWriter.textElement(UNCHANGED_COUNT_TAG, String.valueOf(this.unchangedCount));
        }
        xmlWriter.endTag(CRAWL_REPORT_TAG);
        xmlWriter.endDocument();
    }

    public void read(InputStream inputStream) throws IOException {
        try {
            SimpleSAXParser simpleSAXParser = new SimpleSAXParser();
            simpleSAXParser.setListener(new CrawlReportParser());
            simpleSAXParser.parse(inputStream);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException(parserConfigurationException.getMessage());
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException(sAXException.getMessage());
            iOException.initCause(sAXException);
            throw iOException;
        }
    }

    private class CrawlReportParser
    extends SimpleSAXAdapter {
        private Logger logger = LoggerFactory.getLogger(this.getClass());

        private CrawlReportParser() {
        }

        public void startTag(String string, Map map, String string2) throws SAXException {
            if (string2 != null && !string2.equals("")) {
                try {
                    this.handleTag(string, map, string2);
                }
                catch (Exception exception) {
                    throw new SAXException(exception);
                }
            }
        }

        private void handleTag(String string, Map map, String string2) {
            if (CrawlReportBase.CRAWL_STARTED_TAG.equals(string)) {
                try {
                    Date date = DateUtil.string2DateTime(string2);
                    CrawlReportBase.this.crawlStarted = date.getTime();
                }
                catch (ParseException parseException) {
                    this.logger.warn("invalid date: " + string2, (Throwable)parseException);
                }
            } else if (CrawlReportBase.CRAWL_STOPPED_TAG.equals(string)) {
                try {
                    Date date = DateUtil.string2DateTime(string2);
                    CrawlReportBase.this.crawlStopped = date.getTime();
                }
                catch (ParseException parseException) {
                    this.logger.warn("invalid date: " + string2, (Throwable)parseException);
                }
            } else if (CrawlReportBase.EXIT_CODE_TAG.equals(string)) {
                if (CrawlReportBase.COMPLETED_VALUE.equals(string2)) {
                    CrawlReportBase.this.exitCode = ExitCode.COMPLETED;
                } else if (CrawlReportBase.STOP_REQUESTED_VALUE.equals(string2)) {
                    CrawlReportBase.this.exitCode = ExitCode.STOP_REQUESTED;
                } else if (CrawlReportBase.FATAL_ERROR_VALUE.equals(string2)) {
                    CrawlReportBase.this.exitCode = ExitCode.FATAL_ERROR;
                } else {
                    this.logger.warn("unknown exit code: " + string2);
                }
            } else if (CrawlReportBase.NEW_COUNT_TAG.equals(string)) {
                CrawlReportBase.this.newCount = this.parseInt(string2, CrawlReportBase.this.newCount);
            } else if (CrawlReportBase.CHANGED_COUNT_TAG.equals(string)) {
                CrawlReportBase.this.changedCount = this.parseInt(string2, CrawlReportBase.this.changedCount);
            } else if (CrawlReportBase.REMOVED_COUNT_TAG.equals(string)) {
                CrawlReportBase.this.removedCount = this.parseInt(string2, CrawlReportBase.this.removedCount);
            } else if (CrawlReportBase.UNCHANGED_COUNT_TAG.equals(string)) {
                CrawlReportBase.this.unchangedCount = this.parseInt(string2, CrawlReportBase.this.unchangedCount);
            }
        }

        private int parseInt(String string, int n) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.logger.warn("invalid int: " + string, (Throwable)numberFormatException);
                return n;
            }
        }
    }
}

