/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.mail;

import com.beetstra.jutf7.CharsetProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Date;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.PlainLiteral;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NCO;

public class MailUtil {
    private static Charset utf7;
    private static final Charset normal;

    public static String utf7Encode(String string) {
        return MailUtil.performConversion(string, utf7, normal);
    }

    public static String utf7Decode(String string) {
        return MailUtil.performConversion(string, normal, utf7);
    }

    private static String performConversion(String string, Charset charset, Charset charset2) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() * 3);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, charset);
            outputStreamWriter.write(string);
            outputStreamWriter.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            StringBuilder stringBuilder = new StringBuilder(string.length() * 3);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(byArray), charset2);
            int n = 0;
            while ((n = inputStreamReader.read()) != -1) {
                stringBuilder.append((char)n);
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Date getDate(Message message) throws MessagingException {
        Date date = message.getSentDate();
        if (date == null && (date = message.getReceivedDate()) == null) {
            date = new Date();
        }
        return date;
    }

    public static void addAddressMetadata(InternetAddress internetAddress, URI uRI, RDFContainer rDFContainer) {
        String string;
        String string2 = internetAddress.getPersonal();
        if (string2 != null) {
            string2 = string2.trim();
        }
        if ((string = internetAddress.getAddress()) != null) {
            string = string.trim();
        }
        if (MailUtil.hasRealValue(string2) || MailUtil.hasRealValue(string)) {
            PlainLiteral plainLiteral;
            URI uRI2 = rDFContainer.getModel().createURI(MailUtil.getPersonURI(string, string2));
            rDFContainer.add(uRI, (Node)uRI2);
            rDFContainer.getModel().addStatement((Resource)uRI2, RDF.type, (Node)NCO.Contact);
            if (MailUtil.hasRealValue(string2)) {
                plainLiteral = rDFContainer.getModel().createPlainLiteral(string2);
                rDFContainer.getModel().addStatement((Resource)uRI2, NCO.fullname, (Node)plainLiteral);
            }
            if (MailUtil.hasRealValue(string)) {
                plainLiteral = rDFContainer.getModel().createPlainLiteral(string);
                URI uRI3 = rDFContainer.getModel().createURI(MailUtil.getEmailURI("mailto:", string));
                rDFContainer.getModel().addStatement((Resource)uRI2, NCO.hasEmailAddress, (Node)uRI3);
                rDFContainer.getModel().addStatement((Resource)uRI3, RDF.type, (Node)NCO.EmailAddress);
                rDFContainer.getModel().addStatement((Resource)uRI3, NCO.emailAddress, (Node)plainLiteral);
            }
        }
    }

    public static String getPersonURI(String string, String string2) throws IllegalArgumentException {
        if (MailUtil.hasRealValue(string2)) {
            return "emailperson:" + MailUtil.urlifyString(string2);
        }
        if (MailUtil.hasRealValue(string)) {
            return MailUtil.getEmailURI("emailperson:", string);
        }
        throw new IllegalArgumentException("no valid email or name, email = " + string + ", name = " + string2);
    }

    private static String getEmailURI(String string, String string2) throws IllegalArgumentException {
        if (MailUtil.hasRealValue(string2)) {
            if (!MailUtil.isValidEmailAddress(string2)) {
                return string + MailUtil.urlifyString(string2);
            }
            return string + string2;
        }
        throw new IllegalArgumentException("Email invalid");
    }

    private static boolean isValidEmailAddress(String string) {
        if (string.length() < 3) {
            return false;
        }
        if (string.indexOf("@") == -1) {
            return false;
        }
        if (string.indexOf(" ") != -1) {
            return false;
        }
        try {
            new URIImpl("mailto:" + string, true);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String urlifyString(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Really weird....", unsupportedEncodingException);
        }
    }

    private static boolean hasRealValue(String string) {
        return string != null && string.length() > 0;
    }

    static {
        try {
            utf7 = Charset.forName("X-MODIFIED-UTF-7");
        }
        catch (Exception exception) {
            try {
                utf7 = new CharsetProvider().charsetForName("X-MODIFIED-UTF-7");
            }
            catch (Exception exception2) {
                throw new RuntimeException("Cannot load X-MODIFIED-UTF-7, com.beetstra.jutf7.CharsetProvider problem: " + exception2, exception2);
            }
        }
        normal = Charset.forName("ISO-8859-1");
    }
}

