/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.publisher;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.util.PoiUtil;
import org.semanticdesktop.aperture.extractor.util.StringExtractor;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;

public class PublisherExtractor
implements Extractor {
    private static final String[] EXCLUDE_LINES = new String[]{"fdpc", "syid", "syidz", "chnkink", "btep", "btec", "font", "fontj", "mcld", "ontd", "quill96 story group class"};

    public void extract(URI uRI, InputStream inputStream, Charset charset, String string, RDFContainer rDFContainer) throws ExtractorException {
        try {
            inputStream = PoiUtil.extractMetadata(inputStream, true, rDFContainer);
        }
        catch (IOException iOException) {
            throw new ExtractorException(iOException);
        }
        FullTextExtractor fullTextExtractor = new FullTextExtractor();
        try {
            String string2 = fullTextExtractor.extract(inputStream).trim();
            if (string2.length() > 0) {
                rDFContainer.add(NIE.plainTextContent, string2);
            }
            rDFContainer.add(RDF.type, (Node)NFO.TextDocument);
        }
        catch (IOException iOException) {
            throw new ExtractorException(iOException);
        }
    }

    private static class FullTextExtractor
    extends StringExtractor {
        private FullTextExtractor() {
        }

        protected boolean isValidLine(String string) {
            for (int i = 0; i < EXCLUDE_LINES.length; ++i) {
                if (!string.equals(EXCLUDE_LINES[i])) continue;
                return false;
            }
            return super.isValidLine(string);
        }
    }
}

