/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.security.trustmanager.standard;

import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.semanticdesktop.aperture.security.trustdecider.Decision;
import org.semanticdesktop.aperture.security.trustdecider.TrustDecider;
import org.semanticdesktop.aperture.security.trustmanager.standard.CertificateStore;
import org.semanticdesktop.aperture.security.trustmanager.standard.PersistentCertificateStore;
import org.semanticdesktop.aperture.security.trustmanager.standard.RootCertificateStore;
import org.semanticdesktop.aperture.security.trustmanager.standard.SessionCertificateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardTrustManager
implements X509TrustManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ROOT_CERTIFICATES_FILE_NAME;
    private static final String JSSE_ROOT_CERTIFICATES_FILE_NAME;
    private CertificateStore sessionCertificateStore = new SessionCertificateStore();
    private CertificateStore deniedCertificateStore = new SessionCertificateStore();
    private CertificateStore rootCertificateStore = new RootCertificateStore(ROOT_CERTIFICATES_FILE_NAME);
    private CertificateStore jsseRootCertificateStore = new RootCertificateStore(JSSE_ROOT_CERTIFICATES_FILE_NAME);
    private CertificateStore persistentCertificateStore;
    private X509TrustManager defaultTrustManager;
    private TrustDecider trustDecider;

    public StandardTrustManager() throws CertificateException, KeyStoreException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        this(null, null);
    }

    public StandardTrustManager(File file, char[] cArray) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException, NoSuchProviderException {
        this.persistentCertificateStore = file == null ? new SessionCertificateStore() : new PersistentCertificateStore(file, cArray);
        this.sessionCertificateStore.load();
        this.deniedCertificateStore.load();
        this.rootCertificateStore.load();
        this.jsseRootCertificateStore.load();
        this.persistentCertificateStore.load();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
        trustManagerFactory.init((KeyStore)null);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        this.defaultTrustManager = (X509TrustManager)trustManagerArray[0];
    }

    public void setTrustDecider(TrustDecider trustDecider) {
        this.trustDecider = trustDecider;
    }

    public TrustDecider getTrustDecider() {
        return this.trustDecider;
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkChain(x509CertificateArray, string, true);
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkChain(x509CertificateArray, string, false);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }

    private synchronized void checkChain(X509Certificate[] x509CertificateArray, String string, boolean bl) throws CertificateException {
        boolean bl2 = false;
        boolean bl3 = false;
        Decision decision = null;
        try {
            if (this.deniedCertificateStore.contains(x509CertificateArray[0])) {
                throw new CertificateException("certificate has been denied");
            }
            try {
                if (bl) {
                    this.defaultTrustManager.checkClientTrusted(x509CertificateArray, string);
                } else {
                    this.defaultTrustManager.checkServerTrusted(x509CertificateArray, string);
                }
                return;
            }
            catch (CertificateException certificateException) {
                X509Certificate x509Certificate;
                if (this.sessionCertificateStore.contains(x509CertificateArray[0])) {
                    return;
                }
                if (this.persistentCertificateStore.contains(x509CertificateArray[0])) {
                    return;
                }
                for (int i = 0; i < x509CertificateArray.length; ++i) {
                    x509Certificate = x509CertificateArray[i];
                    if (!this.jsseRootCertificateStore.verify(x509Certificate) && !this.rootCertificateStore.verify(x509Certificate)) {
                        bl2 = true;
                    }
                    try {
                        x509Certificate.checkValidity();
                        continue;
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        bl3 = true;
                        continue;
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        bl3 = true;
                    }
                }
                TrustDecider trustDecider = this.getTrustDecider();
                if (trustDecider == null) {
                    throw new CertificateException("trust could not be established");
                }
                decision = trustDecider.decide(x509CertificateArray, bl2, bl3);
                x509Certificate = x509CertificateArray[0];
                if (Decision.TRUST_THIS_SESSION.equals(decision)) {
                    this.sessionCertificateStore.add(x509Certificate);
                    this.sessionCertificateStore.save();
                } else if (Decision.TRUST_ALWAYS.equals(decision)) {
                    this.persistentCertificateStore.add(x509Certificate);
                    this.persistentCertificateStore.save();
                } else {
                    this.deniedCertificateStore.add(x509Certificate);
                    this.deniedCertificateStore.save();
                }
            }
        }
        catch (CertificateException certificateException) {
            throw certificateException;
        }
        catch (Throwable throwable) {
            this.logger.error("Unexpected throwable while verifying certificate", throwable);
        }
        if (!Decision.TRUST_THIS_SESSION.equals(decision) && !Decision.TRUST_ALWAYS.equals(decision)) {
            throw new CertificateException("trust manager could not trust certificate chain");
        }
    }

    static {
        String string = System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator;
        ROOT_CERTIFICATES_FILE_NAME = string + "cacerts";
        JSSE_ROOT_CERTIFICATES_FILE_NAME = string + "jssecacerts";
    }
}

