/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.ListMap;
import org.semanticdesktop.aperture.vocabulary.DATASOURCE;
import org.semanticdesktop.aperture.vocabulary.FRESNEL;
import org.semanticdesktop.aperture.vocabulary.GEO;
import org.semanticdesktop.aperture.vocabulary.NAO;
import org.semanticdesktop.aperture.vocabulary.NCAL;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NEXIF;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NID3;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.semanticdesktop.aperture.vocabulary.NMO;
import org.semanticdesktop.aperture.vocabulary.SOURCEFORMAT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InferenceUtil {
    private final ListMap<URI, URI> superProperties = new ListMap();
    private final ListMap<URI, URI> superClasses = new ListMap();

    public void readOntology(Model model) {
        Statement statement;
        ClosableIterator closableIterator = model.findStatements((ResourceOrVariable)Variable.ANY, (UriOrVariable)RDFS.subPropertyOf, (NodeOrVariable)Variable.ANY);
        while (closableIterator.hasNext()) {
            statement = (Statement)closableIterator.next();
            this.learnInferenceFor(statement, this.superProperties);
        }
        closableIterator = model.findStatements((ResourceOrVariable)Variable.ANY, (UriOrVariable)RDFS.subClassOf, (NodeOrVariable)Variable.ANY);
        while (closableIterator.hasNext()) {
            statement = (Statement)closableIterator.next();
            this.learnInferenceFor(statement, this.superClasses);
        }
    }

    public void extendContent(RDFContainer rDFContainer) {
        this.extendContent(rDFContainer.getModel());
    }

    public void extendContent(Model model) {
        LinkedList<Statement> linkedList = new LinkedList<Statement>();
        for (Statement statement : model) {
            Object object;
            Object object2;
            URI uRI = statement.getPredicate();
            List<URI> list = this.superProperties.get(uRI);
            if (list != null) {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    linkedList.add(model.createStatement(statement.getSubject(), (URI)object, statement.getObject()));
                }
            }
            if (!RDF.type.equals(statement.getPredicate()) || !(statement.getObject() instanceof URI) || (object2 = this.superClasses.get((URI)statement.getObject())) == null) continue;
            object = object2.iterator();
            while (object.hasNext()) {
                URI uRI2 = (URI)object.next();
                linkedList.add(model.createStatement(statement.getSubject(), RDF.type, (Node)uRI2));
            }
        }
        model.addAll(linkedList.iterator());
    }

    private void learnInferenceFor(Statement statement, ListMap<URI, URI> listMap) {
        Object object;
        if (!(statement.getSubject() instanceof URI)) {
            return;
        }
        if (!(statement.getObject() instanceof URI)) {
            return;
        }
        URI uRI = (URI)statement.getSubject();
        URI uRI2 = (URI)statement.getObject();
        listMap.put(uRI, uRI2);
        List<URI> list = listMap.get(uRI2);
        if (list != null) {
            Iterator<URI> object2 = list.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                listMap.put(uRI, (URI)object);
            }
        }
        for (Map.Entry entry : listMap.entrySet()) {
            if (!((URI)entry.getValue()).equals(uRI) || (object = listMap.get(uRI)) == null) continue;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                URI uRI3 = (URI)iterator.next();
                listMap.put((URI)entry.getKey(), uRI3);
            }
        }
    }

    public static InferenceUtil createForCoreOntologies() {
        Model model = RDF2Go.getModelFactory().createModel();
        model.open();
        DATASOURCE.getDATASOURCEOntology(model);
        FRESNEL.getFRESNELOntology(model);
        GEO.getGEOOntology(model);
        NAO.getNAOOntology(model);
        NCAL.getNCALOntology(model);
        NCO.getNCOOntology(model);
        NEXIF.getNEXIFOntology(model);
        NFO.getNFOOntology(model);
        NID3.getNID3Ontology(model);
        NIE.getNIEOntology(model);
        NMO.getNMOOntology(model);
        SOURCEFORMAT.getSOURCEFORMATOntology(model);
        InferenceUtil inferenceUtil = new InferenceUtil();
        inferenceUtil.readOntology(model);
        model.close();
        return inferenceUtil;
    }
}

