/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.webdav;

import javax.servlet.http.HttpServletRequest;

public final class ResolvedRequest {
    private final String repositoryName;
    private final String workspaceName;
    private final String path;
    private final HttpServletRequest request;

    public ResolvedRequest(HttpServletRequest request, String repositoryName, String workspaceName, String path) {
        this.request = request;
        assert (this.request != null);
        this.repositoryName = repositoryName;
        this.workspaceName = workspaceName;
        this.path = path;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public String getPath() {
        return this.path;
    }

    public ResolvedRequest withPath(String path) {
        assert (this.repositoryName != null);
        assert (this.workspaceName != null);
        return new ResolvedRequest(this.request, this.repositoryName, this.workspaceName, path);
    }

    public String toString() {
        return "/" + this.repositoryName + "/" + this.workspaceName + this.path;
    }
}

