/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.CacheableRequest;
import org.modeshape.graph.request.RequestType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class ReadBranchRequest
extends CacheableRequest
implements Iterable<Location> {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_MAXIMUM_DEPTH = 2;
    public static final int NO_MAXIMUM_DEPTH = Integer.MAX_VALUE;
    private final Location at;
    private final String workspaceName;
    private final int maxDepth;
    private final Map<Path, Node> nodes = new HashMap<Path, Node>();
    private Location actualLocation;

    public ReadBranchRequest(Location at, String workspaceName) {
        CheckArg.isNotNull((Object)at, (String)"at");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
        this.at = at;
        this.maxDepth = 2;
    }

    public ReadBranchRequest(Location at, String workspaceName, int maxDepth) {
        CheckArg.isNotNull((Object)at, (String)"at");
        CheckArg.isPositive((int)maxDepth, (String)"maxDepth");
        CheckArg.isNotNull((Object)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
        this.at = at;
        this.maxDepth = maxDepth;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public Location at() {
        return this.at;
    }

    public String inWorkspace() {
        return this.workspaceName;
    }

    public int maximumDepth() {
        return this.maxDepth;
    }

    public boolean includes(Location location) {
        if (location == null || !location.hasPath()) {
            return false;
        }
        return this.nodes.containsKey(location.getPath());
    }

    public boolean includes(Path path) {
        if (path == null) {
            return false;
        }
        return this.nodes.containsKey(path);
    }

    public Location getLocationFor(Path path) {
        Node node = this.nodes.get(path);
        return node != null ? node.getLocation() : null;
    }

    public void setProperties(Location node, Property ... properties) {
        this.checkNotFrozen();
        CheckArg.isNotNull((Object)node, (String)"node");
        assert (node.hasPath());
        Node nodeObj = this.nodes.get(node.getPath());
        if (nodeObj == null) {
            nodeObj = new Node(node);
            this.nodes.put(node.getPath(), nodeObj);
        }
        Map<Name, Property> propertiesMap = nodeObj.getProperties();
        for (Property property : properties) {
            propertiesMap.put(property.getName(), property);
        }
    }

    public void setProperties(Location node, Iterable<Property> properties) {
        this.checkNotFrozen();
        CheckArg.isNotNull((Object)node, (String)"node");
        assert (node.hasPath());
        Node nodeObj = this.nodes.get(node.getPath());
        if (nodeObj == null) {
            nodeObj = new Node(node);
            this.nodes.put(node.getPath(), nodeObj);
        }
        Map<Name, Property> propertiesMap = nodeObj.getProperties();
        for (Property property : properties) {
            propertiesMap.put(property.getName(), property);
        }
    }

    public void setChildren(Location parent, Location ... children) {
        this.checkNotFrozen();
        CheckArg.isNotNull((Object)parent, (String)"parent");
        CheckArg.isNotNull((Object)children, (String)"children");
        assert (parent.hasPath());
        Node nodeObj = this.nodes.get(parent.getPath());
        if (nodeObj == null) {
            nodeObj = new Node(parent);
            this.nodes.put(parent.getPath(), nodeObj);
        }
        nodeObj.setChildren(Arrays.asList(children));
    }

    public void setChildren(Location parent, List<Location> children) {
        this.checkNotFrozen();
        CheckArg.isNotNull((Object)parent, (String)"parent");
        CheckArg.isNotNull(children, (String)"children");
        assert (parent.hasPath());
        Node nodeObj = this.nodes.get(parent.getPath());
        if (nodeObj == null) {
            nodeObj = new Node(parent);
            this.nodes.put(parent.getPath(), nodeObj);
        }
        nodeObj.setChildren(children);
    }

    public Map<Name, Property> getPropertiesFor(Location location) {
        if (location == null || !location.hasPath()) {
            return null;
        }
        Node node = this.nodes.get(location.getPath());
        return node != null ? node.getProperties() : null;
    }

    public List<Location> getChildren(Location parent) {
        if (parent == null || !parent.hasPath()) {
            return null;
        }
        Node node = this.nodes.get(parent.getPath());
        return node != null ? node.getChildren() : null;
    }

    @Override
    public Iterator<Location> iterator() {
        Location actual;
        final LinkedList<Location> queue = new LinkedList<Location>();
        if (this.getActualLocationOfNode() != null && (actual = this.getActualLocationOfNode()) != null) {
            queue.addFirst(this.getActualLocationOfNode());
        }
        return new Iterator<Location>(){

            @Override
            public boolean hasNext() {
                return queue.peek() != null;
            }

            @Override
            public Location next() {
                Location firstChild;
                Location next = (Location)queue.poll();
                if (next == null) {
                    throw new NoSuchElementException();
                }
                List<Location> children = ReadBranchRequest.this.getChildren(next);
                if (children != null && children.size() > 0 && ReadBranchRequest.this.includes(firstChild = children.get(0))) {
                    queue.addAll(0, children);
                }
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void setActualLocationOfNode(Location actual) {
        this.checkNotFrozen();
        CheckArg.isNotNull((Object)actual, (String)"actual");
        if (!actual.hasPath()) {
            throw new IllegalArgumentException(GraphI18n.actualLocationMustHavePath.text(new Object[]{actual}));
        }
        this.actualLocation = actual;
    }

    public Location getActualLocationOfNode() {
        return this.actualLocation;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualLocation = null;
        this.nodes.clear();
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.at, this.workspaceName});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            ReadBranchRequest that = (ReadBranchRequest)obj;
            if (!this.at().isSame(that.at())) {
                return false;
            }
            if (this.maximumDepth() != that.maximumDepth()) {
                return false;
            }
            return this.inWorkspace().equals(that.inWorkspace());
        }
        return false;
    }

    public String toString() {
        String workspaceName = this.workspaceName != null ? "'" + this.workspaceName + "'" : "default";
        return "read   " + this.printable(this.at()) + " (in " + workspaceName + " workspace) to depth " + this.maximumDepth();
    }

    @Override
    public RequestType getType() {
        return RequestType.READ_BRANCH;
    }

    public ReadBranchRequest withMaximumDepth(int maxDepth) {
        return new ReadBranchRequest(this.at, this.workspaceName, maxDepth);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node {
        private final Location location;
        private final Map<Name, Property> properties = new HashMap<Name, Property>();
        private List<Location> children;

        protected Node(Location location) {
            assert (location != null);
            this.location = location;
        }

        protected Location getLocation() {
            return this.location;
        }

        protected Map<Name, Property> getProperties() {
            return this.properties;
        }

        protected List<Location> getChildren() {
            return this.children;
        }

        protected void setChildren(List<Location> children) {
            this.children = children;
        }
    }
}

