/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.wsdl;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.collection.HashMultimap;
import org.modeshape.common.collection.Multimap;
import org.modeshape.common.util.Logger;
import org.modeshape.common.util.SizeMeasuringInputStream;
import org.modeshape.common.util.SizeMeasuringReader;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.wsdl.WsdlI18n;
import org.modeshape.sequencer.xsd.XsdResolvers;
import org.xml.sax.InputSource;

@NotThreadSafe
public abstract class WsdlReader<T> {
    public static final String UNBOUNDED = "unbounded";
    protected final SequencerOutput output;
    protected final StreamSequencerContext context;
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected final Map<Path, Multimap<Name, Integer>> namesByParentPath = new HashMap<Path, Multimap<Name, Integer>>();
    protected final XsdResolvers resolvers = new XsdResolvers();
    protected List<ResolveFuture> resolveFutures = new LinkedList<ResolveFuture>();

    protected WsdlReader(SequencerOutput output, StreamSequencerContext context) {
        this.output = output;
        this.context = context;
    }

    public StreamSequencerContext getContext() {
        return this.context;
    }

    public void read(String xsdContent, Path docPath) {
        this.read(new InputSource(new StringReader(xsdContent)), docPath);
    }

    public void read(InputStream stream, Path docPath) {
        this.read(new InputSource(stream), docPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void read(InputSource source, Path docPath) {
        block48: {
            String location;
            InputStream stream;
            Reader reader;
            block47: {
                block46: {
                    this.logger.trace("Processing XSD '{0}'", new Object[]{this.string(docPath)});
                    reader = null;
                    stream = null;
                    AtomicLong contentSize = new AtomicLong();
                    if (source.getCharacterStream() != null) {
                        reader = new SizeMeasuringReader(source.getCharacterStream(), contentSize);
                        source = new InputSource(reader);
                    } else {
                        stream = new SizeMeasuringInputStream(source.getByteStream(), contentSize);
                        source = new InputSource(stream);
                    }
                    T result = this.parse(source, docPath.getLastSegment().getName().getLocalName());
                    this.process(result, docPath, contentSize.get());
                    if ($assertionsDisabled || reader != null && stream == null || reader == null && stream != null) break block46;
                    throw new AssertionError();
                }
                if (reader == null) break block47;
                reader.close();
            }
            try {
                if (stream != null) {
                    stream.close();
                }
                break block48;
            }
            catch (Exception e) {
                location = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                this.context.getProblems().addError((Throwable)e, WsdlI18n.errorClosingWsdlFile, new Object[]{location, e.getMessage()});
            }
            break block48;
            catch (Exception e) {
                try {
                    location = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                    this.context.getProblems().addError((Throwable)e, WsdlI18n.errorClosingWsdlFile, new Object[]{location, e.getMessage()});
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (Exception e2) {
                        String location2 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                        this.context.getProblems().addError((Throwable)e2, WsdlI18n.errorClosingWsdlFile, new Object[]{location2, e2.getMessage()});
                    }
                    throw throwable;
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    break block48;
                }
                catch (Exception e3) {
                    location = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                    this.context.getProblems().addError((Throwable)e3, WsdlI18n.errorClosingWsdlFile, new Object[]{location, e3.getMessage()});
                }
                break block48;
            }
            catch (Throwable e) {
                String location3;
                block50: {
                    block49: {
                        try {
                            location3 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                            this.context.getProblems().addError(e, WsdlI18n.errorReadingWsdlFile, new Object[]{location3, e.getMessage()});
                            if ($assertionsDisabled || reader != null && stream == null || reader == null && stream != null) break block49;
                        }
                        catch (Throwable throwable) {
                            block52: {
                                block51: {
                                    assert (reader != null && stream == null || reader == null && stream != null);
                                    if (reader == null) break block51;
                                    reader.close();
                                }
                                try {
                                    if (stream != null) {
                                        stream.close();
                                    }
                                    break block52;
                                }
                                catch (Exception e4) {
                                    String location4 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                                    this.context.getProblems().addError((Throwable)e4, WsdlI18n.errorClosingWsdlFile, new Object[]{location4, e4.getMessage()});
                                }
                                break block52;
                                catch (Exception e5) {
                                    String location5;
                                    try {
                                        location5 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                                        this.context.getProblems().addError((Throwable)e5, WsdlI18n.errorClosingWsdlFile, new Object[]{location5, e5.getMessage()});
                                    }
                                    catch (Throwable throwable2) {
                                        try {
                                            if (stream != null) {
                                                stream.close();
                                            }
                                        }
                                        catch (Exception e6) {
                                            String location6 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                                            this.context.getProblems().addError((Throwable)e6, WsdlI18n.errorClosingWsdlFile, new Object[]{location6, e6.getMessage()});
                                        }
                                        throw throwable2;
                                    }
                                    try {
                                        if (stream != null) {
                                            stream.close();
                                        }
                                    }
                                    catch (Exception e7) {
                                        location5 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                                        this.context.getProblems().addError((Throwable)e7, WsdlI18n.errorClosingWsdlFile, new Object[]{location5, e7.getMessage()});
                                    }
                                }
                            }
                            throw throwable;
                        }
                        throw new AssertionError();
                    }
                    if (reader == null) break block50;
                    reader.close();
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception e8) {
                    location3 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                    this.context.getProblems().addError((Throwable)e8, WsdlI18n.errorClosingWsdlFile, new Object[]{location3, e8.getMessage()});
                }
                catch (Exception e9) {
                    try {
                        location3 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                        this.context.getProblems().addError((Throwable)e9, WsdlI18n.errorClosingWsdlFile, new Object[]{location3, e9.getMessage()});
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (Exception e10) {
                            String location7 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                            this.context.getProblems().addError((Throwable)e10, WsdlI18n.errorClosingWsdlFile, new Object[]{location7, e10.getMessage()});
                        }
                        throw throwable;
                    }
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (Exception e11) {
                        location3 = (String)this.context.getValueFactories().getStringFactory().create(this.context.getInputPath());
                        this.context.getProblems().addError((Throwable)e11, WsdlI18n.errorClosingWsdlFile, new Object[]{location3, e11.getMessage()});
                    }
                }
            }
        }
    }

    protected abstract T parse(InputSource var1, String var2) throws Exception;

    protected abstract void process(T var1, Path var2, long var3) throws Exception;

    protected Path nextPath(Path parentPath, Name name) {
        HashMultimap names = this.namesByParentPath.get(parentPath);
        int sns = 1;
        if (names == null) {
            names = HashMultimap.create();
            names.put((Object)name, (Object)sns);
            this.namesByParentPath.put(parentPath, (Multimap<Name, Integer>)names);
        } else {
            sns = names.get((Object)name).size() + 1;
            names.put((Object)name, (Object)1);
        }
        return this.context.getValueFactories().getPathFactory().create(parentPath, name, sns);
    }

    protected Path path(Path parentPath, Path subpath) {
        return this.context.getValueFactories().getPathFactory().create(parentPath, subpath);
    }

    protected Path path(Path parentPath, Name segment) {
        return this.context.getValueFactories().getPathFactory().create(parentPath, new Name[]{segment});
    }

    protected Path path(Path parentPath, String segment) {
        return this.context.getValueFactories().getPathFactory().create(parentPath, segment);
    }

    protected Path path(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    protected Name name(String namespaceUri, String name) {
        return this.context.getValueFactories().getNameFactory().create(namespaceUri, name);
    }

    protected String string(Object value) {
        return (String)this.context.getValueFactories().getStringFactory().create(value);
    }

    protected UUID setUuid(Path path) {
        UUID uuid = this.context.getValueFactories().getUuidFactory().create();
        this.output.setProperty(path, JcrLexicon.UUID, new Object[]{uuid});
        return uuid;
    }

    protected void resolveReferences() {
        if (this.resolveFutures.isEmpty()) {
            return;
        }
        List<ResolveFuture> futures = this.resolveFutures;
        this.resolveFutures = new LinkedList<ResolveFuture>();
        for (ResolveFuture future : futures) {
            future.resolve();
        }
    }

    protected String prefixForNamespace(String namespaceUri, String defaultPrefix) {
        NamespaceRegistry registry = this.context.getNamespaceRegistry();
        String prefix = registry.getPrefixForNamespaceUri(namespaceUri, false);
        if (prefix == null) {
            if (defaultPrefix == null) {
                prefix = registry.getPrefixForNamespaceUri(namespaceUri, true);
            } else {
                int counter = 2;
                String proposedPrefix = defaultPrefix;
                while (registry.getNamespaceForPrefix(proposedPrefix) != null) {
                    proposedPrefix = defaultPrefix + counter++;
                }
                prefix = registry.register(proposedPrefix, namespaceUri);
            }
        }
        return prefix;
    }

    protected UUID setReference(Path path, Name propertyName, XsdResolvers.SymbolSpace kind, String namespace, String name) {
        UUID typeUuid = this.resolvers.get(kind).lookup(namespace, name);
        if (typeUuid != null) {
            this.output.setProperty(path, propertyName, new Object[]{typeUuid});
        } else {
            this.resolveFutures.add(new ResolveFuture(path, propertyName, kind, namespace, name));
        }
        return typeUuid;
    }

    protected class ResolveFuture {
        private final Path path;
        private final Name propertyName;
        private final XsdResolvers.SymbolSpace refKind;
        private final String refNamespace;
        private final String refName;

        protected ResolveFuture(Path path, Name propertyName, XsdResolvers.SymbolSpace kind, String namespace, String name) {
            this.path = path;
            this.propertyName = propertyName;
            this.refKind = kind;
            this.refNamespace = namespace;
            this.refName = name;
        }

        protected UUID resolve() {
            return WsdlReader.this.setReference(this.path, this.propertyName, this.refKind, this.refNamespace, this.refName);
        }
    }
}

