/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ontoware.rdf2go.ModelFactory;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDF2Go {
    private static final Logger log = LoggerFactory.getLogger(RDF2Go.class);
    protected static ModelFactory modelFactory;
    private static Exception instanceRegistered;

    public static final ModelFactory getModelFactory() {
        RDF2Go.checkModelFactory();
        return modelFactory;
    }

    public static final void register(ModelFactory modelFactory) {
        if (modelFactory == null) {
            RDF2Go.modelFactory = null;
            return;
        }
        if (RDF2Go.modelFactory != null && !RDF2Go.modelFactory.getClass().equals(modelFactory.getClass())) {
            throw new RuntimeException("already registered framework " + modelFactory.getClass().getName() + " in the attached Exception (see stacktrace).", instanceRegistered);
        }
        RDF2Go.modelFactory = modelFactory;
        instanceRegistered = new Exception("registered framework before");
    }

    public static final void register(String modelFactoryClassname) throws ModelRuntimeException {
        try {
            Class<?> c = Class.forName(modelFactoryClassname);
            try {
                Constructor<?> constructor = c.getConstructor(new Class[0]);
                try {
                    ModelFactory modelBuilder = (ModelFactory)constructor.newInstance(new Object[0]);
                    RDF2Go.register(modelBuilder);
                }
                catch (IllegalArgumentException e) {
                    throw new ModelRuntimeException(e);
                }
                catch (InstantiationException e) {
                    throw new ModelRuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new ModelRuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new ModelRuntimeException(e);
                }
            }
            catch (SecurityException e) {
                throw new ModelRuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new ModelRuntimeException(e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ModelRuntimeException(e);
        }
    }

    private static void checkModelFactory() {
        if (modelFactory == null) {
            try {
                Class<?> clazz = Class.forName("org.ontoware.rdf2go.impl.StaticBinding");
                Method method = clazz.getMethod("getModelFactory", new Class[0]);
                Object result = method.invoke(clazz, new Object[0]);
                if (result instanceof ModelFactory) {
                    modelFactory = (ModelFactory)result;
                    log.info("Using ModelFactory '" + result.getClass() + "' which was loaded via org.ontoware.rdf2go.impl.StaticBinding.");
                }
            }
            catch (ClassNotFoundException e) {
                throw new ModelRuntimeException(e);
            }
            catch (SecurityException e) {
                throw new ModelRuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new ModelRuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new ModelRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new ModelRuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new ModelRuntimeException(e);
            }
        }
        if (modelFactory == null) {
            throw new IllegalStateException("No ModelFactoy was registered. Please register one via RDF2Go.register(ModelFactory mf)");
        }
    }
}

