/*
 * Decompiled with CFR 0.152.
 */
package org.ontoware.rdf2go.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Syntax {
    private static List<Syntax> SYNTAXES = new ArrayList<Syntax>();
    public static final Syntax RdfXml = new Syntax("rdfxml", "application/rdf+xml", ".rdf", true);
    public static final Syntax Turtle = new Syntax("turtle", "application/x-turtle", ".ttl", true);
    public static final Syntax Ntriples = new Syntax("ntriples", "text/plain", ".nt", true);
    public static final Syntax Trix = new Syntax("trix", "application/trix", ".trix", true);
    public static final Syntax Trig = new Syntax("trig", "application/x-trig", ".trig", true);
    private final String name;
    private final String mimeType;
    private final String filenameExtension;

    public static void register(Syntax syntax) {
        SYNTAXES.add(syntax);
    }

    public static Syntax forName(String name) {
        for (Syntax x : SYNTAXES) {
            if (!x.getName().equals(name)) continue;
            return x;
        }
        return null;
    }

    public static Syntax forMimeType(String mimeType) {
        for (Syntax x : SYNTAXES) {
            if (!x.getMimeType().equals(mimeType)) continue;
            return x;
        }
        return null;
    }

    public static boolean unregister(Syntax syntax) {
        return SYNTAXES.remove(syntax);
    }

    public static List<Syntax> list() {
        return Collections.unmodifiableList(SYNTAXES);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getName() {
        return this.name;
    }

    public String getFilenameExtension() {
        return this.filenameExtension;
    }

    public Syntax(String name, String mimeType, String filenameExtension) {
        this.name = name;
        this.mimeType = mimeType;
        this.filenameExtension = filenameExtension;
    }

    public Syntax(String name, String mimeType, String filenameExtension, boolean registerItNow) {
        this(name, mimeType, filenameExtension);
        if (registerItNow) {
            Syntax.register(this);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Syntax) {
            return this.mimeType.equals(((Syntax)obj).mimeType);
        }
        return false;
    }

    public int hashCode() {
        return this.mimeType.hashCode();
    }

    public String toString() {
        return "RDF Syntax '" + this.name + "' MIME-type=" + this.mimeType;
    }
}

