/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.security.trustmanager.standard;

import java.io.File;
import javax.net.ssl.TrustManager;
import org.semanticdesktop.aperture.security.trustdecider.TrustDecider;
import org.semanticdesktop.aperture.security.trustmanager.TrustManagerFactory;
import org.semanticdesktop.aperture.security.trustmanager.standard.StandardTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardTrustManagerFactory
implements TrustManagerFactory {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private StandardTrustManager trustManager;
    private TrustDecider trustDecider;
    private File persistentStorageFile;
    private char[] persistentStoragePassword;

    public void setTrustDecider(TrustDecider trustDecider) {
        this.trustDecider = trustDecider;
    }

    public TrustDecider getTrustDecider() {
        return this.trustDecider;
    }

    public void setPersistentStorageFile(File file) {
        if (file == null && this.persistentStorageFile != null || !file.equals(this.persistentStorageFile)) {
            this.persistentStorageFile = file;
            this.trustManager = null;
        }
    }

    public File getPersistentStorageFile() {
        return this.persistentStorageFile;
    }

    public void setPersistentStoragePassword(char[] cArray) {
        this.persistentStoragePassword = cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrustManager get() {
        StandardTrustManagerFactory standardTrustManagerFactory = this;
        synchronized (standardTrustManagerFactory) {
            if (this.trustManager == null) {
                try {
                    this.trustManager = new StandardTrustManager(this.persistentStorageFile, this.persistentStoragePassword);
                    this.trustManager.setTrustDecider(this.trustDecider);
                }
                catch (Exception exception) {
                    this.logger.error("Exception while creating trust manager", (Throwable)exception);
                }
            }
            return this.trustManager;
        }
    }
}

