/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.Adler32;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Syntax;
import org.semanticdesktop.aperture.util.ResourceUtil;

public class IOUtil {
    public static char[] readChars(Reader reader) throws IOException {
        return IOUtil.readFully(reader).toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            String string = IOUtil.readString(fileInputStream);
            return string;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(URL uRL) throws IOException {
        String string = null;
        Reader reader = IOUtil.urlToReader(uRL);
        try {
            string = IOUtil.readString(reader);
        }
        finally {
            reader.close();
        }
        return string;
    }

    public static String readString(InputStream inputStream) throws IOException {
        return IOUtil.readString(new InputStreamReader(inputStream));
    }

    public static String readString(Reader reader) throws IOException {
        return IOUtil.readFully(reader).toString();
    }

    public static String readString(Reader reader, int n) throws IOException {
        char[] cArray = new char[n];
        int n2 = IOUtil.fillCharArray(reader, cArray);
        return new String(cArray, 0, n2);
    }

    public static int fillCharArray(Reader reader, char[] cArray) throws IOException {
        int n = 0;
        int n2 = reader.read(cArray);
        while (n2 >= 0 && (n += n2) != cArray.length) {
            n2 = reader.read(cArray, n, cArray.length - n);
        }
        return n;
    }

    public static byte[] readBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        IOUtil.writeStream(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] readBytes(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = IOUtil.fillByteArray(inputStream, byArray);
        if (n2 < n) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
        }
        return byArray;
    }

    public static String rollingHash(InputStream inputStream) throws IOException {
        int n;
        Adler32 adler32 = new Adler32();
        adler32.reset();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            adler32.update(byArray, 0, n);
        }
        return String.valueOf(adler32.getValue());
    }

    public static int fillByteArray(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        int n2 = inputStream.read(byArray);
        while (n2 >= 0 && (n += n2) != byArray.length) {
            n2 = inputStream.read(byArray, n, byArray.length - n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStream(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            IOUtil.writeStream(inputStream, fileOutputStream);
        }
        finally {
            try {
                fileOutputStream.flush();
            }
            finally {
                fileOutputStream.close();
            }
        }
    }

    public static void writeStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(String string, File file) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        try {
            fileWriter.write(string);
        }
        finally {
            fileWriter.close();
        }
    }

    public static void writeString(String string, String string2) throws IOException {
        IOUtil.writeString(string, new File(string2));
    }

    public static Reader urlToReader(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        return new InputStreamReader(uRLConnection.getInputStream());
    }

    private static CharArrayWriter readFully(Reader reader) throws IOException {
        char[] cArray = new char[4096];
        int n = 0;
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        while ((n = reader.read(cArray)) != -1) {
            charArrayWriter.write(cArray, 0, n);
        }
        return charArrayWriter;
    }

    public static void readFileFromResource(Model model, String string, Syntax syntax) throws FileNotFoundException, IOException, ModelException {
        InputStream inputStream = ResourceUtil.getInputStream(string, IOUtil.class);
        if (inputStream == null) {
            throw new FileNotFoundException("couldn't find resource " + string);
        }
        model.readFrom(inputStream, syntax);
    }
}

