/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeTypeDefinition;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.IoUtil;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.io.Destination;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.jcr.GraphNodeTypeReader;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrNtLexicon;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class JackrabbitXmlNodeTypeReader
extends GraphNodeTypeReader {
    public JackrabbitXmlNodeTypeReader(Session session) {
        super(session);
    }

    public JackrabbitXmlNodeTypeReader(ExecutionContext context) {
        super(context);
    }

    @Override
    public void read(InputStream stream, String resourceName) throws IOException {
        super.read(stream, resourceName);
    }

    @Override
    public void read(File file) throws IOException {
        super.read(file);
    }

    @Override
    public void read(URL url) throws IOException {
        super.read(url);
    }

    @Override
    public void read(String resourceFile) throws IOException {
        super.read(resourceFile);
    }

    @Override
    public void read(String content, String resourceName) {
        super.read(content, resourceName);
    }

    @Override
    public void read(Graph graph, Path parentOfTypes, String resourceName) {
        super.read(graph, parentOfTypes, resourceName);
    }

    @Override
    public void read(Subgraph subgraph, Location locationOfParent, String resourceName) {
        super.read(subgraph, locationOfParent, resourceName);
    }

    @Override
    public Problems getProblems() {
        return super.getProblems();
    }

    @Override
    public NodeTypeDefinition[] getNodeTypeDefinitions() {
        return super.getNodeTypeDefinitions();
    }

    @Override
    public Iterator<NodeTypeDefinition> iterator() {
        return super.iterator();
    }

    @Override
    protected void importFrom(Destination destination, Path path, String content, String resourceName) throws Exception {
        XmlImporter importer = new XmlImporter(destination, this.pathFactory.createRootPath());
        importer.importFrom(content, this.problems, resourceName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class XmlImporter {
        protected final List<String> VALID_ON_PARENT_VERSION = Collections.unmodifiableList(Arrays.asList("COPY", "VERSION", "INITIALIZE", "COMPUTE", "IGNORE", "ABORT"));
        protected final Destination destination;
        protected final Path outputPath;
        protected final PropertyFactory propertyFactory;
        protected final PathFactory pathFactory;
        protected final NameFactory nameFactory;
        protected final ValueFactories valueFactories;

        public XmlImporter(Destination destination, Path parentPath, boolean compatibleWithPreJcr2) {
            CheckArg.isNotNull((Object)destination, (String)"destination");
            CheckArg.isNotNull((Object)parentPath, (String)"parentPath");
            this.destination = destination;
            this.outputPath = parentPath;
            ExecutionContext context = destination.getExecutionContext();
            this.valueFactories = context.getValueFactories();
            this.propertyFactory = context.getPropertyFactory();
            this.pathFactory = this.valueFactories.getPathFactory();
            this.nameFactory = this.valueFactories.getNameFactory();
        }

        public XmlImporter(Destination destination, Path parentPath) {
            this(destination, parentPath, true);
        }

        public void importFrom(InputStream stream, Problems problems, String resourceName) throws SAXException, IOException {
            try {
                this.parse(stream, problems, resourceName);
                this.destination.submit();
            }
            catch (RuntimeException e) {
                problems.addError((Throwable)e, JcrI18n.errorImportingNodeTypeContent, new Object[]{resourceName, e.getMessage()});
            }
        }

        public void importFrom(File file, Problems problems) throws SAXException, IOException {
            this.importFrom(IoUtil.read((File)file), problems, file.getCanonicalPath());
        }

        public void importFrom(String content, Problems problems, String resourceName) throws SAXException, IOException {
            this.importFrom(new ByteArrayInputStream(content.getBytes()), problems, resourceName);
        }

        protected void parse(InputStream content, Problems problems, String resourceName) throws SAXException, IOException {
            ExecutionContext context = this.destination.getExecutionContext();
            InMemoryRepositorySource source = new InMemoryRepositorySource();
            source.setName("XML Import Source");
            Graph graph = Graph.create((RepositorySource)source, (ExecutionContext)context);
            graph.importXmlFrom(content).into("/");
            try {
                Subgraph subgraph = (Subgraph)graph.getSubgraphOfDepth(5).at("/nodeTypes");
                Path path = this.outputPath;
                for (Location location : subgraph.getRoot().getChildren()) {
                    SubgraphNode nodeType = (SubgraphNode)subgraph.getNode(location);
                    this.parseNodeType(subgraph, nodeType, path);
                }
            }
            catch (PathNotFoundException e) {
                problems.addError((Throwable)e, JcrI18n.nodeTypesNotFoundInXml, new Object[]{resourceName, e.getMessage()});
            }
        }

        protected void parseNodeType(Subgraph subgraph, SubgraphNode nodeType, Path parentPath) {
            SubgraphNode supertypes;
            Name name = this.readName(nodeType, "name", null);
            Path nodeTypePath = this.pathFactory.create(parentPath, new Name[]{name});
            ArrayList<Property> properties = new ArrayList<Property>();
            properties.add(this.propertyFactory.create(JcrLexicon.NODE_TYPE_NAME, new Object[]{name}));
            boolean isOrderable = this.readBoolean(nodeType, "hasOrderableChildNodes", false);
            boolean isMixin = this.readBoolean(nodeType, "isMixin", false);
            boolean isAbstract = this.readBoolean(nodeType, "isAbstract", false);
            boolean isQueryable = this.readBoolean(nodeType, "isQueryable", true);
            String onParentVersion = "COPY";
            Name primaryItemName = this.readName(nodeType, "primaryItemName", null);
            properties.add(this.propertyFactory.create(JcrLexicon.HAS_ORDERABLE_CHILD_NODES, new Object[]{isOrderable}));
            properties.add(this.propertyFactory.create(JcrLexicon.IS_MIXIN, new Object[]{isMixin}));
            properties.add(this.propertyFactory.create(JcrLexicon.IS_ABSTRACT, new Object[]{isAbstract}));
            properties.add(this.propertyFactory.create(JcrLexicon.IS_QUERYABLE, new Object[]{isQueryable}));
            properties.add(this.propertyFactory.create(JcrLexicon.ON_PARENT_VERSION, new Object[]{onParentVersion.toUpperCase()}));
            if (primaryItemName != null) {
                properties.add(this.propertyFactory.create(JcrLexicon.PRIMARY_ITEM_NAME, new Object[]{primaryItemName}));
            }
            if ((supertypes = nodeType.getNode(this.name("supertypes"))) != null) {
                List<Name> supertypeNames = this.readNames(supertypes, "supertype", JcrNtLexicon.BASE);
                properties.add(this.propertyFactory.create(JcrLexicon.SUPERTYPES, supertypeNames));
            }
            this.destination.create(nodeTypePath, properties);
            for (Location childLocation : nodeType.getChildren()) {
                SubgraphNode child = (SubgraphNode)subgraph.getNode(childLocation);
                Name childName = this.nameFrom(child);
                if (childName.getLocalName().equals("propertyDefinition")) {
                    this.parsePropertyDefinition(subgraph, child, nodeTypePath);
                    continue;
                }
                if (!childName.getLocalName().equals("childNodeDefinition")) continue;
                this.parseChildNodeDefinition(subgraph, child, nodeTypePath);
            }
        }

        protected void parsePropertyDefinition(Subgraph subgraph, SubgraphNode propertyDefn, Path parentPath) {
            Name name = this.readName(propertyDefn, "name", null);
            Path nodeTypePath = this.pathFactory.create(parentPath, new Name[]{JcrLexicon.PROPERTY_DEFINITION});
            ArrayList<Property> properties = new ArrayList<Property>();
            properties.add(this.propertyFactory.create(JcrLexicon.NAME, new Object[]{name}));
            boolean autoCreated = this.readBoolean(propertyDefn, "autoCreated", false);
            boolean mandatory = this.readBoolean(propertyDefn, "mandatory", false);
            boolean multiple = this.readBoolean(propertyDefn, "multiple", false);
            boolean isProtected = this.readBoolean(propertyDefn, "protected", false);
            boolean isFullTextSearchable = this.readBoolean(propertyDefn, "fullTextSearchable", true);
            boolean isQueryOrderable = true;
            String onParentVersion = this.readString(propertyDefn, "onParentVersion", "COPY");
            String requiredType = this.readString(propertyDefn, "requiredType", "UNDEFINED");
            properties.add(this.propertyFactory.create(JcrLexicon.AUTO_CREATED, new Object[]{autoCreated}));
            properties.add(this.propertyFactory.create(JcrLexicon.MANDATORY, new Object[]{mandatory}));
            properties.add(this.propertyFactory.create(JcrLexicon.PROTECTED, new Object[]{isProtected}));
            properties.add(this.propertyFactory.create(JcrLexicon.ON_PARENT_VERSION, new Object[]{onParentVersion.toUpperCase()}));
            properties.add(this.propertyFactory.create(JcrLexicon.MULTIPLE, new Object[]{multiple}));
            properties.add(this.propertyFactory.create(JcrLexicon.IS_FULL_TEXT_SEARCHABLE, new Object[]{isFullTextSearchable}));
            properties.add(this.propertyFactory.create(JcrLexicon.IS_QUERY_ORDERABLE, new Object[]{isQueryOrderable}));
            properties.add(this.propertyFactory.create(JcrLexicon.REQUIRED_TYPE, new Object[]{requiredType.toUpperCase()}));
            for (Location childLocation : propertyDefn.getChildren()) {
                List<String> defaultValues;
                SubgraphNode child = (SubgraphNode)subgraph.getNode(childLocation);
                Name childName = this.nameFrom(child);
                if (childName.getLocalName().equals("valueConstraints")) {
                    List<String> valueConstraints = this.readStrings(child, "valueConstraint");
                    if (valueConstraints == null || valueConstraints.isEmpty()) continue;
                    properties.add(this.propertyFactory.create(JcrLexicon.VALUE_CONSTRAINTS, valueConstraints));
                    continue;
                }
                if (!childName.getLocalName().equals("defaultValues") || (defaultValues = this.readStrings(child, "defaultValue")) == null || defaultValues.isEmpty()) continue;
                properties.add(this.propertyFactory.create(JcrLexicon.DEFAULT_VALUES, defaultValues));
            }
            this.destination.create(nodeTypePath, properties);
        }

        protected void parseChildNodeDefinition(Subgraph subgraph, SubgraphNode childDefn, Path parentPath) {
            Name name = this.readName(childDefn, "name", null);
            Path nodeTypePath = this.pathFactory.create(parentPath, new Name[]{JcrLexicon.CHILD_NODE_DEFINITION});
            ArrayList<Property> properties = new ArrayList<Property>();
            properties.add(this.propertyFactory.create(JcrLexicon.NAME, new Object[]{name}));
            boolean autoCreated = this.readBoolean(childDefn, "autoCreated", false);
            boolean mandatory = this.readBoolean(childDefn, "mandatory", false);
            String onParentVersion = this.readString(childDefn, "onParentVersion", "COPY");
            boolean isProtected = this.readBoolean(childDefn, "protected", false);
            boolean sns = this.readBoolean(childDefn, "sameNameSiblings", false);
            Name defaultPrimaryType = this.readName(childDefn, "defaultPrimaryType", null);
            properties.add(this.propertyFactory.create(JcrLexicon.AUTO_CREATED, new Object[]{autoCreated}));
            properties.add(this.propertyFactory.create(JcrLexicon.MANDATORY, new Object[]{mandatory}));
            properties.add(this.propertyFactory.create(JcrLexicon.PROTECTED, new Object[]{isProtected}));
            properties.add(this.propertyFactory.create(JcrLexicon.ON_PARENT_VERSION, new Object[]{onParentVersion.toUpperCase()}));
            properties.add(this.propertyFactory.create(JcrLexicon.SAME_NAME_SIBLINGS, new Object[]{sns}));
            if (defaultPrimaryType != null) {
                properties.add(this.propertyFactory.create(JcrLexicon.DEFAULT_PRIMARY_TYPE, new Object[]{defaultPrimaryType}));
            }
            for (Location childLocation : childDefn.getChildren()) {
                List<Name> requiredPrimaryTypes;
                SubgraphNode child = (SubgraphNode)subgraph.getNode(childLocation);
                Name childName = this.nameFrom(child);
                if (!childName.getLocalName().equals("requiredPrimaryTypes") || (requiredPrimaryTypes = this.readNames(child, "requiredPrimaryType", JcrNtLexicon.BASE)) == null || requiredPrimaryTypes.isEmpty()) continue;
                properties.add(this.propertyFactory.create(JcrLexicon.REQUIRED_PRIMARY_TYPES, requiredPrimaryTypes));
            }
            this.destination.create(nodeTypePath, properties);
        }

        protected Name nameFrom(SubgraphNode node) {
            return node.getLocation().getPath().getLastSegment().getName();
        }

        protected Name name(String name) {
            return (Name)this.nameFactory.create(name);
        }

        protected boolean readBoolean(SubgraphNode node, String propertyName, boolean defaultValue) {
            Property property = node.getProperty(propertyName);
            return property != null ? (Boolean)this.valueFactories.getBooleanFactory().create(property.getFirstValue()) : defaultValue;
        }

        protected String readString(SubgraphNode node, String propertyName, String defaultValue) {
            Property property = node.getProperty(propertyName);
            return property != null ? (String)this.valueFactories.getStringFactory().create(property.getFirstValue()) : defaultValue;
        }

        protected List<String> readStrings(SubgraphNode node, String propertyName) {
            ArrayList<String> results = new ArrayList<String>();
            Property property = node.getProperty(propertyName);
            if (property != null) {
                for (Object value : property) {
                    String str = (String)this.valueFactories.getStringFactory().create(value);
                    if (str == null || str.length() == 0) continue;
                    results.add(str);
                }
            }
            return results;
        }

        protected Name readName(SubgraphNode node, String propertyName, Name defaultValue) {
            String firstValue;
            Property property = node.getProperty(propertyName);
            if (property != null && !property.isEmpty() && (firstValue = (String)this.valueFactories.getStringFactory().create(property.getFirstValue())) != null && firstValue.trim().length() != 0) {
                return (Name)this.valueFactories.getNameFactory().create(firstValue);
            }
            return defaultValue;
        }

        protected List<Name> readNames(SubgraphNode node, String propertyName, Name defaultIfNone) {
            ArrayList<Name> results = new ArrayList<Name>();
            Property property = node.getProperty(propertyName);
            if (property != null) {
                for (Object value : property) {
                    Name name = (Name)this.valueFactories.getNameFactory().create(value);
                    if (name == null) continue;
                    results.add(name);
                }
            }
            if (results.isEmpty() && defaultIfNone != null) {
                results.add(defaultIfNone);
            }
            return results;
        }
    }
}

