/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.concurrent.CountDownLatch;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.graph.connector.federation.Projection;
import org.modeshape.graph.request.Request;

@NotThreadSafe
class FederatedRequest {
    static final CountDownLatch CLOSED_LATCH = new CountDownLatch(0);
    private final Request original;
    private CountDownLatch forkLatch;
    private int incompleteCount;
    private ProjectedRequest first;

    FederatedRequest(Request original) {
        this.original = original;
    }

    public Request original() {
        return this.original;
    }

    public final FederatedRequest add(Request request, boolean isSameLocationAsOriginal, boolean isComplete, Projection projection, Projection secondProjection) {
        assert (this.forkLatch == null);
        if (!isComplete) {
            ++this.incompleteCount;
        }
        if (this.first == null) {
            this.first = isSameLocationAsOriginal ? new MirrorRequest(request, isComplete, projection, secondProjection) : new ProjectedRequest(request, isComplete, projection, secondProjection);
        } else {
            this.first.addNext(request, isComplete, projection);
        }
        return this;
    }

    public final FederatedRequest add(Request request, boolean isSameLocationAsOriginal, boolean isComplete, Projection projection) {
        return this.add(request, isSameLocationAsOriginal, isComplete, projection, null);
    }

    public void freeze() {
        if (this.forkLatch == null) {
            this.forkLatch = this.incompleteCount > 0 ? new CountDownLatch(this.incompleteCount) : CLOSED_LATCH;
        }
    }

    public ProjectedRequest getFirstProjectedRequest() {
        return this.first;
    }

    public boolean hasIncompleteRequests() {
        return this.incompleteCount != 0;
    }

    public CountDownLatch getLatch() {
        this.freeze();
        return this.forkLatch;
    }

    public void await() throws InterruptedException {
        if (this.forkLatch != null) {
            this.forkLatch.await();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Federated request: ").append(this.original).append("\n");
        for (ProjectedRequest projected = this.first; projected != null; projected = projected.next()) {
            sb.append("  - ").append(projected).append("\n");
        }
        return sb.toString();
    }

    class MirrorRequest
    extends ProjectedRequest {
        protected MirrorRequest(Request request, boolean isComplete, Projection projection, Projection secondProjection) {
            super(request, isComplete, projection, secondProjection);
        }

        public boolean isSameLocation() {
            return true;
        }
    }

    class ProjectedRequest {
        private final Projection projection;
        private final Projection projection2;
        private final Request request;
        private final boolean isComplete;
        private ProjectedRequest next;

        protected ProjectedRequest(Request request, boolean isComplete, Projection projection, Projection secondProjection) {
            this.projection = projection;
            this.request = request;
            this.isComplete = isComplete;
            this.projection2 = secondProjection;
        }

        public final Projection getProjection() {
            return this.projection;
        }

        public final Projection getSecondProjection() {
            return this.projection2;
        }

        public final Request getRequest() {
            return this.request;
        }

        public final boolean isComplete() {
            return this.isComplete;
        }

        public boolean isSameLocation() {
            return false;
        }

        public final ProjectedRequest next() {
            return this.next;
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        protected final ProjectedRequest addNext(Request request, boolean isComplete, Projection projection, Projection secondProjection) {
            ProjectedRequest last = this;
            while (last.next != null) {
                last = last.next;
            }
            last.next = new ProjectedRequest(request, isComplete, projection, secondProjection);
            return last.next;
        }

        protected final ProjectedRequest addNext(Request request, boolean isComplete, Projection projection) {
            return this.addNext(request, isComplete, projection, null);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Projects to: ");
            sb.append(this.request);
            if (this.projection != null) {
                sb.append(" using ");
                sb.append(this.projection);
                if (this.projection2 != null) {
                    sb.append(" and ");
                    sb.append(this.projection2);
                }
            }
            if (this.isComplete) {
                sb.append(" (complete)");
            }
            return sb.toString();
        }
    }
}

