/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.property.basic.AbstractBinary;

@Immutable
public class InMemoryBinary
extends AbstractBinary {
    private static final long serialVersionUID = 2L;
    private byte[] bytes;
    private byte[] sha1hash;
    private int hc;

    public InMemoryBinary(byte[] bytes) {
        CheckArg.isNotNull((Object)bytes, (String)"bytes");
        this.bytes = bytes;
        assert (this.bytes != null);
    }

    public int hashCode() {
        if (this.sha1hash == null) {
            assert (this.bytes != null) : "This Binary object was purged and has no content";
            this.sha1hash = this.computeHash(this.bytes);
            this.hc = this.sha1hash.hashCode();
        }
        return this.hc;
    }

    public long getSize() {
        return this.bytes.length;
    }

    public byte[] getHash() {
        if (this.sha1hash == null) {
            assert (this.bytes != null) : "This Binary object was purged and has no content";
            this.sha1hash = this.computeHash(this.bytes);
            this.hc = this.sha1hash.hashCode();
        }
        return this.sha1hash;
    }

    public byte[] getBytes() {
        assert (this.bytes != null) : "This Binary object was purged and has no content";
        return this.bytes;
    }

    public InputStream getStream() {
        assert (this.bytes != null) : "This Binary object was purged and has no content";
        return new ByteArrayInputStream(this.bytes);
    }

    public void acquire() {
    }

    public void release() {
    }

    public void purge() {
        this.bytes = null;
    }
}

