/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.text.XmlNameEncoder;
import org.modeshape.common.xml.StreamingContentHandler;
import org.modeshape.graph.property.Name;
import org.modeshape.jcr.JcrSession;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
abstract class AbstractJcrExporter {
    private static final TextEncoder NAME_ENCODER = new XmlNameEncoder();
    private static final List<String> UNEXPORTABLE_NAMESPACES = Arrays.asList("", "xml", "xmlns");
    protected final JcrSession session;
    private final Collection<String> restrictedPrefixes;
    private final Map<Name, String> prefixedNames;

    AbstractJcrExporter(JcrSession session, Collection<String> restrictedPrefixes) {
        this.session = session;
        this.restrictedPrefixes = restrictedPrefixes;
        this.prefixedNames = new HashMap<Name, String>();
    }

    protected String getPrefixedName(Name baseName) {
        String prefixedName = this.prefixedNames.get(baseName);
        if (prefixedName == null) {
            prefixedName = baseName.getString(this.session.getExecutionContext().getNamespaceRegistry());
            this.prefixedNames.put(baseName, prefixedName);
        }
        return prefixedName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportView(Node exportRootNode, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws RepositoryException, SAXException {
        int i;
        assert (exportRootNode != null);
        assert (contentHandler != null);
        this.session.checkLive();
        NamespaceRegistry registry = this.session.getWorkspace().getNamespaceRegistry();
        contentHandler.startDocument();
        String[] namespacePrefixes = registry.getPrefixes();
        for (i = 0; i < namespacePrefixes.length; ++i) {
            String prefix = namespacePrefixes[i];
            if (this.restrictedPrefixes.contains(prefix)) continue;
            contentHandler.startPrefixMapping(prefix, registry.getURI(prefix));
        }
        try {
            this.exportNode(exportRootNode, contentHandler, skipBinary, noRecurse);
        }
        finally {
            exportRootNode.refresh(true);
        }
        for (i = 0; i < namespacePrefixes.length; ++i) {
            if (this.restrictedPrefixes.contains(namespacePrefixes[i])) continue;
            contentHandler.endPrefixMapping(namespacePrefixes[i]);
        }
        contentHandler.endDocument();
    }

    public void exportView(Node node, OutputStream os, boolean skipBinary, boolean noRecurse) throws RepositoryException {
        try {
            this.exportView(node, (ContentHandler)new StreamingContentHandler(os, UNEXPORTABLE_NAMESPACES), skipBinary, noRecurse);
            os.flush();
        }
        catch (IOException ioe) {
            throw new RepositoryException((Throwable)ioe);
        }
        catch (SAXException se) {
            throw new RepositoryException((Throwable)se);
        }
    }

    public abstract void exportNode(Node var1, ContentHandler var2, boolean var3, boolean var4) throws RepositoryException, SAXException;

    protected void startElement(ContentHandler contentHandler, Name name, Attributes atts) throws SAXException {
        contentHandler.startElement(name.getNamespaceUri(), NAME_ENCODER.encode(name.getLocalName()), NAME_ENCODER.encode(this.getPrefixedName(name)), atts);
    }

    protected void endElement(ContentHandler contentHandler, Name name) throws SAXException {
        contentHandler.endElement(name.getNamespaceUri(), NAME_ENCODER.encode(name.getLocalName()), NAME_ENCODER.encode(this.getPrefixedName(name)));
    }
}

