/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.ExtensionHttpPreprocessor;
import org.jboss.resteasy.core.MessageBodyParameterInjector;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.specimpl.RequestImpl;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpRequestPreprocessor;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InternalDispatcher;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.NoLogWebApplicationException;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ReaderException;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.UnhandledException;
import org.jboss.resteasy.spi.WriterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronousDispatcher
implements Dispatcher {
    protected ResteasyProviderFactory providerFactory;
    protected Registry registry;
    protected List<HttpRequestPreprocessor> requestPreprocessors = new ArrayList<HttpRequestPreprocessor>();
    protected ExtensionHttpPreprocessor extentionHttpPreprocessor;
    protected Map<Class, Object> defaultContextObjects = new HashMap<Class, Object>();
    private static final Logger logger = LoggerFactory.getLogger(SynchronousDispatcher.class);

    public SynchronousDispatcher(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
        this.registry = new ResourceMethodRegistry(providerFactory);
        this.extentionHttpPreprocessor = new ExtensionHttpPreprocessor();
        this.requestPreprocessors.add(this.extentionHttpPreprocessor);
    }

    @Override
    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public void setMediaTypeMappings(Map<String, MediaType> mediaTypeMappings) {
        this.extentionHttpPreprocessor.mediaTypeMappings = mediaTypeMappings;
    }

    @Override
    public void setLanguageMappings(Map<String, String> languageMappings) {
        this.extentionHttpPreprocessor.languageMappings = languageMappings;
    }

    @Override
    public Map<String, MediaType> getMediaTypeMappings() {
        return this.extentionHttpPreprocessor.mediaTypeMappings;
    }

    @Override
    public Map<Class, Object> getDefaultContextObjects() {
        return this.defaultContextObjects;
    }

    @Override
    public Map<String, String> getLanguageMappings() {
        return this.extentionHttpPreprocessor.languageMappings;
    }

    protected void preprocess(HttpRequest in) {
        this.preprocessExtensions(in);
    }

    protected void preprocessExtensions(HttpRequest in) {
        for (HttpRequestPreprocessor preprocessor : this.requestPreprocessors) {
            preprocessor.preProcess(in);
        }
    }

    @Override
    public void invoke(HttpRequest request, HttpResponse response) {
        try {
            ResourceInvoker invoker = this.getInvoker(request, response);
            this.invoke(request, response, invoker);
        }
        catch (Failure e) {
            this.handleException(request, response, e);
            return;
        }
    }

    public ResourceInvoker getInvoker(HttpRequest request, HttpResponse response) throws Failure {
        logger.debug("PathInfo: " + request.getUri().getPath());
        if (!request.isInitial()) {
            throw new InternalServerErrorException(request.getUri().getPath() + " is not initial request.  Its suspended and retried.  Aborting.");
        }
        this.preprocess(request);
        ResourceInvoker invoker = this.registry.getResourceInvoker(request, response);
        if (invoker == null) {
            throw new NotFoundException("Unable to find JAX-RS resource associated with path: " + request.getUri().getPath());
        }
        return invoker;
    }

    public void handleInvokerException(HttpRequest request, HttpResponse response, Exception e) {
        this.handleException(request, response, e);
    }

    public void handleWriteResponseException(HttpRequest request, HttpResponse response, Exception e) {
        this.handleException(request, response, e);
    }

    public void handleException(HttpRequest request, HttpResponse response, Exception e) {
        if (this.executeExceptionMapper(response, e)) {
            return;
        }
        if (e instanceof ApplicationException) {
            this.handleApplicationException(response, (ApplicationException)e);
        } else if (e instanceof WriterException) {
            this.handleWriterException(request, response, (WriterException)e);
        } else if (e instanceof ReaderException) {
            this.handleReaderException(request, response, (ReaderException)e);
        } else if (e instanceof WebApplicationException) {
            this.handleWebApplicationException(response, (WebApplicationException)((Object)e));
        } else if (e instanceof Failure) {
            this.handleFailure(request, response, (Failure)e);
        } else {
            logger.error("Unknown exception while executing " + request.getHttpMethod() + " " + request.getUri().getPath(), (Throwable)e);
            throw new UnhandledException(e);
        }
    }

    protected void handleFailure(HttpRequest request, HttpResponse response, Failure failure) {
        if (failure.isLoggable()) {
            logger.error("Failed executing " + request.getHttpMethod() + " " + request.getUri().getPath(), (Throwable)failure);
        } else {
            logger.debug("Failed executing " + request.getHttpMethod() + " " + request.getUri().getPath(), (Throwable)failure);
        }
        if (failure.getResponse() != null) {
            this.writeFailure(response, failure.getResponse());
        } else {
            try {
                if (failure.getMessage() != null) {
                    response.sendError(failure.getErrorCode(), failure.getMessage());
                } else {
                    response.sendError(failure.getErrorCode());
                }
            }
            catch (IOException e1) {
                throw new UnhandledException(e1);
            }
        }
    }

    public boolean executeExceptionMapper(HttpResponse response, Throwable exception) {
        ExceptionMapper<?> mapper = null;
        Class<?> causeClass = exception.getClass();
        while (mapper == null && causeClass != null) {
            mapper = this.providerFactory.getExceptionMapper(causeClass);
            if (mapper != null) continue;
            causeClass = causeClass.getSuperclass();
        }
        if (mapper != null) {
            this.writeFailure(response, mapper.toResponse(exception));
            return true;
        }
        return false;
    }

    protected void handleApplicationException(HttpResponse response, ApplicationException e) {
        if (this.executeExceptionMapper(response, e.getCause())) {
            return;
        }
        if (e.getCause() instanceof WebApplicationException) {
            this.handleWebApplicationException(response, (WebApplicationException)e.getCause());
            return;
        }
        throw new UnhandledException(e.getCause());
    }

    protected void handleWriterException(HttpRequest request, HttpResponse response, WriterException e) {
        if (e.getResponse() != null || e.getErrorCode() > -1) {
            this.handleFailure(request, response, e);
            return;
        }
        if (e.getCause() != null) {
            if (this.executeExceptionMapper(response, e.getCause())) {
                return;
            }
            if (e.getCause() instanceof WebApplicationException) {
                this.handleWebApplicationException(response, (WebApplicationException)e.getCause());
                return;
            }
            if (e.getCause() instanceof Failure) {
                this.handleFailure(request, response, (Failure)e.getCause());
                return;
            }
        }
        e.setErrorCode(500);
        this.handleFailure(request, response, e);
    }

    protected void handleReaderException(HttpRequest request, HttpResponse response, ReaderException e) {
        if (e.getResponse() != null || e.getErrorCode() > -1) {
            this.handleFailure(request, response, e);
            return;
        }
        if (e.getCause() != null) {
            if (this.executeExceptionMapper(response, e.getCause())) {
                return;
            }
            if (e.getCause() instanceof WebApplicationException) {
                this.handleWebApplicationException(response, (WebApplicationException)e.getCause());
                return;
            }
            if (e.getCause() instanceof Failure) {
                this.handleFailure(request, response, (Failure)e.getCause());
                return;
            }
        }
        e.setErrorCode(400);
        this.handleFailure(request, response, e);
    }

    protected void writeFailure(HttpResponse response, Response jaxrsResponse) {
        response.reset();
        try {
            this.writeJaxrsResponse(response, jaxrsResponse);
        }
        catch (WebApplicationException ex) {
            if (response.isCommitted()) {
                throw new UnhandledException("Request was committed couldn't handle exception", ex);
            }
            response.reset();
            response.setStatus(ex.getResponse().getStatus());
        }
        catch (Exception e1) {
            throw new UnhandledException(e1);
        }
    }

    protected void handleWebApplicationException(HttpResponse response, WebApplicationException wae) {
        if (!(wae instanceof NoLogWebApplicationException)) {
            logger.error("failed to execute", (Throwable)wae);
        }
        if (response.isCommitted()) {
            throw new UnhandledException("Request was committed couldn't handle exception", wae);
        }
        this.writeFailure(response, wae.getResponse());
    }

    public void pushContextObjects(HttpRequest request, HttpResponse response) {
        ResteasyProviderFactory.pushContext(HttpRequest.class, request);
        ResteasyProviderFactory.pushContext(HttpResponse.class, response);
        ResteasyProviderFactory.pushContext(HttpHeaders.class, request.getHttpHeaders());
        ResteasyProviderFactory.pushContext(UriInfo.class, request.getUri());
        ResteasyProviderFactory.pushContext(Request.class, new RequestImpl(request));
        ResteasyProviderFactory.pushContext(Providers.class, this.providerFactory);
        ResteasyProviderFactory.pushContext(Registry.class, this.registry);
        ResteasyProviderFactory.pushContext(Dispatcher.class, this);
        ResteasyProviderFactory.pushContext(InternalDispatcher.class, InternalDispatcher.getInstance());
        for (Map.Entry<Class, Object> entry : this.defaultContextObjects.entrySet()) {
            ResteasyProviderFactory.pushContext(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response internalInvocation(HttpRequest request, HttpResponse response, Object entity) {
        ResteasyProviderFactory.addContextDataLevel();
        boolean pushedBody = false;
        try {
            MessageBodyParameterInjector.pushBody(entity);
            pushedBody = true;
            ResourceInvoker invoker = this.getInvoker(request, response);
            if (invoker != null) {
                this.pushContextObjects(request, response);
                Response response2 = this.getResponse(request, response, invoker);
                return response2;
            }
            Response response3 = null;
            return response3;
        }
        finally {
            ResteasyProviderFactory.removeContextDataLevel();
            if (pushedBody) {
                MessageBodyParameterInjector.popBody();
            }
        }
    }

    public void clearContextData() {
        ResteasyProviderFactory.clearContextData();
        MessageBodyParameterInjector.clearBodies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(HttpRequest request, HttpResponse response, ResourceInvoker invoker) {
        try {
            this.pushContextObjects(request, response);
            Response jaxrsResponse = this.getResponse(request, response, invoker);
            try {
                if (jaxrsResponse != null) {
                    this.writeJaxrsResponse(response, jaxrsResponse);
                }
            }
            catch (Exception e) {
                this.handleWriteResponseException(request, response, e);
            }
        }
        finally {
            this.clearContextData();
        }
    }

    protected Response getResponse(HttpRequest request, HttpResponse response, ResourceInvoker invoker) {
        ServerResponse jaxrsResponse = null;
        try {
            jaxrsResponse = invoker.invoke(request, response);
            if (request.isSuspended()) {
                request.initialRequestThreadFinished();
                jaxrsResponse = null;
            }
        }
        catch (Exception e) {
            this.handleInvokerException(request, response, e);
        }
        return jaxrsResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asynchronousDelivery(HttpRequest request, HttpResponse response, Response jaxrsResponse) {
        try {
            this.pushContextObjects(request, response);
            try {
                if (jaxrsResponse != null) {
                    this.writeJaxrsResponse(response, jaxrsResponse);
                }
            }
            catch (Exception e) {
                this.handleWriteResponseException(request, response, e);
            }
        }
        finally {
            this.clearContextData();
        }
    }

    protected void writeJaxrsResponse(HttpResponse response, Response jaxrsResponse) throws WriterException {
        ServerResponse serverResponse = (ServerResponse)jaxrsResponse;
        serverResponse.writeTo(response, this.providerFactory);
    }

    @Override
    public void addHttpPreprocessor(HttpRequestPreprocessor httpPreprocessor) {
        this.requestPreprocessors.add(httpPreprocessor);
    }
}

