/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.ical;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Pattern;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.component.VJournal;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.parameter.CuType;
import net.fortuna.ical4j.model.parameter.Encoding;
import net.fortuna.ical4j.model.parameter.PartStat;
import net.fortuna.ical4j.model.parameter.Range;
import net.fortuna.ical4j.model.parameter.RelType;
import net.fortuna.ical4j.model.parameter.Related;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.parameter.Rsvp;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Transp;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.node.DatatypeLiteral;
import org.ontoware.rdf2go.model.node.Literal;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.PlainLiteral;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.ontoware.rdf2go.vocabulary.RDFS;
import org.ontoware.rdf2go.vocabulary.XSD;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.base.DataObjectBase;
import org.semanticdesktop.aperture.accessor.base.FileDataObjectBase;
import org.semanticdesktop.aperture.crawler.ExitCode;
import org.semanticdesktop.aperture.crawler.base.CrawlerBase;
import org.semanticdesktop.aperture.datasource.ical.IcalDataSource;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.StringUtil;
import org.semanticdesktop.aperture.util.UriUtil;
import org.semanticdesktop.aperture.vocabulary.GEO;
import org.semanticdesktop.aperture.vocabulary.NCAL;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IcalCrawler
extends CrawlerBase {
    public static final URI XSD_YEAR_MONTH_DURATION = new URIImpl("http://www.w3.org/2001/XMLSchema#yearMonthDuration");
    public static final URI XSD_DAY_TIME_DURATION = new URIImpl("http://www.w3.org/2001/XMLSchema#dayTimeDuration");
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private String baseuri;
    private Pattern icalDurationPattern = Pattern.compile("(\\+|-)?P((\\d+W)|(\\d+D(T\\d+H(\\d+M(\\d+S)?)?)?)|(T\\d+H(\\d+M(\\d+S)?)?))");

    @Override
    protected ExitCode crawlObjects() {
        IcalDataSource icalDataSource = null;
        try {
            icalDataSource = (IcalDataSource)this.source;
        }
        catch (ClassCastException classCastException) {
            this.logger.error("unsupported data source type", (Throwable)classCastException);
            return ExitCode.FATAL_ERROR;
        }
        String string = icalDataSource.getRootUrl();
        if (string == null) {
            this.logger.warn("missing iCalendar file path specification");
            return ExitCode.FATAL_ERROR;
        }
        File file = new File(string);
        if (!file.exists()) {
            this.logger.warn("iCalendar file does not exist: '" + file + "'");
            return ExitCode.FATAL_ERROR;
        }
        if (!file.canRead()) {
            this.logger.warn("iCalendar file cannot be read: '" + file + "'");
            return ExitCode.FATAL_ERROR;
        }
        try {
            this.baseuri = this.createBaseUri(file);
        }
        catch (IOException iOException) {
            this.logger.error("Couldn't get the canonical path for the iCalFile", (Throwable)iOException);
            return ExitCode.FATAL_ERROR;
        }
        return this.crawlIcalFile(file);
    }

    private String createBaseUri(File file) throws IOException {
        return file.getCanonicalFile().toURI() + "#";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ExitCode crawlIcalFile(File file) {
        InputStreamReader inputStreamReader = null;
        CalendarBuilder calendarBuilder = null;
        Calendar calendar = null;
        try {
            System.setProperty("ical4j.unfolding.relaxed", "true");
            CompatibilityHints.setHintEnabled((String)"ical4j.compatibility.notes", (boolean)true);
            inputStreamReader = new FileReader(file);
            calendarBuilder = new CalendarBuilder();
            calendar = calendarBuilder.build((Reader)inputStreamReader);
            this.crawlCalendar(calendar);
            ExitCode exitCode = ExitCode.COMPLETED;
            return exitCode;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logger.warn("Couldn't find the calendar file", (Throwable)fileNotFoundException);
            ExitCode exitCode = ExitCode.FATAL_ERROR;
            return exitCode;
        }
        catch (ParserException parserException) {
            this.logger.warn("Couldn't parse the calendar file", (Throwable)parserException);
            ExitCode exitCode = ExitCode.FATAL_ERROR;
            return exitCode;
        }
        catch (IOException iOException) {
            this.logger.warn("Input/Output error while parsing the calendar file", (Throwable)iOException);
            ExitCode exitCode = ExitCode.FATAL_ERROR;
            return exitCode;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void crawlCalendar(Calendar calendar) {
        URI uRI = this.generateCalendarUri();
        RDFContainer rDFContainer = this.prepareDataObjectRDFContainer(uRI);
        rDFContainer.add(RDF.type, (Node)NCAL.Calendar);
        PropertyList propertyList = calendar.getProperties();
        this.crawlPropertyList(propertyList, (Resource)rDFContainer.getDescribedUri(), rDFContainer, null);
        rDFContainer.add(NIE.rootElementOf, (Node)this.getDataSource().getID());
        this.passComponentToHandler(rDFContainer, null);
        ComponentList componentList = calendar.getComponents();
        this.crawlComponentList(componentList, rDFContainer);
    }

    private void crawlSingleComponent(Component component, Resource resource, RDFContainer rDFContainer) throws ModelException {
        if (component.getName().equals("VALARM")) {
            this.crawlAlarmComponent(component, resource, rDFContainer);
        } else if (component.getName().equals("VEVENT")) {
            this.crawlEventComponent(component, resource);
        } else if (component.getName().equals("VFREEBUSY")) {
            this.crawlFreebusyComponent(component, resource);
        } else if (component.getName().equals("VJOURNAL")) {
            this.crawlJournalComponent(component, resource);
        } else if (component.getName().equals("VTIMEZONE")) {
            this.crawlTimezoneComponent(component, resource);
        } else if (component.getName().equals("VTODO")) {
            this.crawlTodoComponent(component, resource);
        } else if (component.getName().equals("STANDARD")) {
            this.crawlStandardObservance(component, resource, rDFContainer);
        } else if (component.getName().equals("DAYLIGHT")) {
            this.crawlDaylightObservance(component, resource, rDFContainer);
        } else if (component.getName().startsWith("X-")) {
            this.crawlExperimentalComponent(component, resource);
        } else {
            this.logger.warn("Unknown component name: " + component.getName());
        }
    }

    private void crawlSingleProperty(Property property, Resource resource, RDFContainer rDFContainer, Component component) throws ModelException {
        String string = property.getName();
        if (string.equals("ACTION")) {
            this.crawlActionProperty(property, resource, rDFContainer);
        } else if (string.startsWith("ATTACH")) {
            this.crawlAttachProperty(property, resource, rDFContainer);
        } else if (string.startsWith("ATTENDEE")) {
            this.crawlAttendeeProperty(property, resource, rDFContainer);
        } else if (string.startsWith("CALSCALE")) {
            this.crawlCalScaleProperty(property, resource, rDFContainer);
        } else if (string.startsWith("CATEGORIES")) {
            this.crawlCategoriesProperty(property, resource, rDFContainer);
        } else if (string.startsWith("CLASS")) {
            this.crawlClassProperty(property, resource, rDFContainer);
        } else if (string.startsWith("COMMENT")) {
            this.crawlCommentProperty(property, resource, rDFContainer);
        } else if (string.startsWith("COMPLETED")) {
            this.crawlCompletedProperty(property, resource, rDFContainer);
        } else if (string.startsWith("CONTACT")) {
            this.crawlContactProperty(property, resource, rDFContainer);
        } else if (string.startsWith("CREATED")) {
            this.crawlCreatedProperty(property, resource, rDFContainer);
        } else if (string.startsWith("DESCRIPTION")) {
            this.crawlDescriptionProperty(property, resource, rDFContainer);
        } else if (string.startsWith("DTEND")) {
            this.crawlDtEndProperty(property, resource, rDFContainer);
        } else if (string.startsWith("DTSTAMP")) {
            this.crawlDtStampProperty(property, resource, rDFContainer);
        } else if (string.startsWith("DTSTART")) {
            this.crawlDtStartProperty(property, resource, rDFContainer);
        } else if (string.startsWith("DUE")) {
            this.crawlDueProperty(property, resource, rDFContainer);
        } else if (string.startsWith("DURATION")) {
            this.crawlDurationProperty(property, resource, rDFContainer);
        } else if (string.startsWith("EXDATE")) {
            this.crawlExDateProperty(property, resource, rDFContainer);
        } else if (string.startsWith("EXRULE")) {
            this.crawlExRuleProperty(property, resource, rDFContainer);
        } else if (string.startsWith("FREEBUSY")) {
            this.crawlFreeBusyProperty(property, resource, rDFContainer);
        } else if (string.startsWith("GEO")) {
            this.crawlGeoProperty(property, resource, rDFContainer);
        } else if (string.startsWith("LAST-MODIFIED")) {
            this.crawlLastModifiedProperty(property, resource, rDFContainer);
        } else if (string.startsWith("LOCATION")) {
            this.crawlLocationProperty(property, resource, rDFContainer);
        } else if (string.startsWith("METHOD")) {
            this.crawlMethodProperty(property, resource, rDFContainer);
        } else if (string.startsWith("ORGANIZER")) {
            this.crawlOrganizerProperty(property, resource, rDFContainer);
        } else if (string.startsWith("PERCENT-COMPLETE")) {
            this.crawlPercentCompleteProperty(property, resource, rDFContainer);
        } else if (string.startsWith("PRIORITY")) {
            this.crawlPriorityProperty(property, resource, rDFContainer);
        } else if (string.startsWith("PRODID")) {
            this.crawlProdIdProperty(property, resource, rDFContainer);
        } else if (string.startsWith("RDATE")) {
            this.crawlRDateProperty(property, resource, rDFContainer);
        } else if (string.startsWith("RECURRENCE-ID")) {
            this.crawlRecurrenceIdProperty(property, resource, rDFContainer);
        } else if (string.startsWith("RELATED-TO")) {
            this.crawlRelatedToProperty(property, resource, rDFContainer);
        } else if (string.startsWith("REPEAT")) {
            this.crawlRepeatProperty(property, resource, rDFContainer);
        } else if (string.startsWith("REQUEST-STATUS")) {
            this.crawlRequestStatusProperty(property, resource, rDFContainer);
        } else if (string.startsWith("RESOURCES")) {
            this.crawlResourcesProperty(property, resource, rDFContainer);
        } else if (string.startsWith("RRULE")) {
            this.crawlRRuleProperty(property, resource, rDFContainer);
        } else if (string.startsWith("SEQUENCE")) {
            this.crawlSequenceProperty(property, resource, rDFContainer);
        } else if (string.startsWith("STATUS")) {
            this.crawlStatusProperty(property, resource, rDFContainer, component);
        } else if (string.startsWith("SUMMARY")) {
            this.crawlSummaryProperty(property, resource, rDFContainer);
        } else if (string.startsWith("TRANSP")) {
            this.crawlTranspProperty(property, resource, rDFContainer);
        } else if (string.startsWith("TRIGGER")) {
            this.crawlTriggerProperty(property, resource, rDFContainer);
        } else if (string.startsWith("TZID")) {
            this.crawlTzidProperty(property, resource, rDFContainer);
        } else if (string.startsWith("TZNAME")) {
            this.crawlTzNameProperty(property, resource, rDFContainer);
        } else if (string.startsWith("TZOFFSETFROM")) {
            this.crawlTzOffsetFromProperty(property, resource, rDFContainer);
        } else if (string.startsWith("TZOFFSETTO")) {
            this.crawlTzOffsetToProperty(property, resource, rDFContainer);
        } else if (string.startsWith("TZURL")) {
            this.crawlTzUrlProperty(property, resource, rDFContainer);
        } else if (string.startsWith("UID")) {
            this.crawlUidProperty(property, resource, rDFContainer);
        } else if (string.startsWith("URL")) {
            this.crawlUrlProperty(property, resource, rDFContainer);
        } else if (string.startsWith("VERSION")) {
            this.crawlVersionProperty(property, resource, rDFContainer);
        } else if (string.startsWith("X-")) {
            this.crawlXtendedProperty(property, resource, rDFContainer);
        } else {
            this.logger.warn("Unknown property name: " + property.getName());
        }
    }

    private void crawlSingleParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
        String string = parameter.getName();
        if (string.equals("ALTREP")) {
            this.crawlAltRepParameter(parameter, resource, rDFContainer);
        } else if (string.equals("CN")) {
            this.crawlCnParameter(parameter, resource, rDFContainer);
        } else if (string.equals("CUTYPE")) {
            this.crawlCuTypeParameter(parameter, resource, rDFContainer);
        } else if (string.equals("DELEGATED-FROM")) {
            this.crawlDelegatedFromParameter(parameter, resource, rDFContainer);
        } else if (string.equals("DELEGATED-TO")) {
            this.crawlDelegatedToParameter(parameter, resource, rDFContainer);
        } else if (string.equals("DIR")) {
            this.crawlDirParameter(parameter, resource, rDFContainer);
        } else if (string.equals("ENCODING")) {
            this.crawlEncodingParameter(parameter, resource, rDFContainer);
        } else if (string.equals("FBTYPE")) {
            this.crawlFbTypeParameter(parameter, resource, rDFContainer);
        } else if (string.equals("FMTTYPE")) {
            this.crawlFmtTypeParameter(parameter, resource, rDFContainer);
        } else if (string.equals("LANGUAGE")) {
            this.crawlLanguageParameter(parameter, resource, rDFContainer);
        } else if (string.equals("MEMBER")) {
            this.crawlMemberParameter(parameter, resource, rDFContainer);
        } else if (string.equals("PARTSTAT")) {
            this.crawlPartStatParameter(parameter, resource, rDFContainer);
        } else if (string.equals("RANGE")) {
            this.crawlRangeParameter(parameter, resource, rDFContainer);
        } else if (string.equals("RELATED")) {
            this.crawlRelatedParameter(parameter, resource, rDFContainer);
        } else if (string.equals("RELTYPE")) {
            this.crawlRelTypeParameter(parameter, resource, rDFContainer);
        } else if (string.equals("ROLE")) {
            this.crawlRoleParameter(parameter, resource, rDFContainer);
        } else if (string.equals("RSVP")) {
            this.crawlRsvpParameter(parameter, resource, rDFContainer);
        } else if (string.equals("SENT-BY")) {
            this.crawlSentByParameter(parameter, resource, rDFContainer);
        } else if (string.equals("TZID")) {
            this.crawlTzidParameter(parameter, resource, rDFContainer);
        } else if (string.equals("VALUE")) {
            this.crawlValueParameter(parameter, resource, rDFContainer);
        } else if (string.startsWith("X-")) {
            this.crawlXParameter(parameter, resource, rDFContainer);
        } else {
            this.logger.warn("Unknown parameter name: '" + string + "'");
        }
    }

    private void crawlComponentList(ComponentList componentList, RDFContainer rDFContainer) {
        for (Component component : componentList) {
            try {
                this.crawlSingleComponent(component, (Resource)rDFContainer.getDescribedUri(), rDFContainer);
            }
            catch (ModelException modelException) {
                this.logger.warn("ModelException while processing single component, skipping component", (Throwable)modelException);
            }
        }
    }

    private void crawlPropertyList(Component component, RDFContainer rDFContainer) {
        this.crawlPropertyList(component, (Resource)rDFContainer.getDescribedUri(), rDFContainer);
    }

    private void crawlPropertyList(Component component, Resource resource, RDFContainer rDFContainer) {
        PropertyList propertyList = component.getProperties();
        this.crawlPropertyList(propertyList, resource, rDFContainer, component);
    }

    private void crawlPropertyList(PropertyList propertyList, Resource resource, RDFContainer rDFContainer, Component component) {
        for (Property property : propertyList) {
            try {
                this.crawlSingleProperty(property, resource, rDFContainer, component);
            }
            catch (ModelException modelException) {
                this.logger.warn("ModelException while handling single property, skipping property", (Throwable)modelException);
            }
        }
    }

    private Resource crawlParameterList(Property property, RDFContainer rDFContainer) {
        Resource resource = this.generateAnonymousNode(rDFContainer);
        ParameterList parameterList = property.getParameters();
        this.crawlParameterList(parameterList, resource, rDFContainer);
        return resource;
    }

    private void crawlParameterList(ParameterList parameterList, Resource resource, RDFContainer rDFContainer) {
        for (Parameter parameter : parameterList) {
            this.crawlSingleParameter(parameter, resource, rDFContainer);
        }
    }

    public void crawlAlarmComponent(Component component, Resource resource, RDFContainer rDFContainer) {
        VAlarm vAlarm = (VAlarm)component;
        URI uRI = this.generateAnonymousComponentUri(component);
        this.crawlPropertyList((Component)vAlarm, (Resource)uRI, rDFContainer);
        this.addStatement(rDFContainer, resource, NCAL.hasAlarm, (Node)uRI);
        this.addStatement(rDFContainer, (Resource)uRI, RDF.type, (Node)NCAL.Alarm);
        this.addStatement(rDFContainer, (Resource)uRI, RDF.type, (Node)NCAL.CalendarDataObject);
    }

    public void crawlEventComponent(Component component, Resource resource) {
        RDFContainer rDFContainer = this.prepareDataObjectRDFContainer(component);
        rDFContainer.add(RDF.type, (Node)NCAL.Event);
        VEvent vEvent = (VEvent)component;
        this.crawlPropertyList((Component)vEvent, rDFContainer);
        ComponentList componentList = vEvent.getAlarms();
        this.crawlComponentList(componentList, rDFContainer);
        this.addStatement(rDFContainer, resource, NCAL.component, (Node)rDFContainer.getDescribedUri());
        this.passComponentToHandler(rDFContainer, component);
    }

    public void crawlFreebusyComponent(Component component, Resource resource) {
        RDFContainer rDFContainer = this.prepareDataObjectRDFContainer(component);
        VFreeBusy vFreeBusy = (VFreeBusy)component;
        rDFContainer.add(RDF.type, (Node)NCAL.Freebusy);
        this.crawlPropertyList((Component)vFreeBusy, rDFContainer);
        this.addStatement(rDFContainer, resource, NCAL.component, (Node)rDFContainer.getDescribedUri());
        this.passComponentToHandler(rDFContainer, component);
    }

    public void crawlJournalComponent(Component component, Resource resource) {
        RDFContainer rDFContainer = this.prepareDataObjectRDFContainer(component);
        rDFContainer.add(RDF.type, (Node)NCAL.Journal);
        VJournal vJournal = (VJournal)component;
        this.crawlPropertyList((Component)vJournal, rDFContainer);
        this.addStatement(rDFContainer, resource, NCAL.component, (Node)rDFContainer.getDescribedUri());
        this.passComponentToHandler(rDFContainer, component);
    }

    public void crawlTimezoneComponent(Component component, Resource resource) {
        RDFContainer rDFContainer = this.prepareDataObjectRDFContainer(component);
        rDFContainer.add(RDF.type, (Node)NCAL.Timezone);
        VTimeZone vTimeZone = (VTimeZone)component;
        this.crawlPropertyList((Component)vTimeZone, rDFContainer);
        ComponentList componentList = vTimeZone.getObservances();
        this.crawlComponentList(componentList, rDFContainer);
        this.addStatement(rDFContainer, resource, NCAL.component, (Node)rDFContainer.getDescribedUri());
        this.passComponentToHandler(rDFContainer, component);
    }

    public void crawlTodoComponent(Component component, Resource resource) {
        RDFContainer rDFContainer = this.prepareDataObjectRDFContainer(component);
        rDFContainer.add(RDF.type, (Node)NCAL.Todo);
        VToDo vToDo = (VToDo)component;
        this.crawlPropertyList((Component)vToDo, rDFContainer);
        ComponentList componentList = vToDo.getAlarms();
        this.crawlComponentList(componentList, rDFContainer);
        this.addStatement(rDFContainer, resource, NCAL.component, (Node)rDFContainer.getDescribedUri());
        this.passComponentToHandler(rDFContainer, component);
    }

    public void crawlExperimentalComponent(Component component, Resource resource) {
    }

    public void crawlStandardObservance(Component component, Resource resource, RDFContainer rDFContainer) {
        Resource resource2 = this.generateAnonymousNode(rDFContainer);
        this.addStatement(rDFContainer, resource2, RDF.type, (Node)NCAL.TimezoneObservance);
        this.crawlPropertyList(component, resource2, rDFContainer);
        this.addStatement(rDFContainer, resource, NCAL.standard, (Node)resource2);
    }

    public void crawlDaylightObservance(Component component, Resource resource, RDFContainer rDFContainer) {
        Resource resource2 = this.generateAnonymousNode(rDFContainer);
        this.addStatement(rDFContainer, resource2, RDF.type, (Node)NCAL.TimezoneObservance);
        this.crawlPropertyList(component, resource2, rDFContainer);
        this.addStatement(rDFContainer, resource, NCAL.daylight, (Node)resource2);
    }

    public void crawlActionProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        String string = property.getValue();
        if (string.equals(Action.AUDIO.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.action, (Node)NCAL.audioAction);
        } else if (string.equals(Action.DISPLAY.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.action, (Node)NCAL.displayAction);
        } else if (string.equals(Action.EMAIL.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.action, (Node)NCAL.emailAction);
        } else if (string.equals(Action.PROCEDURE.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.action, (Node)NCAL.procedureAction);
        } else {
            this.logger.warn("Unknown action property value: " + string);
        }
    }

    public void crawlAttachProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        URI uRI = this.generateAttachmentUri(rDFContainer.getDescribedUri());
        Parameter parameter = property.getParameter("VALUE");
        String string = property.getValue();
        this.addStatement(rDFContainer, resource, NCAL.attach, (Node)uRI);
        if (parameter == null || parameter.equals((Object)Value.URI)) {
            URI uRI2 = this.tryToCreateAnUri(rDFContainer, string);
            this.addStatement(rDFContainer, (Resource)uRI, RDF.type, (Node)NCAL.Attachment);
            this.addStatement(rDFContainer, (Resource)uRI, NCAL.attachmentUri, (Node)uRI2);
            this.addStatement(rDFContainer, (Resource)uRI2, RDF.type, (Node)RDFS.Resource);
        } else if (parameter.equals((Object)Value.BINARY)) {
            RDFContainer rDFContainer2 = this.prepareDataObjectRDFContainer(uRI);
            this.addStatement(rDFContainer2, (Resource)uRI, RDF.type, (Node)NCAL.Attachment);
            this.crawlParameterList(property, rDFContainer2);
            Attach attach = (Attach)property;
            this.passAttachmentToHandler(rDFContainer2, attach.getBinary());
        }
    }

    public void crawlAttendeeProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Resource resource2 = this.crawlParameterList(property, rDFContainer);
        this.addStatement(rDFContainer, resource, NCAL.attendee, (Node)resource2);
        this.processAttendeeOrOrganizer(property, resource2, rDFContainer);
        this.addStatement(rDFContainer, resource2, RDF.type, (Node)NCAL.Attendee);
    }

    public void crawlCalScaleProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        String string = property.getValue();
        if (string.equals(CalScale.GREGORIAN.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.calscale, (Node)NCAL.gregorianCalendarScale);
        }
    }

    public void crawlCategoriesProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.categories, property.getValue());
    }

    public void crawlClassProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        String string = property.getValue();
        if (string.equals(Clazz.CONFIDENTIAL.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.class_, (Node)NCAL.confidentialClassification);
        } else if (string.equals(Clazz.PRIVATE.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.class_, (Node)NCAL.privateClassification);
        } else if (string.equals(Clazz.PUBLIC.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.class_, (Node)NCAL.publicClassification);
        } else {
            this.logger.warn("Unknown CLASS property value: " + string);
        }
    }

    public void crawlCommentProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.comment, property.getValue());
    }

    public void crawlCompletedProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Node node = this.getRdfPropertyValue(rDFContainer, property, "DATE-TIME");
        this.addStatement(rDFContainer, resource, NCAL.completed, node);
    }

    public void crawlContactProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.contact, property.getValue());
    }

    public void crawlCreatedProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Node node = this.getRdfPropertyValue(rDFContainer, property, "DATE-TIME");
        this.addStatement(rDFContainer, resource, NCAL.created, node);
    }

    public void crawlDescriptionProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.description, property.getValue());
    }

    public void crawlDtEndProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Node node = this.getRdfPropertyValue(rDFContainer, property, "NCAL-DATE-TIME");
        this.addStatement(rDFContainer, resource, NCAL.dtend, node);
    }

    public void crawlDtStampProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Node node = this.getRdfPropertyValue(rDFContainer, property, "DATE-TIME");
        this.addStatement(rDFContainer, resource, NCAL.dtstamp, node);
    }

    public void crawlDtStartProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Node node = this.getRdfPropertyValue(rDFContainer, property, "NCAL-DATE-TIME");
        this.addStatement(rDFContainer, resource, NCAL.dtstart, node);
    }

    public void crawlDueProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Node node = this.getRdfPropertyValue(rDFContainer, property, "NCAL-DATE-TIME");
        this.addStatement(rDFContainer, resource, NCAL.due, node);
    }

    public void crawlDurationProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Node node = this.getRdfPropertyValue(rDFContainer, property, "DURATION");
        this.addStatement(rDFContainer, resource, NCAL.duration, node);
    }

    public void crawlExDateProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        List<Node> list = this.getMultipleRdfPropertyValues(rDFContainer, property, "NCAL-DATE-TIME");
        this.addMultipleStatements(rDFContainer, resource, NCAL.exdate, list);
    }

    public void crawlExRuleProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Resource resource2 = this.generateAnonymousNode(rDFContainer);
        this.crawlRecur(property.getValue(), resource2, rDFContainer);
        this.addStatement(rDFContainer, resource, NCAL.exrule, (Node)resource2);
    }

    public void crawlFreeBusyProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        List<Node> list = this.getMultipleRdfPropertyValues(rDFContainer, property, "PERIOD");
        for (Node node : list) {
            Resource resource2 = node.asResource();
            this.addStatement(rDFContainer, resource, NCAL.freebusy, (Node)resource2);
            this.addStatement(rDFContainer, resource2, RDF.type, (Node)NCAL.FreebusyPeriod);
        }
    }

    public void crawlGeoProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        String[] stringArray = property.getValue().split(";");
        DatatypeLiteral datatypeLiteral = rDFContainer.getModel().createDatatypeLiteral(stringArray[0], XSD._decimal);
        DatatypeLiteral datatypeLiteral2 = rDFContainer.getModel().createDatatypeLiteral(stringArray[1], XSD._decimal);
        Resource resource2 = this.generateAnonymousNode(rDFContainer);
        this.addStatement(rDFContainer, resource2, RDF.type, (Node)GEO.Point);
        this.addStatement(rDFContainer, resource2, GEO.lat, (Node)datatypeLiteral);
        this.addStatement(rDFContainer, resource2, GEO.long_, (Node)datatypeLiteral2);
        this.addStatement(rDFContainer, resource, NCAL.geo, (Node)resource2);
    }

    public void crawlLastModifiedProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Node node = this.getRdfPropertyValue(rDFContainer, property, "DATE-TIME");
        this.addStatement(rDFContainer, resource, NCAL.lastModified, node);
    }

    public void crawlLocationProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.location, property.getValue());
    }

    public void crawlMethodProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.method, property.getValue());
    }

    public void crawlOrganizerProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Resource resource2 = this.crawlParameterList(property, rDFContainer);
        this.addStatement(rDFContainer, resource, NCAL.organizer, (Node)resource2);
        this.processAttendeeOrOrganizer(property, resource2, rDFContainer);
        this.addStatement(rDFContainer, resource2, RDF.type, (Node)NCAL.Organizer);
    }

    public void crawlPercentCompleteProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Node node = this.getRdfPropertyValue(rDFContainer, property, "INTEGER");
        this.addStatement(rDFContainer, resource, NCAL.percentComplete, node);
    }

    public void crawlPriorityProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Node node = this.getRdfPropertyValue(rDFContainer, property, "INTEGER");
        this.addStatement(rDFContainer, resource, NCAL.priority, node);
    }

    public void crawlProdIdProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.prodid, property.getValue());
    }

    public void crawlRDateProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        List<Node> list = this.getMultipleRdfPropertyValues(rDFContainer, property, "NCAL-DATE-TIME");
        this.addMultipleStatements(rDFContainer, resource, NCAL.rdate, list);
    }

    public void crawlRecurrenceIdProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Resource resource2 = this.crawlParameterList(property, rDFContainer);
        Node node = this.getRdfPropertyValue(rDFContainer, property, "NCAL-DATE-TIME");
        this.addStatement(rDFContainer, resource, NCAL.recurrenceId, (Node)resource2);
        this.addStatement(rDFContainer, resource2, NCAL.recurrenceIdDateTime, node);
        this.addStatement(rDFContainer, resource2, RDF.type, (Node)NCAL.RecurrenceIdentifier);
    }

    public void crawlRelatedToProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Parameter parameter = property.getParameter("RELTYPE");
        if (parameter == null) {
            this.addStatement(rDFContainer, resource, NCAL.relatedToParent, property.getValue());
            return;
        }
        String string = parameter.getValue();
        if (string.equals(RelType.CHILD.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.relatedToChild, property.getValue());
        } else if (string.equals(RelType.PARENT.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.relatedToParent, property.getValue());
        } else if (string.equals(RelType.SIBLING.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.relatedToSibling, property.getValue());
        } else {
            this.logger.warn("Unkown RELTYPE parameter value: " + string);
        }
    }

    public void crawlRepeatProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Node node = this.getRdfPropertyValue(rDFContainer, property, "INTEGER");
        this.addStatement(rDFContainer, resource, NCAL.repeat, node);
    }

    public void crawlRequestStatusProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        String string = property.getValue();
        String[] stringArray = string.split(";");
        if (stringArray.length == 0) {
            return;
        }
        Resource resource2 = this.generateAnonymousNode(rDFContainer);
        this.addStatement(rDFContainer, resource2, RDF.type, (Node)NCAL.RequestStatus);
        this.addStatement(rDFContainer, resource2, NCAL.returnStatus, stringArray[0]);
        this.addStatement(rDFContainer, resource, NCAL.requestStatus, (Node)resource2);
        if (stringArray.length >= 2) {
            this.addStatement(rDFContainer, resource2, NCAL.statusDescription, stringArray[1]);
        }
        if (stringArray.length >= 3) {
            String string2 = stringArray[2];
            for (int i = 3; i < stringArray.length; ++i) {
                string2 = string2 + ";" + stringArray[i];
            }
            this.addStatement(rDFContainer, resource2, NCAL.requestStatusData, string2);
        }
    }

    public void crawlResourcesProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        List<Node> list = this.getMultipleRdfPropertyValues(rDFContainer, property, "TEXT");
        this.addMultipleStatements(rDFContainer, resource, NCAL.resources, list);
    }

    public void crawlRRuleProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Resource resource2 = this.generateAnonymousNode(rDFContainer);
        this.crawlRecur(property.getValue(), resource2, rDFContainer);
        this.addStatement(rDFContainer, resource, NCAL.rrule, (Node)resource2);
    }

    public void crawlSequenceProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Node node = this.getRdfPropertyValue(rDFContainer, property, "INTEGER");
        this.addStatement(rDFContainer, resource, NCAL.sequence, node);
    }

    public void crawlStatusProperty(Property property, Resource resource, RDFContainer rDFContainer, Component component) {
        String string = property.getValue();
        if (component == null) {
            this.logger.warn("Trying to crawl the status propperty with a null component argument");
        }
        if (string.equals(Status.VEVENT_CANCELLED.getValue()) || string.equals(Status.VJOURNAL_CANCELLED.getValue()) || string.equals(Status.VTODO_CANCELLED.getValue())) {
            if (component.getName().equals("VEVENT")) {
                this.addStatement(rDFContainer, resource, NCAL.eventStatus, (Node)NCAL.cancelledEventStatus);
            } else if (component.getName().equals("VJOURNAL")) {
                this.addStatement(rDFContainer, resource, NCAL.journalStatus, (Node)NCAL.cancelledJournalStatus);
            } else if (component.getName().equals("VTODO")) {
                this.addStatement(rDFContainer, resource, NCAL.todoStatus, (Node)NCAL.cancelledTodoStatus);
            } else {
                this.logger.warn("Unknown component has an event status: " + component.getName());
            }
        } else if (string.equals(Status.VEVENT_CONFIRMED.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.eventStatus, (Node)NCAL.confirmedStatus);
        } else if (string.equals(Status.VEVENT_TENTATIVE.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.eventStatus, (Node)NCAL.tentativeStatus);
        } else if (string.equals(Status.VJOURNAL_DRAFT.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.journalStatus, (Node)NCAL.draftStatus);
        } else if (string.equals(Status.VJOURNAL_FINAL.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.journalStatus, (Node)NCAL.finalStatus);
        } else if (string.equals(Status.VTODO_COMPLETED.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.todoStatus, (Node)NCAL.completedStatus);
        } else if (string.equals(Status.VTODO_IN_PROCESS.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.todoStatus, (Node)NCAL.inProcessStatus);
        } else if (string.equals(Status.VTODO_NEEDS_ACTION.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.todoStatus, (Node)NCAL.needsActionStatus);
        } else {
            this.logger.warn("Unknown value of the STATUS property: " + string);
        }
    }

    public void crawlSummaryProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.summary, property.getValue());
    }

    public void crawlTranspProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        String string = property.getValue();
        if (string.equals(Transp.OPAQUE.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.transp, (Node)NCAL.opaqueTransparency);
        } else if (string.equals(Transp.TRANSPARENT.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.transp, (Node)NCAL.transparentTransparency);
        } else {
            this.logger.warn("Unknown TRANSP property value: " + string);
        }
    }

    public void crawlTriggerProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Resource resource2 = this.crawlParameterList(property, rDFContainer);
        this.addStatement(rDFContainer, resource, NCAL.trigger, (Node)resource2);
        Node node = this.getRdfPropertyValue(rDFContainer, property, "DURATION");
        Parameter parameter = property.getParameter("VALUE");
        if (parameter == null || parameter.getValue().equals("DURATION")) {
            this.addStatement(rDFContainer, resource2, NCAL.triggerDuration, node);
        } else if (parameter.getValue().equals("DATE-TIME")) {
            this.addStatement(rDFContainer, resource2, NCAL.triggerDateTime, node);
        } else {
            this.logger.warn("Unknown VALUE parameter for the TRIGGER property: " + parameter.getValue());
        }
        this.addStatement(rDFContainer, resource2, RDF.type, (Node)NCAL.Trigger);
    }

    public void crawlTzidProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.tzid, property.getValue());
    }

    public void crawlTzNameProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.tzname, property.getValue());
    }

    public void crawlTzOffsetFromProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.tzoffsetfrom, property.getValue());
    }

    public void crawlTzOffsetToProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.tzoffsetto, property.getValue());
    }

    public void crawlTzUrlProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Node node = this.getRdfPropertyValue(rDFContainer, property, "URI");
        this.addStatement(rDFContainer, resource, NCAL.tzurl, node);
    }

    public void crawlUidProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.uid, property.getValue());
    }

    public void crawlUrlProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        Node node = this.getRdfPropertyValue(rDFContainer, property, "URI");
        this.addStatement(rDFContainer, resource, NCAL.url, node);
    }

    public void crawlVersionProperty(Property property, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.version, property.getValue());
    }

    public void crawlXtendedProperty(Property property, Resource resource, RDFContainer rDFContainer) {
    }

    public void crawlAltRepParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
    }

    public void crawlCnParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
    }

    public void crawlCuTypeParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
        String string = parameter.getValue();
        if (string.equals(CuType.GROUP.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.cutype, (Node)NCAL.groupUserType);
        } else if (string.equals(CuType.INDIVIDUAL.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.cutype, (Node)NCAL.individualUserType);
        } else if (string.equals(CuType.RESOURCE.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.cutype, (Node)NCAL.resourceUserType);
        } else if (string.equals(CuType.ROOM.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.cutype, (Node)NCAL.roomUserType);
        } else if (string.equals(CuType.UNKNOWN.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.cutype, (Node)NCAL.unknownUserType);
        } else {
            this.logger.warn("Unknown CUTYPE parameter value: " + string);
        }
    }

    public void crawlDelegatedToParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.delegatedTo, parameter.getValue());
    }

    public void crawlDelegatedFromParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.delegatedFrom, parameter.getValue());
    }

    public void crawlDirParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.dir, parameter.getValue());
    }

    public void crawlEncodingParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
        String string = parameter.getValue();
        if (string.equals(Encoding.BASE64.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.encoding, (Node)NCAL.base64Encoding);
        } else if (string.equals(Encoding.EIGHT_BIT.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.encoding, (Node)NCAL._8bitEncoding);
        } else {
            this.logger.warn("Unknown encoding type: " + string);
        }
    }

    public void crawlFbTypeParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.fbtype, parameter.getValue());
    }

    private void crawlFmtTypeParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.fmttype, parameter.getValue().toLowerCase());
    }

    public void crawlLanguageParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
    }

    public void crawlMemberParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.member, parameter.getValue());
    }

    public void crawlPartStatParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
        String string = parameter.getValue();
        if (string.equals(PartStat.ACCEPTED.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.partstat, (Node)NCAL.acceptedParticipationStatus);
        } else if (string.equals(PartStat.COMPLETED.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.partstat, (Node)NCAL.completedParticipationStatus);
        } else if (string.equals(PartStat.DECLINED.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.partstat, (Node)NCAL.declinedParticipationStatus);
        } else if (string.equals(PartStat.DELEGATED.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.partstat, (Node)NCAL.delegatedParticipationStatus);
        } else if (string.equals(PartStat.IN_PROCESS.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.partstat, (Node)NCAL.inProcessParticipationStatus);
        } else if (string.equals(PartStat.NEEDS_ACTION.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.partstat, (Node)NCAL.needsActionParticipationStatus);
        } else if (string.equals(PartStat.TENTATIVE.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.partstat, (Node)NCAL.tentativeParticipationStatus);
        } else {
            this.logger.warn("Unknown PARTSTAT parameter value: " + string);
        }
    }

    public void crawlRangeParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
        String string = parameter.getValue();
        if (string.equals(Range.THISANDFUTURE.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.range, (Node)NCAL.thisAndFutureRange);
        } else if (string.equals(Range.THISANDPRIOR.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.range, (Node)NCAL.thisAndPriorRange);
        } else {
            this.logger.warn("Unknown RANGE parameter value: " + string);
        }
    }

    public void crawlRelatedParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
        String string = parameter.getValue();
        if (string.equals(Related.START.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.related, (Node)NCAL.startTriggerRelation);
        } else if (string.equals(Related.END.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.related, (Node)NCAL.endTriggerRelation);
        } else {
            this.logger.warn("Unknown RELATED parameter value: " + string);
        }
    }

    public void crawlRelTypeParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
    }

    public void crawlRoleParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
        String string = parameter.getValue();
        if (string.equals(Role.CHAIR.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.role, (Node)NCAL.chairRole);
        } else if (string.equals(Role.NON_PARTICIPANT.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.role, (Node)NCAL.nonParticipantRole);
        } else if (string.equals(Role.OPT_PARTICIPANT.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.role, (Node)NCAL.optParticipantRole);
        } else if (string.equals(Role.REQ_PARTICIPANT.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.role, (Node)NCAL.reqParticipantRole);
        } else {
            this.logger.warn("Unknown ROLE parameter value: " + string);
        }
    }

    public void crawlRsvpParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
        String string = parameter.getValue();
        if (string.equals(Rsvp.TRUE.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.rsvp, true);
        } else if (string.equals(Rsvp.FALSE.getValue())) {
            this.addStatement(rDFContainer, resource, NCAL.rsvp, false);
        } else {
            this.logger.warn("Unknown RSVP parameter value: " + string);
        }
    }

    public void crawlSentByParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.sentBy, parameter.getValue());
    }

    public void crawlTzidParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
    }

    public void crawlValueParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
    }

    public void crawlXParameter(Parameter parameter, Resource resource, RDFContainer rDFContainer) {
    }

    private void crawlRecur(String string, Resource resource, RDFContainer rDFContainer) {
        String[] stringArray = string.split("[=;]");
        for (int i = 0; i < stringArray.length; i += 2) {
            try {
                this.crawlRecurrenceParam(stringArray[i], stringArray[i + 1], resource, rDFContainer);
                continue;
            }
            catch (ModelException modelException) {
                this.logger.warn("ModelException while processing recurrence param, skipping param", (Throwable)modelException);
            }
        }
        this.addStatement(rDFContainer, resource, RDF.type, (Node)NCAL.RecurrenceRule);
    }

    private void crawlRecurrenceParam(String string, String string2, Resource resource, RDFContainer rDFContainer) throws ModelException {
        if (string.equals("FREQ")) {
            this.crawlFreqRecurrenceParam(string, string2, resource, rDFContainer);
        } else if (string.equals("UNTIL")) {
            this.crawlUntilRecurrenceParam(string, string2, resource, rDFContainer);
        } else if (string.equals("COUNT")) {
            this.crawlCountRecurrenceParam(string, string2, resource, rDFContainer);
        } else if (string.equals("INTERVAL")) {
            this.crawlIntervalRecurrenceParam(string, string2, resource, rDFContainer);
        } else if (string.equals("BYSECOND")) {
            this.crawlBySecondRecurrenceParam(string, string2, resource, rDFContainer);
        } else if (string.equals("BYMINUTE")) {
            this.crawlByMinuteRecurrenceParam(string, string2, resource, rDFContainer);
        } else if (string.equals("BYHOUR")) {
            this.crawlByHourRecurrenceParam(string, string2, resource, rDFContainer);
        } else if (string.equals("BYDAY")) {
            this.crawlByDayRecurrenceParam(string, string2, resource, rDFContainer);
        } else if (string.equals("BYMONTHDAY")) {
            this.crawlByMonthdayRecurrenceParam(string, string2, resource, rDFContainer);
        } else if (string.equals("BYYEARDAY")) {
            this.crawlByYeardayRecurrenceParam(string, string2, resource, rDFContainer);
        } else if (string.equals("BYWEEKNO")) {
            this.crawlByWeeknoRecurrenceParam(string, string2, resource, rDFContainer);
        } else if (string.equals("BYMONTH")) {
            this.crawlByMonthRecurrenceParam(string, string2, resource, rDFContainer);
        } else if (string.equals("BYSETPOS")) {
            this.crawlBySetposRecurrenceParam(string, string2, resource, rDFContainer);
        } else if (string.equals("WKST")) {
            this.crawlWkstRecurrenceParam(string, string2, resource, rDFContainer);
        } else {
            this.logger.warn("Unknown recurrence param name " + string);
        }
    }

    private void crawlFreqRecurrenceParam(String string, String string2, Resource resource, RDFContainer rDFContainer) {
        if (string2.equals("YEARLY")) {
            this.addStatement(rDFContainer, resource, NCAL.freq, (Node)NCAL.yearly);
        } else if (string2.equals("MONTHLY")) {
            this.addStatement(rDFContainer, resource, NCAL.freq, (Node)NCAL.monthly);
        } else if (string2.equals("WEEKLY")) {
            this.addStatement(rDFContainer, resource, NCAL.freq, (Node)NCAL.weekly);
        } else if (string2.equals("DAILY")) {
            this.addStatement(rDFContainer, resource, NCAL.freq, (Node)NCAL.daily);
        } else if (string2.equals("HOURLY")) {
            this.addStatement(rDFContainer, resource, NCAL.freq, (Node)NCAL.hourly);
        } else if (string2.equals("MINUTELY")) {
            this.addStatement(rDFContainer, resource, NCAL.freq, (Node)NCAL.minutely);
        } else if (string2.equals("SECONDLY")) {
            this.addStatement(rDFContainer, resource, NCAL.freq, (Node)NCAL.secondly);
        } else {
            this.logger.warn("Unknown FREQ recurrence rule parameter value: " + string2);
        }
    }

    private void crawlUntilRecurrenceParam(String string, String string2, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.until, string2);
    }

    private void crawlIntervalRecurrenceParam(String string, String string2, Resource resource, RDFContainer rDFContainer) throws ModelException {
        Literal literal = rDFContainer.getValueFactory().createLiteral(string2, XSD._integer);
        this.addStatement(rDFContainer, resource, NCAL.interval, (Node)literal);
    }

    private void crawlCountRecurrenceParam(String string, String string2, Resource resource, RDFContainer rDFContainer) throws ModelException {
        Literal literal = rDFContainer.getValueFactory().createLiteral(string2, XSD._integer);
        this.addStatement(rDFContainer, resource, NCAL.count, (Node)literal);
    }

    private void crawlBySecondRecurrenceParam(String string, String string2, Resource resource, RDFContainer rDFContainer) {
        try {
            int n = Integer.parseInt(string2);
            this.addStatement(rDFContainer, resource, NCAL.bysecond, n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void crawlByMinuteRecurrenceParam(String string, String string2, Resource resource, RDFContainer rDFContainer) {
        try {
            int n = Integer.parseInt(string2);
            this.addStatement(rDFContainer, resource, NCAL.byminute, n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void crawlByHourRecurrenceParam(String string, String string2, Resource resource, RDFContainer rDFContainer) {
        try {
            int n = Integer.parseInt(string2);
            this.addStatement(rDFContainer, resource, NCAL.byhour, n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void crawlByDayRecurrenceParam(String string, String string2, Resource resource, RDFContainer rDFContainer) throws ModelException {
        String[] stringArray;
        for (String string3 : stringArray = string2.split(",")) {
            Resource resource2 = this.generateAnonymousNode(rDFContainer);
            String string4 = string3.substring(string3.length() - 2, string3.length());
            URI uRI = null;
            if (string4.equals("MO")) {
                uRI = NCAL.monday;
            } else if (string4.equals("TU")) {
                uRI = NCAL.tuesday;
            } else if (string4.equals("WE")) {
                uRI = NCAL.wednesday;
            } else if (string4.equals("TH")) {
                uRI = NCAL.thursday;
            } else if (string4.equals("FR")) {
                uRI = NCAL.friday;
            } else if (string4.equals("SA")) {
                uRI = NCAL.saturday;
            } else if (string4.equals("SU")) {
                uRI = NCAL.sunday;
            } else {
                this.logger.warn("Unknown day of the week: " + string3);
                return;
            }
            int n = 0;
            boolean bl = false;
            if (string3.length() > 2) {
                String string5 = string3.substring(0, string3.length() - 2);
                try {
                    n = Integer.parseInt(string5);
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
            }
            this.addStatement(rDFContainer, resource2, NCAL.bydayWeekday, (Node)uRI);
            if (bl) {
                this.addStatement(rDFContainer, resource2, NCAL.bydayModifier, (Node)rDFContainer.getModel().createDatatypeLiteral(String.valueOf(n), XSD._integer));
            }
            this.addStatement(rDFContainer, resource2, RDF.type, (Node)NCAL.BydayRulePart);
            this.addStatement(rDFContainer, resource, NCAL.byday, (Node)resource2);
        }
    }

    private void crawlByMonthdayRecurrenceParam(String string, String string2, Resource resource, RDFContainer rDFContainer) {
        try {
            int n = Integer.parseInt(string2);
            this.addStatement(rDFContainer, resource, NCAL.bymonthday, n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void crawlByYeardayRecurrenceParam(String string, String string2, Resource resource, RDFContainer rDFContainer) {
        try {
            int n = Integer.parseInt(string2);
            this.addStatement(rDFContainer, resource, NCAL.byyearday, n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void crawlByWeeknoRecurrenceParam(String string, String string2, Resource resource, RDFContainer rDFContainer) {
        try {
            int n = Integer.parseInt(string2);
            this.addStatement(rDFContainer, resource, NCAL.byweekno, n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void crawlByMonthRecurrenceParam(String string, String string2, Resource resource, RDFContainer rDFContainer) {
        try {
            int n = Integer.parseInt(string2);
            this.addStatement(rDFContainer, resource, NCAL.bymonth, n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void crawlBySetposRecurrenceParam(String string, String string2, Resource resource, RDFContainer rDFContainer) {
        try {
            int n = Integer.parseInt(string2);
            this.addStatement(rDFContainer, resource, NCAL.bysetpos, n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void crawlWkstRecurrenceParam(String string, String string2, Resource resource, RDFContainer rDFContainer) {
        this.addStatement(rDFContainer, resource, NCAL.wkst, string2);
    }

    private RDFContainer prepareDataObjectRDFContainer(Component component) {
        URI uRI = this.generateComponentUri(component);
        return this.prepareDataObjectRDFContainer(uRI);
    }

    private RDFContainer prepareDataObjectRDFContainer(URI uRI) {
        this.reportAccessingObject(uRI.toString());
        RDFContainerFactory rDFContainerFactory = this.getRDFContainerFactory(uRI.toString());
        RDFContainer rDFContainer = rDFContainerFactory.getRDFContainer(uRI);
        rDFContainer.add(RDF.type, (Node)NCAL.CalendarDataObject);
        return rDFContainer;
    }

    private void addStatement(RDFContainer rDFContainer, Resource resource, URI uRI, String string) {
        try {
            this.addStatement(rDFContainer, resource, uRI, (Node)rDFContainer.getValueFactory().createLiteral(string));
        }
        catch (ModelException modelException) {
            this.logger.warn("ModelException while creating literal, skipping statement", (Throwable)modelException);
        }
    }

    private void addStatement(RDFContainer rDFContainer, Resource resource, URI uRI, int n) {
        try {
            this.addStatement(rDFContainer, resource, uRI, (Node)rDFContainer.getValueFactory().createLiteral(n));
        }
        catch (ModelException modelException) {
            this.logger.warn("ModelException while creating literal, skipping statement", (Throwable)modelException);
        }
    }

    private void addStatement(RDFContainer rDFContainer, Resource resource, URI uRI, boolean bl) {
        try {
            this.addStatement(rDFContainer, resource, uRI, (Node)rDFContainer.getValueFactory().createLiteral(bl));
        }
        catch (ModelException modelException) {
            this.logger.warn("ModelException while creating literal, skipping statement", (Throwable)modelException);
        }
    }

    private void addStatement(RDFContainer rDFContainer, Resource resource, URI uRI, Node node) {
        Statement statement = rDFContainer.getValueFactory().createStatement(resource, uRI, node);
        rDFContainer.add(statement);
    }

    private void addMultipleStatements(RDFContainer rDFContainer, Resource resource, URI uRI, List<Node> list) {
        for (Node node : list) {
            this.addStatement(rDFContainer, resource, uRI, node);
        }
    }

    private void processAttendeeOrOrganizer(Property property, Resource resource, RDFContainer rDFContainer) {
        Resource resource2 = this.generateAnonymousNode(rDFContainer);
        this.addStatement(rDFContainer, resource, NCAL.involvedContact, (Node)resource2);
        this.addStatement(rDFContainer, resource2, RDF.type, (Node)NCO.PersonContact);
        Resource resource3 = this.generateAnonymousNode(rDFContainer);
        this.addStatement(rDFContainer, resource2, NCO.hasEmailAddress, (Node)resource3);
        this.addStatement(rDFContainer, resource3, RDF.type, (Node)NCO.EmailAddress);
        this.addStatement(rDFContainer, resource3, NCO.emailAddress, property.getValue().substring(7));
        Parameter parameter = property.getParameter("CN");
        if (parameter != null) {
            String string = parameter.getValue();
            this.addStatement(rDFContainer, resource2, NCO.fullname, string);
        }
    }

    private void passComponentToHandler(RDFContainer rDFContainer, Component component) {
        DataObjectBase dataObjectBase = new DataObjectBase(rDFContainer.getDescribedUri(), this.getDataSource(), rDFContainer);
        String string = rDFContainer.getDescribedUri().toString();
        if (this.accessData == null) {
            this.reportNewDataObject(dataObjectBase);
        } else if (!this.accessData.isKnownId(string)) {
            if (component == null) {
                this.updateAccessData(rDFContainer, this.hashOfProperties(rDFContainer));
            } else {
                this.updateAccessData(rDFContainer, component);
            }
            this.reportNewDataObject(dataObjectBase);
        } else if (this.isChanged(rDFContainer, component)) {
            if (component == null) {
                this.updateAccessData(rDFContainer, this.hashOfProperties(rDFContainer));
            } else {
                this.updateAccessData(rDFContainer, component);
            }
            this.reportModifiedDataObject(dataObjectBase);
        } else {
            this.reportUnmodifiedDataObject(string);
            dataObjectBase.dispose();
        }
    }

    private void passAttachmentToHandler(RDFContainer rDFContainer, byte[] byArray) {
        String string = StringUtil.sha1Hash(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        FileDataObjectBase fileDataObjectBase = new FileDataObjectBase(rDFContainer.getDescribedUri(), this.source, rDFContainer, byteArrayInputStream);
        String string2 = rDFContainer.getDescribedUri().toString();
        if (this.accessData == null) {
            this.reportNewDataObject(fileDataObjectBase);
        } else if (!this.accessData.isKnownId(string2)) {
            this.updateAccessData(rDFContainer, string);
            this.reportNewDataObject(fileDataObjectBase);
        } else if (this.isAttachmentChanged(rDFContainer, string)) {
            this.updateAccessData(rDFContainer, string);
            this.reportModifiedDataObject(fileDataObjectBase);
        } else {
            this.reportUnmodifiedDataObject(string2);
            fileDataObjectBase.dispose();
        }
    }

    private void updateAccessData(RDFContainer rDFContainer, Component component) {
        this.updateAccessData(rDFContainer, StringUtil.sha1Hash(component.toString()));
    }

    private void updateAccessData(RDFContainer rDFContainer, String string) {
        String string2 = rDFContainer.getDescribedUri().toString();
        this.accessData.put(string2, "visited", "true");
        this.accessData.put(string2, "hash", string);
    }

    private String hashOfProperties(RDFContainer rDFContainer) {
        StringBuffer stringBuffer = new StringBuffer("");
        this.appendPropertyValue(stringBuffer, rDFContainer, NCAL.method);
        this.appendPropertyValue(stringBuffer, rDFContainer, NCAL.prodid);
        this.appendPropertyValue(stringBuffer, rDFContainer, NCAL.version);
        this.appendPropertyValue(stringBuffer, rDFContainer, NCAL.calscale);
        return StringUtil.sha1Hash(stringBuffer.toString());
    }

    private void appendPropertyValue(StringBuffer stringBuffer, RDFContainer rDFContainer, URI uRI) {
        Collection collection = rDFContainer.getAll(uRI);
        for (Node node : collection) {
            this.appendSinglePropertyValue(stringBuffer, uRI, node);
        }
    }

    private void appendSinglePropertyValue(StringBuffer stringBuffer, URI uRI, Node node) {
        if (node instanceof Literal) {
            URI uRI2 = null;
            String string = ((Literal)node).getValue();
            if (node instanceof DatatypeLiteral) {
                uRI2 = ((DatatypeLiteral)node).getDatatype();
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append("#");
            }
            stringBuffer.append(uRI.toString());
            stringBuffer.append("#");
            stringBuffer.append(string);
            if (uRI2 != null) {
                stringBuffer.append("#");
                stringBuffer.append(uRI2.toString());
            }
        } else if (node instanceof URI) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("#");
            }
            stringBuffer.append(uRI.toString());
            stringBuffer.append("#");
            stringBuffer.append(node.toString());
        }
    }

    private boolean isChanged(RDFContainer rDFContainer, Component component) {
        String string = rDFContainer.getDescribedUri().toString();
        String string2 = component == null ? this.hashOfProperties(rDFContainer) : StringUtil.sha1Hash(component.toString());
        String string3 = this.accessData.get(string, "hash");
        if (string3 == null) {
            return true;
        }
        return !string3.equals(string2);
    }

    private boolean isAttachmentChanged(RDFContainer rDFContainer, String string) {
        String string2 = rDFContainer.getDescribedUri().toString();
        String string3 = this.accessData.get(string2, "hash");
        if (string3 == null) {
            return true;
        }
        return !string3.equals(string);
    }

    private URI generateCalendarUri() {
        return new URIImpl(this.baseuri + "Calendar");
    }

    private URI generateComponentUri(Component component) {
        if (component instanceof VTimeZone) {
            return this.generateTimeZoneURI((VTimeZone)component);
        }
        Property property = component.getProperty("UID");
        if (property != null) {
            return new URIImpl(this.baseuri + property.getValue());
        }
        return this.generateSumOfAllPropertiesURI(component);
    }

    private URI generateTimeZoneURI(VTimeZone vTimeZone) {
        Property property = vTimeZone.getProperty("TZID");
        if (property != null) {
            return this.createTimeZoneURI(property.getValue());
        }
        return this.generateSumOfAllPropertiesURI((Component)vTimeZone);
    }

    private URI generateSumOfAllPropertiesURI(Component component) {
        Object object2;
        StringBuffer stringBuffer = new StringBuffer("");
        PropertyList propertyList = component.getProperties();
        for (Object object2 : propertyList) {
            stringBuffer.append(object2.getValue());
        }
        object2 = this.baseuri + StringUtil.sha1Hash(stringBuffer.toString());
        return new URIImpl((String)object2);
    }

    private URI generateAnonymousComponentUri(Component component) {
        String string = this.baseuri + component.getName() + "-" + UUID.randomUUID().toString();
        return new URIImpl(string);
    }

    private URI createTimeZoneURI(String string) {
        return new URIImpl(this.baseuri + string);
    }

    private Resource generateAnonymousNode(RDFContainer rDFContainer) {
        return UriUtil.generateRandomResource(rDFContainer.getModel());
    }

    private URI generateAttachmentUri(URI uRI) {
        return new URIImpl(uRI.toString() + "/attachment");
    }

    private Node getRdfPropertyValue(RDFContainer rDFContainer, String string, Parameter parameter, Parameter parameter2, String string2) {
        if (string2.equals("NCAL-DATE-TIME")) {
            return this.getNcalDateTime(rDFContainer, string, parameter, parameter2);
        }
        if (parameter2 == null && string2.equals("URI") || parameter2 != null && parameter2.getValue().equals("URI")) {
            URI uRI = this.tryToCreateAnUri(rDFContainer, string);
            this.addStatement(rDFContainer, (Resource)uRI, RDF.type, (Node)RDFS.Resource);
            return uRI;
        }
        if (parameter2 == null && string2.equals("PERIOD") || parameter2 != null && parameter2.getValue().equals("PERIOD")) {
            return this.createPeriod(rDFContainer, string);
        }
        PlainLiteral plainLiteral = null;
        URI uRI = null;
        String string3 = null;
        if (parameter2 != null) {
            String string4 = parameter2.getValue();
            uRI = this.convertValueParameterToXSDDatatype(string4);
            string3 = this.convertIcalValueToXSDValue(string, string4);
            plainLiteral = rDFContainer.getModel().createDatatypeLiteral(string3, uRI);
        } else if (string2 != null) {
            uRI = this.convertValueParameterToXSDDatatype(string2);
            string3 = this.convertIcalValueToXSDValue(string, string2);
            plainLiteral = rDFContainer.getModel().createDatatypeLiteral(string3, uRI);
        } else {
            plainLiteral = rDFContainer.getModel().createPlainLiteral(string);
        }
        return plainLiteral;
    }

    private Node createPeriod(RDFContainer rDFContainer, String string) {
        String[] stringArray = string.split("/");
        if (stringArray.length != 2) {
            return null;
        }
        Resource resource = this.generateAnonymousNode(rDFContainer);
        this.addStatement(rDFContainer, resource, RDF.type, (Node)NCAL.NcalPeriod);
        this.addStatement(rDFContainer, resource, NCAL.periodBegin, (Node)rDFContainer.getModel().createDatatypeLiteral(this.convertIcalDateTimeToXSDDateTime(stringArray[0]), XSD._dateTime));
        if (stringArray[1].contains("P")) {
            this.addStatement(rDFContainer, resource, NCAL.periodDuration, (Node)rDFContainer.getModel().createDatatypeLiteral(this.convertIcalDurationToXSDDayTimeDuration(stringArray[1]), XSD_DAY_TIME_DURATION));
        } else {
            this.addStatement(rDFContainer, resource, NCAL.periodEnd, (Node)rDFContainer.getModel().createDatatypeLiteral(this.convertIcalDateTimeToXSDDateTime(stringArray[1]), XSD._dateTime));
        }
        return resource;
    }

    private Node getNcalDateTime(RDFContainer rDFContainer, String string, Parameter parameter, Parameter parameter2) {
        Resource resource = this.generateAnonymousNode(rDFContainer);
        if (parameter2 == null || parameter2.getValue().equals("DATE-TIME")) {
            String string2 = this.convertIcalDateTimeToXSDDateTime(string);
            this.addStatement(rDFContainer, resource, RDF.type, (Node)NCAL.NcalDateTime);
            this.addStatement(rDFContainer, resource, NCAL.dateTime, (Node)rDFContainer.getModel().createDatatypeLiteral(string2, XSD._dateTime));
            if (parameter != null) {
                URI uRI = this.createTimeZoneURI(parameter.getValue());
                this.addStatement(rDFContainer, resource, NCAL.ncalTimezone, (Node)uRI);
                this.addStatement(rDFContainer, (Resource)uRI, RDF.type, (Node)NCAL.Timezone);
            }
        } else if (parameter2.getValue().equals("DATE")) {
            String string3 = this.convertIcalDateToXSDDate(string);
            this.addStatement(rDFContainer, resource, RDF.type, (Node)NCAL.NcalDateTime);
            this.addStatement(rDFContainer, resource, NCAL.date, (Node)rDFContainer.getModel().createDatatypeLiteral(string3, XSD._date));
        } else if (parameter2.getValue().equals("PERIOD")) {
            return this.createPeriod(rDFContainer, string);
        }
        return resource;
    }

    private List<Node> getMultipleRdfPropertyValues(RDFContainer rDFContainer, Property property, String string) {
        String string2 = property.getValue();
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split(",");
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (int i = 0; i < stringArray.length; ++i) {
            Node node = this.getRdfPropertyValue(rDFContainer, stringArray[i], property.getParameter("TZID"), property.getParameter("VALUE"), string);
            linkedList.add(node);
        }
        return linkedList;
    }

    private Node getRdfPropertyValue(RDFContainer rDFContainer, Property property, String string) {
        return this.getRdfPropertyValue(rDFContainer, property.getValue(), property.getParameter("TZID"), property.getParameter("VALUE"), string);
    }

    private URI tryToCreateAnUri(RDFContainer rDFContainer, String string) {
        URI uRI = null;
        if (string.indexOf(58) == -1) {
            uRI = rDFContainer.getModel().createURI("uri:" + string);
        } else {
            try {
                uRI = rDFContainer.getModel().createURI(string);
            }
            catch (Exception exception) {
                uRI = rDFContainer.getModel().createURI(this.baseuri + string);
            }
        }
        return uRI;
    }

    private String convertIcalValueToXSDValue(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        if (string2.equals("DATE-TIME")) {
            return this.convertIcalDateTimeToXSDDateTime(string);
        }
        if (string2.equals("DATE")) {
            return this.convertIcalDateToXSDDate(string);
        }
        return string;
    }

    public String convertIcalDurationToXSDDayTimeDuration(String string) {
        if (!this.icalDurationPattern.matcher(string).matches()) {
            throw new RuntimeException("wrong duration format");
        }
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (string.charAt(0) == '-') {
            bl = false;
            string = string.substring(2);
        } else {
            string = string.charAt(0) == '+' ? string.substring(2) : string.substring(1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+-PWDTHMS", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("T")) continue;
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("W")) {
                n += Integer.parseInt(string2);
                continue;
            }
            if (string3.equals("D")) {
                n2 += Integer.parseInt(string2);
                continue;
            }
            if (string3.equals("H")) {
                n3 += Integer.parseInt(string2);
                continue;
            }
            if (string3.equals("M")) {
                n4 += Integer.parseInt(string2);
                continue;
            }
            if (!string3.equals("S")) continue;
            n5 += Integer.parseInt(string2);
        }
        long l = n5 + 60 * n4 + 3600 * n3 + 86400 * n2 + 604800 * n;
        String string4 = "";
        if (l == 0L) {
            string4 = "P0S";
        } else {
            string4 = (bl ? "" : "-") + "P";
            if (l / 86400L != 0L) {
                string4 = string4 + "" + l / 86400L + "D";
            }
            if ((l %= 86400L) != 0L) {
                string4 = string4 + "T";
            }
            if (l / 3600L != 0L) {
                string4 = string4 + "" + l / 3600L + "H";
            }
            if ((l %= 3600L) / 60L != 0L) {
                string4 = string4 + "" + l / 60L + "M";
            }
            if ((l %= 60L) != 0L) {
                string4 = string4 + "" + l + "S";
            }
        }
        return string4;
    }

    private String convertIcalDateToXSDDate(String string) {
        if (string.length() != 8) {
            throw new IllegalArgumentException("Invalid ical date: " + string);
        }
        String string2 = string.substring(0, 4);
        String string3 = string.substring(4, 6);
        String string4 = string.substring(6, 8);
        return string2 + "-" + string3 + "-" + string4;
    }

    private String convertIcalDateTimeToXSDDateTime(String string) {
        if (string.length() < 15 || string.length() > 16) {
            throw new IllegalArgumentException("Invalid ical datetime: " + string);
        }
        String string2 = this.convertIcalDateToXSDDate(string.substring(0, 8));
        String string3 = string.substring(9, 11);
        String string4 = string.substring(11, 13);
        String string5 = string.substring(13, 15);
        String string6 = string.length() == 16 ? "Z" : "";
        return string2 + "T" + string3 + ":" + string4 + ":" + string5 + string6;
    }

    private URI convertValueParameterToXSDDatatype(String string) {
        URI uRI = null;
        if (string.equalsIgnoreCase("TEXT")) {
            uRI = null;
        } else if (string.equalsIgnoreCase("BINARY")) {
            uRI = null;
        } else if (string.equalsIgnoreCase("BOOLEAN")) {
            uRI = null;
        } else if (string.equalsIgnoreCase("CAL-ADDRESS")) {
            uRI = null;
        } else if (string.equalsIgnoreCase("DATE")) {
            uRI = XSD._date;
        } else if (string.equalsIgnoreCase("DATE-TIME")) {
            uRI = XSD._dateTime;
        } else if (string.equalsIgnoreCase("DURATION")) {
            uRI = XSD_DAY_TIME_DURATION;
        } else if (string.equalsIgnoreCase("FLOAT")) {
            uRI = XSD._float;
        } else if (string.equals("INTEGER")) {
            uRI = XSD._integer;
        } else if (string.equalsIgnoreCase("PERIOD")) {
            uRI = null;
        } else if (string.equalsIgnoreCase("RECUR")) {
            uRI = null;
        } else if (string.equalsIgnoreCase("TIME")) {
            uRI = XSD._time;
        } else if (string.equalsIgnoreCase("URI")) {
            uRI = XSD._anyURI;
        } else if (string.equalsIgnoreCase("UTC-OFFSET")) {
            uRI = null;
        } else {
            this.logger.warn("Unknown value parameter: " + string);
        }
        return uRI;
    }
}

