/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.hypertext.linkextractor.html;

import java.io.IOException;
import java.io.InputStream;
import org.semanticdesktop.aperture.hypertext.linkextractor.html.TokenHandler;

public class Tokenizer {
    private static final int LESS_THEN = 60;
    private static final int GREATER_THEN = 62;
    private static final int EQUALS = 61;
    private static final int EXCLAMATION = 33;
    private static final int MINUS = 45;
    private static final int DOUBLE_QUOTE = 34;
    private static final int QUOTE = 39;
    private static final int SLASH = 47;
    private static final char[] DOCTYPE = new char[]{'D', 'O', 'C', 'T', 'Y', 'P', 'E'};
    private TokenHandler tokenHandler;

    public Tokenizer(TokenHandler tokenHandler) {
        this.tokenHandler = tokenHandler;
    }

    public void read(InputStream inputStream) throws IOException {
        this.tokenHandler.startDocument();
        int n = inputStream.read();
        while (n != -1) {
            if (n == 60) {
                n = this.readTag(inputStream);
                continue;
            }
            n = this.readText(inputStream, n);
        }
        this.tokenHandler.endDocument();
    }

    private int readTag(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        n = n == 47 ? this.readEndTag(inputStream) : (n == 33 ? this.readDocTypeOrComment(inputStream) : this.readStartTag(inputStream, n));
        return n;
    }

    private int readStartTag(InputStream inputStream, int n) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n;
        while (n2 != 62 && n2 != -1 && !Character.isWhitespace((char)n2)) {
            stringBuilder.append((char)n2);
            n2 = inputStream.read();
        }
        if (n2 == -1) {
            return -1;
        }
        this.tokenHandler.startOfStartTag(stringBuilder.toString());
        n2 = this.readAttributes(inputStream, n2);
        this.tokenHandler.endOfStartTag();
        return n2;
    }

    private int readEndTag(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = inputStream.read();
        while (n != 62 && n != -1) {
            stringBuffer.append((char)n);
            n = inputStream.read();
        }
        if (n != -1) {
            this.tokenHandler.endTag(stringBuffer.toString());
            n = inputStream.read();
        }
        return n;
    }

    private int readDocTypeOrComment(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n2 = -1;
        for (n = 0; n < DOCTYPE.length; ++n) {
            n2 = inputStream.read();
            if (n2 != -1) {
                if (Character.toUpperCase((char)n2) == DOCTYPE[n]) continue;
                bl = false;
                break;
            }
            bl = false;
            break;
        }
        if (bl) {
            n2 = inputStream.read();
            StringBuilder stringBuilder = new StringBuilder();
            n2 = this.readWord(stringBuilder, inputStream, n2, false);
            StringBuilder stringBuilder2 = new StringBuilder();
            n2 = this.readWord(stringBuilder2, inputStream, n2, false);
            StringBuilder stringBuilder3 = new StringBuilder();
            n2 = this.readWord(stringBuilder3, inputStream, n2, false);
            StringBuilder stringBuilder4 = new StringBuilder();
            n2 = this.readWord(stringBuilder4, inputStream, n2, false);
            this.tokenHandler.docType(stringBuilder.toString(), stringBuilder2.toString(), stringBuilder3.toString(), stringBuilder4.toString());
        } else {
            n = n2;
            n2 = n != 62 && n != -1 ? inputStream.read() : -1;
            if (n == 45 && n2 == 45) {
                boolean bl2 = false;
                n2 = inputStream.read();
                while (n2 != -1) {
                    if (n2 == 45) {
                        if (bl2) {
                            n2 = inputStream.read();
                            break;
                        }
                        bl2 = true;
                        n2 = inputStream.read();
                        continue;
                    }
                    if (bl2) {
                        stringBuffer.append('-');
                        bl2 = false;
                    }
                    stringBuffer.append((char)n2);
                    n2 = inputStream.read();
                }
                this.tokenHandler.comment(stringBuffer.toString());
            } else {
                stringBuffer.append('!');
                if (n != 62 && n != -1) {
                    stringBuffer.append((char)n);
                }
                while (n2 != 62 && n2 != -1) {
                    stringBuffer.append((char)n2);
                    n2 = inputStream.read();
                }
                this.tokenHandler.startOfStartTag(stringBuffer.toString());
                this.tokenHandler.endOfStartTag();
            }
        }
        while (n2 != 62 && n2 != -1) {
            n2 = inputStream.read();
        }
        if (n2 != -1) {
            n2 = inputStream.read();
        }
        return n2;
    }

    private int readAttributes(InputStream inputStream, int n) throws IOException {
        int n2 = n;
        while (n2 != 62 && n2 != -1) {
            StringBuilder stringBuilder = new StringBuilder();
            n2 = this.readWord(stringBuilder, inputStream, n2, true);
            if (stringBuilder.length() != 0) {
                StringBuilder stringBuilder2;
                if ((n2 = this.skipWhitespace(inputStream, n2)) == 61) {
                    stringBuilder2 = new StringBuilder();
                    n2 = inputStream.read();
                    n2 = this.readWord(stringBuilder2, inputStream, n2, false);
                    this.tokenHandler.attribute(stringBuilder.toString(), stringBuilder2.toString());
                } else {
                    this.tokenHandler.attribute(stringBuilder.toString());
                }
                stringBuilder2 = new StringBuilder();
                continue;
            }
            if (n2 != 61) continue;
            this.tokenHandler.error("Illegal attribute name '=', skipping character");
            n2 = inputStream.read();
        }
        if (n2 != -1) {
            n2 = inputStream.read();
        }
        return n2;
    }

    private int readText(InputStream inputStream, int n) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n;
        while (n2 != 60 && n2 != -1) {
            stringBuilder.append((char)n2);
            n2 = inputStream.read();
        }
        this.tokenHandler.text(stringBuilder.toString());
        return n2;
    }

    private int skipWhitespace(InputStream inputStream, int n) throws IOException {
        int n2 = n;
        while (n2 != -1 && Character.isWhitespace((char)n2)) {
            n2 = inputStream.read();
        }
        return n2;
    }

    private int readWord(StringBuilder stringBuilder, InputStream inputStream, int n, boolean bl) throws IOException {
        int n2 = n;
        if ((n2 = this.skipWhitespace(inputStream, n2)) == 34 || n2 == 39) {
            int n3 = n2;
            n2 = inputStream.read();
            while (n2 != n3 && n2 != -1) {
                stringBuilder.append((char)n2);
                n2 = inputStream.read();
            }
            if (n2 == n3) {
                n2 = inputStream.read();
            }
        } else {
            while (!(n2 == 61 && bl || n2 == 62 || n2 == -1 || Character.isWhitespace((char)n2))) {
                stringBuilder.append((char)n2);
                n2 = inputStream.read();
            }
        }
        return n2;
    }
}

