/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.semanticdesktop.aperture.util.StringUtil;

public class UrlUtil {
    public static URL normalizeURL(URL uRL) {
        String string = uRL.getProtocol();
        String string2 = uRL.getHost();
        int n = uRL.getPort();
        String string3 = uRL.getPath();
        String string4 = uRL.getQuery();
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        if (n == uRL.getDefaultPort()) {
            n = -1;
        }
        String string5 = UrlUtil.normalizePath(string3);
        if (string4 != null) {
            string4 = UrlUtil.normalizeQuery(string4);
            string5 = string5 + "?" + string4;
        }
        try {
            return new URL(string, string2, n, string5);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public static String normalizePath(String string) {
        String string2 = string;
        string2 = StringUtil.replace("//", "/", string2);
        string2 = StringUtil.replace("/./", "/", string2);
        string2 = string2.replaceAll("/[^/]+/\\.\\./", "/");
        return string2;
    }

    public static String normalizeQuery(String string) {
        TreeSet<String> treeSet = new TreeSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            treeSet.add(stringTokenizer.nextToken());
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append('&');
        }
        return stringBuilder.toString();
    }
}

