/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.jpdl3;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.node.EndState;
import org.jbpm.graph.node.StartState;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.instantiation.Delegation;
import org.jbpm.taskmgmt.def.Swimlane;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.def.TaskMgmtDefinition;
import org.modeshape.sequencer.jpdl3.JPDL3AssignmentMetadata;
import org.modeshape.sequencer.jpdl3.JPDL3EndStateMetadata;
import org.modeshape.sequencer.jpdl3.JPDL3StartStateMetadata;
import org.modeshape.sequencer.jpdl3.JPDL3SwimlaneMetadata;
import org.modeshape.sequencer.jpdl3.JPDL3TaskMetadata;
import org.modeshape.sequencer.jpdl3.JPDL3TaskNodeMetadata;
import org.modeshape.sequencer.jpdl3.JPDL3TransitionMetadata;

public class JPDL3Metadata {
    private String pdName;
    private JPDL3StartStateMetadata jPDL3StartStateMetadata;
    private JPDL3EndStateMetadata jPDL3EndStateMetadata;
    List<JPDL3SwimlaneMetadata> swimlanes = new ArrayList<JPDL3SwimlaneMetadata>();
    private List<JPDL3TaskNodeMetadata> taskNodes = new ArrayList<JPDL3TaskNodeMetadata>();

    private JPDL3Metadata() {
    }

    public static JPDL3Metadata instance(InputStream stream) {
        ProcessDefinition processDefinition = ProcessDefinition.parseXmlInputStream((InputStream)stream);
        ArrayList<JPDL3SwimlaneMetadata> swimlaneContainer = new ArrayList<JPDL3SwimlaneMetadata>();
        ArrayList<JPDL3TaskNodeMetadata> taskNodeContainer = new ArrayList<JPDL3TaskNodeMetadata>();
        if (processDefinition != null) {
            TaskMgmtDefinition taskMgmtDefinition;
            JPDL3Metadata jplMetadata = new JPDL3Metadata();
            if (processDefinition.getName() != null) {
                jplMetadata.setPdName(processDefinition.getName());
            }
            if ((taskMgmtDefinition = processDefinition.getTaskMgmtDefinition()) != null) {
                Map mapOfSwimlanes = taskMgmtDefinition.getSwimlanes();
                Set swimlaneKeys = mapOfSwimlanes.keySet();
                for (String swimlaneKey : swimlaneKeys) {
                    Delegation delegation;
                    Swimlane swimlane = (Swimlane)mapOfSwimlanes.get(swimlaneKey);
                    JPDL3SwimlaneMetadata jPDL3SwimlaneMetadata = new JPDL3SwimlaneMetadata();
                    jPDL3SwimlaneMetadata.setName(swimlane.getName());
                    if (swimlane.getActorIdExpression() != null) {
                        jPDL3SwimlaneMetadata.setActorIdExpression(swimlane.getActorIdExpression());
                    }
                    if (swimlane.getPooledActorsExpression() != null) {
                        jPDL3SwimlaneMetadata.setPooledActorsExpression(swimlane.getPooledActorsExpression());
                    }
                    if ((delegation = swimlane.getAssignmentDelegation()) != null) {
                        JPDL3AssignmentMetadata jPDL3AssignmentMetadata = new JPDL3AssignmentMetadata();
                        jPDL3AssignmentMetadata.setFqClassName(delegation.getClassName());
                        if (delegation.getConfigType() != null) {
                            jPDL3AssignmentMetadata.setConfigType(delegation.getConfigType());
                        }
                        if ("org.jbpm.identity.assignment.ExpressionAssignmentHandler".equals(delegation.getClassName())) {
                            jPDL3AssignmentMetadata.setExpression(delegation.getConfiguration());
                        }
                        jPDL3SwimlaneMetadata.setAssignment(jPDL3AssignmentMetadata);
                    }
                    swimlaneContainer.add(jPDL3SwimlaneMetadata);
                }
            }
            jplMetadata.setSwimlanes(swimlaneContainer);
            List nodes = processDefinition.getNodes();
            for (Node node : nodes) {
                if (node instanceof StartState) {
                    StartState startState = (StartState)node;
                    JPDL3StartStateMetadata jPDL3StartStateMetadata = new JPDL3StartStateMetadata();
                    if (startState.getName() != null) {
                        jPDL3StartStateMetadata.setName(startState.getName());
                    }
                    ArrayList<JPDL3TransitionMetadata> transitions = new ArrayList<JPDL3TransitionMetadata>();
                    for (Transition transition : startState.getLeavingTransitions()) {
                        Node toNode;
                        JPDL3TransitionMetadata jPDL3TransitionMetadata = new JPDL3TransitionMetadata();
                        if (transition.getName() != null) {
                            jPDL3TransitionMetadata.setName(transition.getName());
                        }
                        if ((toNode = transition.getTo()) != null) {
                            jPDL3TransitionMetadata.setTo(toNode.getName());
                        }
                        transitions.add(jPDL3TransitionMetadata);
                    }
                    jPDL3StartStateMetadata.setTransitions(transitions);
                    jplMetadata.setStartStateMetadata(jPDL3StartStateMetadata);
                }
                if (node instanceof EndState) {
                    EndState endState = (EndState)node;
                    JPDL3EndStateMetadata jPDL3EndStateMetadata = new JPDL3EndStateMetadata();
                    if (endState.getName() != null) {
                        jPDL3EndStateMetadata.setName(endState.getName());
                    }
                    jplMetadata.setEndStateMetadata(jPDL3EndStateMetadata);
                }
                if (!(node instanceof TaskNode)) continue;
                TaskNode taskNode = (TaskNode)node;
                JPDL3TaskNodeMetadata jPDL3TaskNodeMetadata = new JPDL3TaskNodeMetadata();
                if (taskNode.getName() != null) {
                    jPDL3TaskNodeMetadata.setName(taskNode.getName());
                }
                Map tasks = taskNode.getTasksMap();
                ArrayList<JPDL3TaskMetadata> taskList = new ArrayList<JPDL3TaskMetadata>();
                if (!tasks.isEmpty()) {
                    Set keys = tasks.keySet();
                    for (String key : keys) {
                        Task task = (Task)tasks.get(key);
                        JPDL3TaskMetadata jPDL3TaskMetadata = new JPDL3TaskMetadata();
                        if (task.getName() != null) {
                            jPDL3TaskMetadata.setName(task.getName());
                        }
                        if (task.getDueDate() != null) {
                            jPDL3TaskMetadata.setDueDate(task.getDueDate());
                        }
                        taskList.add(jPDL3TaskMetadata);
                        if (task.getSwimlane() == null) continue;
                        Swimlane swimlane = task.getSwimlane();
                        jPDL3TaskMetadata.setSwimlane(swimlane.getName());
                    }
                }
                jPDL3TaskNodeMetadata.setTasks(taskList);
                ArrayList<JPDL3TransitionMetadata> transitions = new ArrayList<JPDL3TransitionMetadata>();
                for (Transition transition : taskNode.getLeavingTransitions()) {
                    Node toNode;
                    JPDL3TransitionMetadata jPDL3TransitionMetadata = new JPDL3TransitionMetadata();
                    if (transition.getName() != null) {
                        jPDL3TransitionMetadata.setName(transition.getName());
                    }
                    if ((toNode = transition.getTo()) != null) {
                        jPDL3TransitionMetadata.setTo(toNode.getName());
                    }
                    transitions.add(jPDL3TransitionMetadata);
                }
                jPDL3TaskNodeMetadata.setTransitions(transitions);
                taskNodeContainer.add(jPDL3TaskNodeMetadata);
                jplMetadata.setTaskNodes(taskNodeContainer);
            }
            return jplMetadata;
        }
        return null;
    }

    public String getPdName() {
        return this.pdName;
    }

    public void setPdName(String pdName) {
        this.pdName = pdName;
    }

    public JPDL3StartStateMetadata getStartStateMetadata() {
        return this.jPDL3StartStateMetadata;
    }

    public JPDL3EndStateMetadata getEndStateMetadata() {
        return this.jPDL3EndStateMetadata;
    }

    public void setStartStateMetadata(JPDL3StartStateMetadata jPDL3StartStateMetadata) {
        this.jPDL3StartStateMetadata = jPDL3StartStateMetadata;
    }

    public void setEndStateMetadata(JPDL3EndStateMetadata jPDL3EndStateMetadata) {
        this.jPDL3EndStateMetadata = jPDL3EndStateMetadata;
    }

    public List<JPDL3SwimlaneMetadata> getSwimlanes() {
        return this.swimlanes;
    }

    public void setSwimlanes(List<JPDL3SwimlaneMetadata> swimlanes) {
        this.swimlanes = swimlanes;
    }

    public List<JPDL3TaskNodeMetadata> getTaskNodes() {
        return this.taskNodes;
    }

    public void setTaskNodes(List<JPDL3TaskNodeMetadata> taskNodes) {
        this.taskNodes = taskNodes;
    }
}

