/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.filesystem;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.ontoware.rdf2go.model.node.Node;
import org.semanticdesktop.aperture.accessor.DataAccessor;
import org.semanticdesktop.aperture.accessor.DataAccessorFactory;
import org.semanticdesktop.aperture.accessor.DataObject;
import org.semanticdesktop.aperture.accessor.RDFContainerFactory;
import org.semanticdesktop.aperture.accessor.UrlNotFoundException;
import org.semanticdesktop.aperture.crawler.ExitCode;
import org.semanticdesktop.aperture.crawler.base.CrawlerBase;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.datasource.filesystem.FileSystemDataSource;
import org.semanticdesktop.aperture.util.OSUtils;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemCrawler
extends CrawlerBase {
    private static final boolean DEFAULT_IGNORE_HIDDEN_FILES = true;
    private static final boolean DEFAULT_FOLLOW_SYMBOLIC_LINKS = false;
    private static final boolean DEFAULT_SUPPRESS_PARENT_CHILD_LINKS = false;
    private static final int DEFAULT_MAX_DEPTH = Integer.MAX_VALUE;
    private static final long DEFAULT_MAX_SIZE = Long.MAX_VALUE;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean ignoreHiddenFiles;
    private boolean followSymbolicLinks;
    private boolean suppressParentChildLinks;
    private long maximumSize;
    private DataAccessorFactory accessorFactory;
    private HashMap params;
    private File root;
    private FileSystemDataSource source;

    protected ExitCode crawlObjects() {
        DataSource dataSource = this.getDataSource();
        if (!(dataSource instanceof FileSystemDataSource)) {
            this.logger.error("wrong data source type");
            return ExitCode.FATAL_ERROR;
        }
        this.source = (FileSystemDataSource)dataSource;
        String string = this.source.getRootFolder();
        if (string == null) {
            this.logger.error("missing root folder");
            return ExitCode.FATAL_ERROR;
        }
        this.root = new File(string);
        if (!this.root.exists()) {
            this.logger.warn("root folder does not exist: '" + this.root + "'");
            return ExitCode.FATAL_ERROR;
        }
        try {
            this.root = this.root.getCanonicalFile();
        }
        catch (IOException iOException) {
            this.logger.warn("unable to determine canonical file of root folder " + this.root, (Throwable)iOException);
            return ExitCode.FATAL_ERROR;
        }
        Integer n = this.source.getMaximumDepth();
        int n2 = n == null ? Integer.MAX_VALUE : n;
        Long l = this.source.getMaximumSize();
        this.maximumSize = l == null ? Long.MAX_VALUE : l;
        Boolean bl = this.source.getIncludeHiddenResources();
        this.ignoreHiddenFiles = bl == null ? true : bl;
        bl = this.source.getFollowSymbolicLinks();
        this.followSymbolicLinks = bl == null ? false : bl;
        bl = this.source.getSuppressParentChildLinks();
        this.suppressParentChildLinks = bl == null ? false : bl;
        this.params = new HashMap(2);
        this.getAccessorFactory();
        boolean bl2 = this.crawlFileTree(this.root, n2);
        this.params = null;
        return bl2 ? ExitCode.COMPLETED : ExitCode.STOP_REQUESTED;
    }

    private void getAccessorFactory() {
        if (this.accessorRegistry == null) {
            throw new IllegalStateException("DataAccessorRegistry not set");
        }
        Set set = this.accessorRegistry.get("file");
        if (set == null || set.isEmpty()) {
            throw new IllegalStateException("Could not retrieve a file data accessor");
        }
        this.accessorFactory = (DataAccessorFactory)set.iterator().next();
    }

    private boolean crawlFileTree(File file, int n) {
        try {
            String string = file.getAbsolutePath();
            String string2 = file.getCanonicalPath();
            if (!this.followSymbolicLinks && !string.equals(string2)) {
                return true;
            }
            file = new File(string2);
        }
        catch (IOException iOException) {
            this.logger.warn("unable to resolve file to its canocical form, continuing with original file: " + file, (Throwable)iOException);
        }
        if (file.isFile() && n >= 0) {
            if (this.inDomain(file.toURI().toString()) && file.canRead() && file.length() <= this.maximumSize) {
                this.crawlSingleFile(file);
            } else {
                this.logger.info("File " + file.toURI() + " is not in domain. Skipping.");
            }
            return true;
        }
        if (file.isDirectory() && n >= 0) {
            if (this.inDomain(file.toURI().toString())) {
                this.crawlSingleFile(file);
            } else {
                this.logger.info("Directory " + file.toURI() + " is not in domain. Skipping.");
            }
            if (OSUtils.isMac() && OSUtils.isMacOSXBundle(file)) {
                return true;
            }
            if (n > 0 && this.inDomain(file.toURI().toString())) {
                return this.filterThroughFolderContent(file, n);
            }
            return true;
        }
        return true;
    }

    private boolean filterThroughFolderContent(File file, int n) {
        CrawlerFileFilter crawlerFileFilter = new CrawlerFileFilter(n);
        file.listFiles(crawlerFileFilter);
        return crawlerFileFilter.getResult();
    }

    private boolean iterateOverFolderContent(File file, int n) {
        int n2;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return true;
        }
        for (n2 = 0; !this.stopRequested && n2 < fileArray.length; ++n2) {
            boolean bl;
            File file2 = fileArray[n2];
            if (this.ignoreHiddenFiles && file2.isHidden() || (bl = this.crawlFileTree(file2, n - 1))) continue;
            return false;
        }
        return n2 == fileArray.length;
    }

    private void crawlSingleFile(File file) {
        String string = file.toURI().toString();
        this.reportAccessingObject(string);
        boolean bl = this.accessData == null ? false : this.accessData.isKnownId(string);
        RDFContainerFactory rDFContainerFactory = this.getRDFContainerFactory(string);
        DataAccessor dataAccessor = this.accessorFactory.get();
        this.params.put("file", file);
        if (this.suppressParentChildLinks) {
            this.params.put("suppressParentChildLinks", Boolean.TRUE);
        }
        try {
            DataObject dataObject = dataAccessor.getDataObjectIfModified(string, this.source, this.accessData, this.params, rDFContainerFactory);
            if (dataObject == null) {
                this.reportUnmodifiedDataObject(string);
            } else {
                if (file.equals(this.root)) {
                    dataObject.getMetadata().add(NIE.rootElementOf, (Node)this.source.getID());
                }
                if (bl) {
                    this.reportModifiedDataObject(dataObject);
                } else {
                    this.reportNewDataObject(dataObject);
                }
            }
        }
        catch (UrlNotFoundException urlNotFoundException) {
            this.logger.warn("unable to access " + string, (Throwable)urlNotFoundException);
        }
        catch (IOException iOException) {
            this.logger.warn("I/O error while processing " + string, (Throwable)iOException);
        }
    }

    private class CrawlerFileFilter
    implements FileFilter {
        private int depth;
        private boolean result;

        public CrawlerFileFilter(int n) {
            this.depth = n;
            this.result = true;
        }

        public boolean accept(File file) {
            if (FileSystemCrawler.this.stopRequested || !this.result) {
                this.result = false;
                return false;
            }
            if (FileSystemCrawler.this.ignoreHiddenFiles && file.isHidden()) {
                return false;
            }
            this.result = FileSystemCrawler.this.crawlFileTree(file, this.depth - 1);
            return false;
        }

        public boolean getResult() {
            return this.result;
        }
    }
}

