/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.opendocument;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.DateUtil;
import org.semanticdesktop.aperture.util.IOUtil;
import org.semanticdesktop.aperture.util.ResourceUtil;
import org.semanticdesktop.aperture.util.SimpleSAXAdapter;
import org.semanticdesktop.aperture.util.SimpleSAXParser;
import org.semanticdesktop.aperture.util.UriUtil;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class OpenDocumentExtractor
implements Extractor {
    private static final String END_OF_LINE = System.getProperty("line.separator", "\n");
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SYSTEM_ID = ResourceUtil.getURL("org/semanticdesktop/aperture/extractor/opendocument/office.dtd", OpenDocumentExtractor.class).toString();

    public void extract(URI uRI, InputStream inputStream, Charset charset, String string, RDFContainer rDFContainer) throws ExtractorException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        try {
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                if ("content.xml".equals(string2)) {
                    byArray = IOUtil.readBytes(zipInputStream);
                } else if ("meta.xml".equals(string2)) {
                    byArray2 = IOUtil.readBytes(zipInputStream);
                }
                zipInputStream.closeEntry();
            }
            zipInputStream.close();
        }
        catch (IOException iOException) {
            throw new ExtractorException(iOException);
        }
        rDFContainer.add(RDF.type, (Node)NFO.Document);
        if (byArray != null) {
            this.extractFullText(byArray, rDFContainer);
        }
        if (byArray2 != null) {
            this.extractMetadata(byArray2, rDFContainer);
        }
    }

    private void extractFullText(byte[] byArray, RDFContainer rDFContainer) throws ExtractorException {
        SimpleSAXParser simpleSAXParser = null;
        try {
            simpleSAXParser = new SimpleSAXParser();
        }
        catch (Exception exception) {
            throw new RuntimeException("unable to instantiate SAXParser", exception);
        }
        ContentExtractor contentExtractor = new ContentExtractor();
        simpleSAXParser.setListener(contentExtractor);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            simpleSAXParser.parse(byteArrayInputStream, SYSTEM_ID);
        }
        catch (SAXException sAXException) {
            throw new ExtractorException(sAXException);
        }
        catch (IOException iOException) {
            throw new ExtractorException(iOException);
        }
        String string = contentExtractor.getContents();
        if (string != null && !string.equals("")) {
            rDFContainer.add(NIE.plainTextContent, string);
        }
    }

    private void extractMetadata(byte[] byArray, RDFContainer rDFContainer) throws ExtractorException {
        Document document;
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("unable to instantiate DocumentBuilder", parserConfigurationException);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            document = documentBuilder.parse(byteArrayInputStream, SYSTEM_ID);
        }
        catch (SAXException sAXException) {
            throw new ExtractorException(sAXException);
        }
        catch (IOException iOException) {
            throw new ExtractorException(iOException);
        }
        Element element = document.getDocumentElement();
        org.w3c.dom.Node node = element.getFirstChild();
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            org.w3c.dom.Node node2 = nodeList.item(i);
            this.addOasisMetadataPropertyToRdfContainer(node2, rDFContainer);
            this.mapToApertureProperty(node2, rDFContainer);
        }
    }

    private void addOasisMetadataPropertyToRdfContainer(org.w3c.dom.Node node, RDFContainer rDFContainer) {
        String string = node.getNamespaceURI();
        if (string != null) {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            try {
                String string2 = string + node.getLocalName();
                String string3 = this.getText(node);
                URI uRI = rDFContainer.getValueFactory().createURI(string2);
                if (string3 != null) {
                    rDFContainer.add(uRI, string3);
                }
            }
            catch (ModelException modelException) {
                this.logger.error("ModelException while adding statement, ignoring", (Throwable)modelException);
            }
        }
    }

    private String getText(org.w3c.dom.Node node) {
        if (node instanceof Attr) {
            return ((Attr)node).getValue();
        }
        org.w3c.dom.Node node2 = node.getFirstChild();
        if (node2 instanceof Text) {
            return ((Text)node2).getWholeText();
        }
        return null;
    }

    private void mapToApertureProperty(org.w3c.dom.Node node, RDFContainer rDFContainer) {
        block3: {
            NamedNodeMap namedNodeMap;
            String string;
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block6: {
                                                block5: {
                                                    block4: {
                                                        block2: {
                                                            string = node.getNodeName();
                                                            if (!"dc:creator".equals(string)) break block2;
                                                            this.addContactStatement(NCO.creator, node.getFirstChild().getNodeValue(), rDFContainer);
                                                            break block3;
                                                        }
                                                        if (!"meta:initial-creator".equals(string)) break block4;
                                                        this.addContactStatement(NCO.creator, node.getFirstChild().getNodeValue(), rDFContainer);
                                                        break block3;
                                                    }
                                                    if (!"dc:title".equals(string)) break block5;
                                                    this.addStatement(NIE.title, node.getFirstChild(), rDFContainer);
                                                    break block3;
                                                }
                                                if (!"dc:description".equals(string)) break block6;
                                                this.addStatement(NIE.description, node.getFirstChild(), rDFContainer);
                                                break block3;
                                            }
                                            if (!"dc:subject".equals(string)) break block7;
                                            this.addStatement(NIE.subject, node.getFirstChild(), rDFContainer);
                                            break block3;
                                        }
                                        if (!"dc:date".equals(string)) break block8;
                                        this.addDateStatement(NIE.informationElementDate, node.getFirstChild(), rDFContainer);
                                        break block3;
                                    }
                                    if (!"meta:creation-date".equals(string)) break block9;
                                    this.addDateStatement(NIE.contentCreated, node.getFirstChild(), rDFContainer);
                                    break block3;
                                }
                                if (!"meta:print-date".equals(string)) break block10;
                                this.addDateStatement(NIE.informationElementDate, node.getFirstChild(), rDFContainer);
                                break block3;
                            }
                            if (!"dc:language".equals(string)) break block11;
                            this.addStatement(NIE.language, node.getFirstChild(), rDFContainer);
                            break block3;
                        }
                        if (!"meta:generator".equals(string)) break block12;
                        this.addStatement(NIE.generator, node.getFirstChild(), rDFContainer);
                        break block3;
                    }
                    if ("meta:user-defined".equals(string)) break block3;
                    if (!"meta:keywords".equals(string)) break block13;
                    NodeList nodeList = node.getChildNodes();
                    int n = nodeList.getLength();
                    for (int i = 0; i < n; ++i) {
                        org.w3c.dom.Node node2 = nodeList.item(i);
                        if (!"meta:keyword".equals(node2.getNodeName())) continue;
                        this.addStatement(NIE.keyword, node2.getFirstChild(), rDFContainer);
                    }
                    break block3;
                }
                if (!"meta:keyword".equals(string)) break block14;
                this.addStatement(NIE.keyword, node.getFirstChild(), rDFContainer);
                break block3;
            }
            if (!"meta:document-statistic".equals(string) || (namedNodeMap = node.getAttributes()) == null) break block3;
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                org.w3c.dom.Node node3 = namedNodeMap.item(i);
                this.addOasisMetadataPropertyToRdfContainer(node3, rDFContainer);
                if (!(node3 instanceof Attr)) continue;
                this.mapStatisticsAttributeToApertureProperty((Attr)node3, rDFContainer);
            }
        }
    }

    private void mapStatisticsAttributeToApertureProperty(Attr attr, RDFContainer rDFContainer) {
        String string;
        String string2 = attr.getNodeName();
        if ("meta:page-count".equals(string2) && (string = attr.getValue()) != null) {
            try {
                int n = Integer.parseInt(string);
                rDFContainer.add(RDF.type, (Node)NFO.PaginatedTextDocument);
                rDFContainer.add(NFO.pageCount, n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void addStatement(URI uRI, org.w3c.dom.Node node, RDFContainer rDFContainer) {
        if (node != null) {
            this.addStatement(uRI, node.getNodeValue(), rDFContainer);
        }
    }

    private void addStatement(URI uRI, String string, RDFContainer rDFContainer) {
        if (string != null) {
            rDFContainer.add(uRI, string);
        }
    }

    private void addDateStatement(URI uRI, org.w3c.dom.Node node, RDFContainer rDFContainer) {
        String string;
        if (node != null && (string = node.getNodeValue()) != null) {
            try {
                Date date = DateUtil.string2DateTime(string);
                rDFContainer.add(uRI, date);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private void addContactStatement(URI uRI, String string, RDFContainer rDFContainer) {
        Model model = rDFContainer.getModel();
        Resource resource = UriUtil.generateRandomResource(model);
        model.addStatement(resource, RDF.type, (Node)NCO.Contact);
        model.addStatement(resource, NCO.fullname, string);
        rDFContainer.add(uRI, (Node)resource);
    }

    private static class ContentExtractor
    extends SimpleSAXAdapter {
        private static final String OFFICE_BODY = "office:body";
        private static final String MATH_MATH = "math:math";
        private static final String TEXT_P = "text:p";
        private static final String TEXT_H = "text:h";
        private StringBuilder contents = new StringBuilder(4096);
        private boolean insideBody = false;

        private ContentExtractor() {
        }

        public String getContents() {
            return this.contents.toString();
        }

        public void startTag(String string, Map map, String string2) {
            if (OFFICE_BODY.equals(string) || MATH_MATH.equals(string)) {
                this.insideBody = true;
            } else if (this.insideBody && string2.length() > 0) {
                if (TEXT_H.equals(string) && this.contents.length() > 0) {
                    this.contents.append(END_OF_LINE);
                    this.contents.append(END_OF_LINE);
                }
                this.contents.append(string2);
                if (TEXT_P.equals(string)) {
                    this.contents.append(END_OF_LINE);
                } else if (TEXT_H.equals(string)) {
                    this.contents.append(END_OF_LINE);
                    this.contents.append(END_OF_LINE);
                } else {
                    this.contents.append(' ');
                }
            }
        }

        public void endTag(String string) {
            if (OFFICE_BODY.equals(string) || MATH_MATH.equals(string)) {
                this.insideBody = false;
            }
        }
    }
}

