/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.util.StringExtractor;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.UriUtil;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;

public class PoiUtil {
    private static final String BUFFER_SIZE_PROPERTY = "aperture.poiUtil.bufferSize";
    private static final int DEFAULT_BUFFER_SIZE = 0x400000;

    public static SummaryInformation getSummaryInformation(POIFSFileSystem pOIFSFileSystem) {
        SummaryInformation summaryInformation = null;
        try {
            DocumentInputStream documentInputStream = pOIFSFileSystem.createDocumentInputStream("\u0005SummaryInformation");
            summaryInformation = (SummaryInformation)PropertySetFactory.create((InputStream)documentInputStream);
            documentInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return summaryInformation;
    }

    public static InputStream extractMetadata(InputStream inputStream, boolean bl, RDFContainer rDFContainer) throws IOException {
        if (bl) {
            int n = PoiUtil.getBufferSize();
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream, n);
            }
            inputStream.mark(n);
        }
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(inputStream);
        PoiUtil.extractMetadata(pOIFSFileSystem, rDFContainer);
        if (bl) {
            inputStream.reset();
        }
        return inputStream;
    }

    public static void extractMetadata(POIFSFileSystem pOIFSFileSystem, RDFContainer rDFContainer) {
        SummaryInformation summaryInformation = PoiUtil.getSummaryInformation(pOIFSFileSystem);
        if (summaryInformation != null) {
            String string;
            PoiUtil.copyString(summaryInformation.getTitle(), NIE.title, rDFContainer);
            PoiUtil.copyString(summaryInformation.getSubject(), NIE.subject, rDFContainer);
            PoiUtil.copyString(summaryInformation.getComments(), NIE.description, rDFContainer);
            PoiUtil.copyString(summaryInformation.getApplicationName(), NIE.generator, rDFContainer);
            PoiUtil.copyContact(summaryInformation.getAuthor(), NCO.creator, rDFContainer);
            PoiUtil.copyContact(summaryInformation.getLastAuthor(), NCO.contributor, rDFContainer);
            PoiUtil.copyDate(summaryInformation.getCreateDateTime(), NIE.contentCreated, rDFContainer);
            PoiUtil.copyDate(summaryInformation.getLastSaveDateTime(), NIE.contentLastModified, rDFContainer);
            int n = summaryInformation.getPageCount();
            if (n > 1) {
                rDFContainer.add(RDF.type, (Node)NFO.PaginatedTextDocument);
                rDFContainer.add(NFO.pageCount, n);
            }
            if ((string = summaryInformation.getKeywords()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t.,;|/\\", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    rDFContainer.add(NIE.keyword, string2);
                }
            }
        }
    }

    private static void copyString(String string, URI uRI, RDFContainer rDFContainer) {
        if (string != null && !(string = string.trim()).equals("")) {
            rDFContainer.add(uRI, string);
        }
    }

    private static void copyDate(Date date, URI uRI, RDFContainer rDFContainer) {
        if (date != null) {
            rDFContainer.add(uRI, date);
        }
    }

    private static void copyContact(String string, URI uRI, RDFContainer rDFContainer) {
        if (string != null) {
            Model model = rDFContainer.getModel();
            Resource resource = UriUtil.generateRandomResource(model);
            model.addStatement((Resource)rDFContainer.getDescribedUri(), uRI, (Node)resource);
            model.addStatement(resource, RDF.type, (Node)NCO.Contact);
            model.addStatement(resource, NCO.fullname, string);
        }
    }

    public static InputStream extractAll(InputStream inputStream, TextExtractor textExtractor, RDFContainer rDFContainer, Logger logger) {
        Object object;
        int n = PoiUtil.getBufferSize();
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream, n);
        }
        inputStream.mark(n);
        String string = null;
        try {
            object = new POIFSFileSystem(inputStream);
            try {
                if (textExtractor != null) {
                    string = textExtractor.getText((POIFSFileSystem)object);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            PoiUtil.extractMetadata((POIFSFileSystem)object, rDFContainer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string == null) {
            if (textExtractor != null) {
                logger.info("regular POI-based processing failed, falling back to heuristic string extraction for " + rDFContainer.getDescribedUri());
            }
            try {
                inputStream.reset();
                object = new StringExtractor();
                string = ((StringExtractor)object).extract(inputStream);
            }
            catch (IOException iOException) {
                logger.warn("IOException while processing " + rDFContainer.getDescribedUri(), (Throwable)iOException);
            }
        }
        if (string != null && !(string = string.trim()).equals("")) {
            rDFContainer.add(NIE.plainTextContent, string);
        }
        try {
            inputStream.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inputStream;
    }

    private static int getBufferSize() {
        int n = 0x400000;
        String string = System.getProperty(BUFFER_SIZE_PROPERTY);
        if (string != null && !string.equals("")) {
            n = Integer.parseInt(string);
        }
        if (n < 0) {
            throw new IllegalArgumentException("Negative buffer sizes not allowed: " + n);
        }
        return n;
    }

    public static interface TextExtractor {
        public String getText(POIFSFileSystem var1) throws IOException;
    }
}

