/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.word;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.util.PoiUtil;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordExtractor
implements Extractor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void extract(URI uRI, InputStream inputStream, Charset charset, String string, RDFContainer rDFContainer) throws ExtractorException {
        PoiUtil.extractAll(inputStream, new WordTextExtractor(), rDFContainer, this.logger);
        rDFContainer.add(RDF.type, (Node)NFO.PaginatedTextDocument);
    }

    private static class WordTextExtractor
    implements PoiUtil.TextExtractor {
        private WordTextExtractor() {
        }

        public String getText(POIFSFileSystem pOIFSFileSystem) throws IOException {
            org.apache.poi.hwpf.extractor.WordExtractor wordExtractor = new org.apache.poi.hwpf.extractor.WordExtractor(pOIFSFileSystem);
            return wordExtractor.getText().trim();
        }
    }
}

