/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.IMethodExecutor;
import net.sf.webdav.IMimeTyper;
import net.sf.webdav.ITransaction;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.exceptions.UnauthenticatedException;
import net.sf.webdav.exceptions.WebdavException;
import net.sf.webdav.fromcatalina.MD5Encoder;
import net.sf.webdav.locking.ResourceLocks;
import net.sf.webdav.methods.DoCopy;
import net.sf.webdav.methods.DoDelete;
import net.sf.webdav.methods.DoGet;
import net.sf.webdav.methods.DoHead;
import net.sf.webdav.methods.DoLock;
import net.sf.webdav.methods.DoMkcol;
import net.sf.webdav.methods.DoMove;
import net.sf.webdav.methods.DoNotImplemented;
import net.sf.webdav.methods.DoOptions;
import net.sf.webdav.methods.DoPropfind;
import net.sf.webdav.methods.DoProppatch;
import net.sf.webdav.methods.DoPut;
import net.sf.webdav.methods.DoUnlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDavServletBean
extends HttpServlet {
    private static Logger LOG = LoggerFactory.getLogger(WebDavServletBean.class);
    protected static MessageDigest MD5_HELPER;
    protected static final MD5Encoder MD5_ENCODER;
    private static final boolean READ_ONLY = false;
    private ResourceLocks _resLocks;
    private IWebdavStore _store;
    private HashMap<String, IMethodExecutor> _methodMap = new HashMap();

    public WebDavServletBean() {
        this._resLocks = new ResourceLocks();
        try {
            MD5_HELPER = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException();
        }
    }

    public void init(IWebdavStore store, String dftIndexFile, String insteadOf404, int nocontentLenghHeaders, boolean lazyFolderCreationOnPut) throws ServletException {
        this._store = store;
        IMimeTyper mimeTyper = new IMimeTyper(){

            public String getMimeType(String path) {
                return WebDavServletBean.this.getServletContext().getMimeType(path);
            }
        };
        this.register("GET", new DoGet(store, dftIndexFile, insteadOf404, this._resLocks, mimeTyper, nocontentLenghHeaders));
        this.register("HEAD", new DoHead(store, dftIndexFile, insteadOf404, this._resLocks, mimeTyper, nocontentLenghHeaders));
        DoDelete doDelete = (DoDelete)this.register("DELETE", new DoDelete(store, this._resLocks, false));
        DoCopy doCopy = (DoCopy)this.register("COPY", new DoCopy(store, this._resLocks, doDelete, false));
        this.register("LOCK", new DoLock(store, this._resLocks, false));
        this.register("UNLOCK", new DoUnlock(store, this._resLocks, false));
        this.register("MOVE", new DoMove(this._resLocks, doDelete, doCopy, false));
        this.register("MKCOL", new DoMkcol(store, this._resLocks, false));
        this.register("OPTIONS", new DoOptions(store, this._resLocks));
        this.register("PUT", new DoPut(store, this._resLocks, false, lazyFolderCreationOnPut));
        this.register("PROPFIND", new DoPropfind(store, this._resLocks, mimeTyper));
        this.register("PROPPATCH", new DoProppatch(store, this._resLocks, false));
        this.register("*NO*IMPL*", new DoNotImplemented(false));
    }

    private IMethodExecutor register(String methodName, IMethodExecutor method) {
        this._methodMap.put(methodName, method);
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String methodName = req.getMethod();
        ITransaction transaction = null;
        boolean needRollback = false;
        if (LOG.isTraceEnabled()) {
            this.debugRequest(methodName, req);
        }
        try {
            Principal userPrincipal = req.getUserPrincipal();
            transaction = this._store.begin(userPrincipal);
            needRollback = true;
            this._store.checkAuthentication(transaction);
            resp.setStatus(200);
            try {
                IMethodExecutor methodExecutor = this._methodMap.get(methodName);
                if (methodExecutor == null) {
                    methodExecutor = this._methodMap.get("*NO*IMPL*");
                }
                methodExecutor.execute(transaction, req, resp);
                this._store.commit(transaction);
                needRollback = false;
            }
            catch (IOException e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                LOG.error("IOException: " + sw.toString());
                resp.sendError(500);
                this._store.rollback(transaction);
                throw new ServletException((Throwable)e);
            }
        }
        catch (UnauthenticatedException e) {
            resp.sendError(403);
        }
        catch (WebdavException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            LOG.error("WebdavException: " + sw.toString());
            throw new ServletException((Throwable)e);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            LOG.error("Exception: " + sw.toString());
        }
        finally {
            if (needRollback) {
                this._store.rollback(transaction);
            }
        }
    }

    private void debugRequest(String methodName, HttpServletRequest req) {
        String s;
        LOG.trace("-----------");
        LOG.trace("WebdavServlet\n request: methodName = " + methodName);
        LOG.trace("time: " + System.currentTimeMillis());
        LOG.trace("path: " + req.getRequestURI());
        LOG.trace("-----------");
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            LOG.trace("header: " + s + " " + req.getHeader(s));
        }
        e = req.getAttributeNames();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            LOG.trace("attribute: " + s + " " + req.getAttribute(s));
        }
        e = req.getParameterNames();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            LOG.trace("parameter: " + s + " " + req.getParameter(s));
        }
    }

    static {
        MD5_ENCODER = new MD5Encoder();
    }
}

