/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.methods;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.IMimeTyper;
import net.sf.webdav.ITransaction;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.StoredObject;
import net.sf.webdav.WebdavStatus;
import net.sf.webdav.exceptions.AccessDeniedException;
import net.sf.webdav.exceptions.LockFailedException;
import net.sf.webdav.exceptions.WebdavException;
import net.sf.webdav.fromcatalina.XMLHelper;
import net.sf.webdav.fromcatalina.XMLWriter;
import net.sf.webdav.locking.LockedObject;
import net.sf.webdav.locking.ResourceLocks;
import net.sf.webdav.methods.AbstractMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoPropfind
extends AbstractMethod {
    private static Logger LOG = LoggerFactory.getLogger(DoPropfind.class);
    private static final int FIND_BY_PROPERTY = 0;
    private static final int FIND_ALL_PROP = 1;
    private static final int FIND_PROPERTY_NAMES = 2;
    private IWebdavStore _store;
    private ResourceLocks _resourceLocks;
    private IMimeTyper _mimeTyper;
    private int _depth;

    public DoPropfind(IWebdavStore store, ResourceLocks resLocks, IMimeTyper mimeTyper) {
        this._store = store;
        this._resourceLocks = resLocks;
        this._mimeTyper = mimeTyper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        DoPropfind.LOG.trace("-- " + this.getClass().getName());
        path = this.getCleanPath(this.getRelativePath(req));
        tempLockOwner = "doPropfind" + System.currentTimeMillis() + req.toString();
        this._depth = this.getDepth(req);
        if (this._resourceLocks.lock(transaction, path, tempLockOwner, false, this._depth, 10, true)) {
            so = null;
            try {
                so = this._store.getStoredObject(transaction, path);
                if (so == null) {
                    resp.setContentType("text/xml; charset=UTF-8");
                    resp.sendError(404, req.getRequestURI());
                    return;
                }
                properties = null;
                path = this.getCleanPath(this.getRelativePath(req));
                propertyFindType = 1;
                propNode = null;
                if (req.getContentLength() > 0) {
                    documentBuilder = this.getDocumentBuilder();
                    try {
                        document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
                        rootElement = document.getDocumentElement();
                        propNode = XMLHelper.findSubElement(rootElement, "prop");
                        if (propNode != null) {
                            propertyFindType = 0;
                        }
                        if (XMLHelper.findSubElement(rootElement, "propname") != null) {
                            propertyFindType = 2;
                        }
                        if (XMLHelper.findSubElement(rootElement, "allprop") == null) ** GOTO lbl37
                        propertyFindType = 1;
                    }
                    catch (Exception e) {
                        resp.sendError(500);
                        this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                        return;
                    }
                } else {
                    propertyFindType = 1;
                }
lbl37:
                // 5 sources

                namespaces = new HashMap<String, String>();
                namespaces.put("DAV:", "D");
                if (propertyFindType == 0) {
                    propertyFindType = 0;
                    properties = XMLHelper.getPropertiesFromXML(propNode);
                }
                resp.setStatus(207);
                resp.setContentType("text/xml; charset=UTF-8");
                generatedXML = new XMLWriter(resp.getWriter(), namespaces);
                generatedXML.writeXMLHeader();
                generatedXML.writeElement("DAV::multistatus", 0);
                if (this._depth == 0) {
                    this.parseProperties(transaction, req, generatedXML, path, propertyFindType, properties, this._mimeTyper.getMimeType(path));
                } else {
                    this.recursiveParseProperties(transaction, path, req, generatedXML, propertyFindType, properties, this._depth, this._mimeTyper.getMimeType(path));
                }
                generatedXML.writeElement("DAV::multistatus", 1);
                generatedXML.sendData();
            }
            catch (AccessDeniedException e) {
                resp.sendError(403);
            }
            catch (WebdavException e) {
                DoPropfind.LOG.warn("Sending internal error!");
                resp.sendError(500);
            }
            catch (ServletException e) {
                e.printStackTrace();
            }
            finally {
                this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
            }
        } else {
            errorList = new Hashtable<String, Integer>();
            errorList.put(path, 423);
            this.sendReport(req, resp, errorList);
        }
    }

    private void recursiveParseProperties(ITransaction transaction, String currentPath, HttpServletRequest req, XMLWriter generatedXML, int propertyFindType, List<String> properties, int depth, String mimeType) throws WebdavException {
        this.parseProperties(transaction, req, generatedXML, currentPath, propertyFindType, properties, mimeType);
        if (depth > 0) {
            String[] names = this._store.getChildrenNames(transaction, currentPath);
            names = names == null ? new String[]{} : names;
            String newPath = null;
            for (String name : names) {
                newPath = currentPath;
                if (!newPath.endsWith("/")) {
                    newPath = newPath + "/";
                }
                newPath = newPath + name;
                this.recursiveParseProperties(transaction, newPath, req, generatedXML, propertyFindType, properties, depth - 1, mimeType);
            }
        }
    }

    private void parseProperties(ITransaction transaction, HttpServletRequest req, XMLWriter generatedXML, String path, int type, List<String> propertiesVector, String mimeType) throws WebdavException {
        StoredObject so = this._store.getStoredObject(transaction, path);
        boolean isFolder = so.isFolder();
        String creationdate = CREATION_DATE_FORMAT.format(so.getCreationDate());
        String lastModified = LAST_MODIFIED_DATE_FORMAT.format(so.getLastModified());
        String resourceLength = String.valueOf(so.getResourceLength());
        generatedXML.writeElement("DAV::response", 0);
        String status = new String("HTTP/1.1 200 " + WebdavStatus.getStatusText(200));
        generatedXML.writeElement("DAV::href", 0);
        String href = req.getContextPath();
        String servletPath = req.getServletPath();
        if (servletPath != null) {
            href = href.endsWith("/") && servletPath.startsWith("/") ? href + servletPath.substring(1) : href + servletPath;
        }
        href = href.endsWith("/") && path.startsWith("/") ? href + path.substring(1) : href + path;
        if (isFolder && !href.endsWith("/")) {
            href = href + "/";
        }
        generatedXML.writeText(this.rewriteUrl(href));
        generatedXML.writeElement("DAV::href", 1);
        String resourceName = path;
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash != -1) {
            resourceName = resourceName.substring(lastSlash + 1);
        }
        switch (type) {
            case 1: {
                generatedXML.writeElement("DAV::propstat", 0);
                generatedXML.writeElement("DAV::prop", 0);
                generatedXML.writeProperty("DAV::creationdate", creationdate);
                generatedXML.writeElement("DAV::displayname", 0);
                generatedXML.writeData(resourceName);
                generatedXML.writeElement("DAV::displayname", 1);
                if (!isFolder) {
                    generatedXML.writeProperty("DAV::getlastmodified", lastModified);
                    generatedXML.writeProperty("DAV::getcontentlength", resourceLength);
                    String contentType = mimeType;
                    if (contentType != null) {
                        generatedXML.writeProperty("DAV::getcontenttype", contentType);
                    }
                    generatedXML.writeProperty("DAV::getetag", this.getETag(so));
                    generatedXML.writeElement("DAV::resourcetype", 2);
                } else {
                    generatedXML.writeElement("DAV::resourcetype", 0);
                    generatedXML.writeElement("DAV::collection", 2);
                    generatedXML.writeElement("DAV::resourcetype", 1);
                }
                this.writeSupportedLockElements(transaction, generatedXML, path);
                this.writeLockDiscoveryElements(transaction, generatedXML, path);
                generatedXML.writeProperty("DAV::source", "");
                generatedXML.writeElement("DAV::prop", 1);
                generatedXML.writeElement("DAV::status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("DAV::status", 1);
                generatedXML.writeElement("DAV::propstat", 1);
                break;
            }
            case 2: {
                generatedXML.writeElement("DAV::propstat", 0);
                generatedXML.writeElement("DAV::prop", 0);
                generatedXML.writeElement("DAV::creationdate", 2);
                generatedXML.writeElement("DAV::displayname", 2);
                if (!isFolder) {
                    generatedXML.writeElement("DAV::getcontentlanguage", 2);
                    generatedXML.writeElement("DAV::getcontentlength", 2);
                    generatedXML.writeElement("DAV::getcontenttype", 2);
                    generatedXML.writeElement("DAV::getetag", 2);
                    generatedXML.writeElement("DAV::getlastmodified", 2);
                }
                generatedXML.writeElement("DAV::resourcetype", 2);
                generatedXML.writeElement("DAV::supportedlock", 2);
                generatedXML.writeElement("DAV::source", 2);
                generatedXML.writeElement("DAV::prop", 1);
                generatedXML.writeElement("DAV::status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("DAV::status", 1);
                generatedXML.writeElement("DAV::propstat", 1);
                break;
            }
            case 0: {
                ArrayList<String> propertiesNotFound = new ArrayList<String>();
                generatedXML.writeElement("DAV::propstat", 0);
                generatedXML.writeElement("DAV::prop", 0);
                for (String property : propertiesVector) {
                    if (property.equals("DAV::creationdate")) {
                        generatedXML.writeProperty("DAV::creationdate", creationdate);
                        continue;
                    }
                    if (property.equals("DAV::displayname")) {
                        generatedXML.writeElement("DAV::displayname", 0);
                        generatedXML.writeData(resourceName);
                        generatedXML.writeElement("DAV::displayname", 1);
                        continue;
                    }
                    if (property.equals("DAV::getcontentlanguage")) {
                        if (isFolder) {
                            propertiesNotFound.add(property);
                            continue;
                        }
                        generatedXML.writeElement("DAV::getcontentlanguage", 2);
                        continue;
                    }
                    if (property.equals("DAV::getcontentlength")) {
                        if (isFolder) {
                            propertiesNotFound.add(property);
                            continue;
                        }
                        generatedXML.writeProperty("DAV::getcontentlength", resourceLength);
                        continue;
                    }
                    if (property.equals("DAV::getcontenttype")) {
                        if (isFolder) {
                            propertiesNotFound.add(property);
                            continue;
                        }
                        generatedXML.writeProperty("DAV::getcontenttype", mimeType);
                        continue;
                    }
                    if (property.equals("DAV::getetag")) {
                        if (isFolder || so.isNullResource()) {
                            propertiesNotFound.add(property);
                            continue;
                        }
                        generatedXML.writeProperty("DAV::getetag", this.getETag(so));
                        continue;
                    }
                    if (property.equals("DAV::getlastmodified")) {
                        if (isFolder) {
                            propertiesNotFound.add(property);
                            continue;
                        }
                        generatedXML.writeProperty("DAV::getlastmodified", lastModified);
                        continue;
                    }
                    if (property.equals("DAV::resourcetype")) {
                        if (isFolder) {
                            generatedXML.writeElement("DAV::resourcetype", 0);
                            generatedXML.writeElement("DAV::collection", 2);
                            generatedXML.writeElement("DAV::resourcetype", 1);
                            continue;
                        }
                        generatedXML.writeElement("DAV::resourcetype", 2);
                        continue;
                    }
                    if (property.equals("DAV::source")) {
                        generatedXML.writeProperty("DAV::source", "");
                        continue;
                    }
                    if (property.equals("DAV::supportedlock")) {
                        this.writeSupportedLockElements(transaction, generatedXML, path);
                        continue;
                    }
                    if (property.equals("DAV::lockdiscovery")) {
                        this.writeLockDiscoveryElements(transaction, generatedXML, path);
                        continue;
                    }
                    propertiesNotFound.add(property);
                }
                generatedXML.writeElement("DAV::prop", 1);
                generatedXML.writeElement("DAV::status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("DAV::status", 1);
                generatedXML.writeElement("DAV::propstat", 1);
                Iterator propertiesNotFoundList = propertiesNotFound.iterator();
                if (!propertiesNotFoundList.hasNext()) break;
                status = new String("HTTP/1.1 404 " + WebdavStatus.getStatusText(404));
                generatedXML.writeElement("DAV::propstat", 0);
                generatedXML.writeElement("DAV::prop", 0);
                while (propertiesNotFoundList.hasNext()) {
                    generatedXML.writeElement((String)propertiesNotFoundList.next(), 2);
                }
                generatedXML.writeElement("DAV::prop", 1);
                generatedXML.writeElement("DAV::status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("DAV::status", 1);
                generatedXML.writeElement("DAV::propstat", 1);
            }
        }
        generatedXML.writeElement("DAV::response", 1);
        so = null;
    }

    private void writeSupportedLockElements(ITransaction transaction, XMLWriter generatedXML, String path) {
        LockedObject lo = this._resourceLocks.getLockedObjectByPath(transaction, path);
        generatedXML.writeElement("DAV::supportedlock", 0);
        if (lo == null) {
            generatedXML.writeElement("DAV::lockentry", 0);
            generatedXML.writeElement("DAV::lockscope", 0);
            generatedXML.writeElement("DAV::exclusive", 2);
            generatedXML.writeElement("DAV::lockscope", 1);
            generatedXML.writeElement("DAV::locktype", 0);
            generatedXML.writeElement("DAV::write", 2);
            generatedXML.writeElement("DAV::locktype", 1);
            generatedXML.writeElement("DAV::lockentry", 1);
            generatedXML.writeElement("DAV::lockentry", 0);
            generatedXML.writeElement("DAV::lockscope", 0);
            generatedXML.writeElement("DAV::shared", 2);
            generatedXML.writeElement("DAV::lockscope", 1);
            generatedXML.writeElement("DAV::locktype", 0);
            generatedXML.writeElement("DAV::write", 2);
            generatedXML.writeElement("DAV::locktype", 1);
            generatedXML.writeElement("DAV::lockentry", 1);
        } else if (lo.isShared()) {
            generatedXML.writeElement("DAV::lockentry", 0);
            generatedXML.writeElement("DAV::lockscope", 0);
            generatedXML.writeElement("DAV::shared", 2);
            generatedXML.writeElement("DAV::lockscope", 1);
            generatedXML.writeElement("DAV::locktype", 0);
            generatedXML.writeElement("DAV::" + lo.getType(), 2);
            generatedXML.writeElement("DAV::locktype", 1);
            generatedXML.writeElement("DAV::lockentry", 1);
        }
        generatedXML.writeElement("DAV::supportedlock", 1);
        lo = null;
    }

    private void writeLockDiscoveryElements(ITransaction transaction, XMLWriter generatedXML, String path) {
        LockedObject lo = this._resourceLocks.getLockedObjectByPath(transaction, path);
        if (lo != null && !lo.hasExpired()) {
            generatedXML.writeElement("DAV::lockdiscovery", 0);
            generatedXML.writeElement("DAV::activelock", 0);
            generatedXML.writeElement("DAV::locktype", 0);
            generatedXML.writeProperty("DAV::" + lo.getType());
            generatedXML.writeElement("DAV::locktype", 1);
            generatedXML.writeElement("DAV::lockscope", 0);
            if (lo.isExclusive()) {
                generatedXML.writeProperty("DAV::exclusive");
            } else {
                generatedXML.writeProperty("DAV::shared");
            }
            generatedXML.writeElement("DAV::lockscope", 1);
            generatedXML.writeElement("DAV::depth", 0);
            if (this._depth == 3) {
                generatedXML.writeText("Infinity");
            } else {
                generatedXML.writeText(String.valueOf(this._depth));
            }
            generatedXML.writeElement("DAV::depth", 1);
            String[] owners = lo.getOwner();
            if (owners != null) {
                for (int i = 0; i < owners.length; ++i) {
                    generatedXML.writeElement("DAV::owner", 0);
                    generatedXML.writeElement("DAV::href", 0);
                    generatedXML.writeText(owners[i]);
                    generatedXML.writeElement("DAV::href", 1);
                    generatedXML.writeElement("DAV::owner", 1);
                }
            } else {
                generatedXML.writeElement("DAV::owner", 2);
            }
            int timeout = (int)(lo.getTimeoutMillis() / 1000L);
            String timeoutStr = new Integer(timeout).toString();
            generatedXML.writeElement("DAV::timeout", 0);
            generatedXML.writeText("Second-" + timeoutStr);
            generatedXML.writeElement("DAV::timeout", 1);
            String lockToken = lo.getID();
            generatedXML.writeElement("DAV::locktoken", 0);
            generatedXML.writeElement("DAV::href", 0);
            generatedXML.writeText("opaquelocktoken:" + lockToken);
            generatedXML.writeElement("DAV::href", 1);
            generatedXML.writeElement("DAV::locktoken", 1);
            generatedXML.writeElement("DAV::activelock", 1);
            generatedXML.writeElement("DAV::lockdiscovery", 1);
        } else {
            generatedXML.writeElement("DAV::lockdiscovery", 2);
        }
        lo = null;
    }
}

