/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.util.List;
import java.util.UUID;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.base.NodeCachingWorkspace;
import org.modeshape.graph.connector.base.PathNode;
import org.modeshape.graph.connector.base.Workspace;
import org.modeshape.graph.connector.base.cache.PathNodeCache;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public abstract class PathWorkspace<NodeType extends PathNode>
implements Workspace {
    private final String name;
    private final UUID rootNodeUuid;
    protected final PathFactory pathFactory;

    public PathWorkspace(ExecutionContext context, String name, UUID rootNodeUuid) {
        this.name = name;
        this.rootNodeUuid = rootNodeUuid;
        assert (this.name != null);
        assert (this.rootNodeUuid != null);
        assert (context != null);
        this.pathFactory = context.getValueFactories().getPathFactory();
    }

    public PathWorkspace(String name, PathWorkspace<NodeType> originalToClone) {
        this.name = name;
        this.rootNodeUuid = ((PathNode)originalToClone.getRootNode()).getUuid();
        this.pathFactory = originalToClone.pathFactory;
        assert (this.name != null);
        assert (this.rootNodeUuid != null);
        throw new UnsupportedOperationException("Need to implement the ability to clone a workspace");
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected UUID getRootNodeUuid() {
        return this.rootNodeUuid;
    }

    public abstract NodeType getRootNode();

    public abstract NodeType getNode(Path var1);

    public Location verifyNodeExists(Path path) {
        NodeType node = this.getNode(path);
        return node != null ? Location.create(path) : null;
    }

    public NodeType putNode(NodeType node) {
        throw new UnsupportedOperationException();
    }

    public NodeType moveNode(NodeType source, NodeType target) {
        throw new UnsupportedOperationException();
    }

    public NodeType removeNode(Path path) {
        throw new UnsupportedOperationException();
    }

    public void removeAll() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean hasNodeCache() {
        return false;
    }

    public void commit(List<ChangeCommand<NodeType>> commands) {
        for (ChangeCommand<NodeType> command : commands) {
            command.apply();
        }
    }

    public ChangeCommand<NodeType> createPutCommand(NodeType oldNode, NodeType node) {
        return new PutCommand(this, node);
    }

    public ChangeCommand<NodeType> createRemoveCommand(Path path) {
        return new RemoveCommand(path);
    }

    public ChangeCommand<NodeType> createMoveCommand(NodeType source, NodeType target) {
        return new MoveCommand(this, source, target);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MoveCommand
    implements ChangeCommand<NodeType> {
        private NodeType node;
        private NodeType newNode;
        final /* synthetic */ PathWorkspace this$0;

        protected MoveCommand(NodeType node, NodeType newNode) {
            this.this$0 = var1_1;
            this.node = node;
            this.newNode = newNode;
        }

        @Override
        public void apply() {
            this.this$0.moveNode(this.node, this.newNode);
            if (this.this$0.hasNodeCache()) {
                Path path = this.this$0.pathFactory.create(((PathNode)this.node).getParent(), ((PathNode)this.node).getName());
                PathNodeCache cache = (PathNodeCache)((NodeCachingWorkspace)((Object)this.this$0)).getCache();
                cache.invalidate(path);
            }
        }

        public String toString() {
            return "Move: { " + this.node + " to " + this.newNode + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoveCommand
    implements ChangeCommand<NodeType> {
        private Path path;

        protected RemoveCommand(Path path) {
            this.path = path;
        }

        @Override
        public void apply() {
            PathWorkspace.this.removeNode(this.path);
            if (PathWorkspace.this.hasNodeCache()) {
                ((NodeCachingWorkspace)((Object)PathWorkspace.this)).getCache().remove(this.path);
            }
        }

        public String toString() {
            return "Remove: { " + this.path.getString() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PutCommand
    implements ChangeCommand<NodeType> {
        private NodeType node;
        final /* synthetic */ PathWorkspace this$0;

        protected PutCommand(NodeType node) {
            this.this$0 = var1_1;
            this.node = node;
        }

        @Override
        public void apply() {
            this.this$0.putNode(this.node);
            if (this.this$0.hasNodeCache()) {
                Path path = this.this$0.pathFactory.create(((PathNode)this.node).getParent(), ((PathNode)this.node).getName());
                ((NodeCachingWorkspace)((Object)this.this$0)).getCache().put(path, this.node);
            }
        }

        public String toString() {
            return "Put: { " + this.node + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ChangeCommand<NodeType extends PathNode> {
        public void apply();
    }
}

