/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa;

import java.util.Locale;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.connector.store.jpa.JpaSource;
import org.modeshape.graph.connector.RepositoryConnection;

public abstract class Model {
    private final String name;
    private final I18n description;

    protected Model(String name, I18n description) {
        CheckArg.isNotEmpty((String)name, (String)"name");
        CheckArg.isNotNull((Object)description, (String)"description");
        this.name = name;
        this.description = description;
    }

    public final String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description.text(new Object[0]);
    }

    public String getDescription(Locale locale) {
        return this.description.text(locale, new Object[0]);
    }

    public abstract RepositoryConnection createConnection(JpaSource var1);

    public abstract Class<?>[] getEntityClasses();

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Model) {
            Model that = (Model)obj;
            if (this.getName().equals(that.getName())) {
                return true;
            }
        }
        return false;
    }

    public final String toString() {
        return this.name;
    }
}

