/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.store.jpa.model.common;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.Table;
import org.hibernate.annotations.Index;
import org.modeshape.common.util.CheckArg;

@Entity
@Table(name="DNA_NAMESPACES")
@org.hibernate.annotations.Table(appliesTo="DNA_NAMESPACES", indexes={@Index(name="NS_URI_INX", columnNames={"URI"})})
@NamedQueries(value={@NamedQuery(name="NamespaceEntity.findAll", query="select ns from NamespaceEntity as ns"), @NamedQuery(name="NamespaceEntity.findByUri", query="select ns from NamespaceEntity as ns where ns.uri = ?1")})
public class NamespaceEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    @Column(name="URI", nullable=true, unique=false, length=512, updatable=false)
    private String uri;

    public NamespaceEntity() {
    }

    public NamespaceEntity(String uri) {
        this.setUri(uri);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NamespaceEntity) {
            NamespaceEntity that = (NamespaceEntity)obj;
            if (!this.id.equals(that.id)) {
                return false;
            }
            return this.uri.equals(that.uri);
        }
        return false;
    }

    public String toString() {
        return this.uri;
    }

    public static NamespaceEntity findByUri(EntityManager manager, String uri) {
        return NamespaceEntity.findByUri(manager, uri, true);
    }

    public static NamespaceEntity findByUri(EntityManager manager, String uri, boolean createIfRequired) {
        CheckArg.isNotNull((Object)manager, (String)"manager");
        CheckArg.isNotNull((Object)uri, (String)"uri");
        Query query = manager.createNamedQuery("NamespaceEntity.findByUri");
        query.setParameter(1, (Object)uri);
        query.setHint("org.hibernate.cacheable", (Object)true);
        try {
            return (NamespaceEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            if (!createIfRequired) {
                return null;
            }
            NamespaceEntity namespace = new NamespaceEntity(uri);
            manager.persist((Object)namespace);
            return namespace;
        }
    }
}

