/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.managed;

import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.util.naming.Util;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.jboss.managed.JBossManagedI18n;
import org.modeshape.jboss.managed.ManagedEngine;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jcr.api.Repositories;

public final class JNDIManagedRepositories
implements Repositories,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger((String)JNDIManagedRepositories.class.getName());
    private URL url = null;
    private transient ManagedEngine managedEngine = null;

    public void setModeshapeUrl(String url) throws Exception {
        CheckArg.isNotNull((Object)url, (String)"url");
        this.url = new URL(url);
    }

    public void start() throws NamingException {
        try {
            this.rebind();
        }
        catch (NamingException e) {
            URL url = this.url;
            String path = url != null ? url.getPath() : null;
            NamingException ne = new NamingException(JBossManagedI18n.errorBindingToJNDI.text(new Object[]{path}));
            ne.setRootCause(e);
            throw ne;
        }
    }

    public void stop() {
        this.unbind(this.url.getPath());
    }

    public void setManagedEngine(ManagedEngine engine) {
        this.managedEngine = engine;
    }

    public Repository getRepository(String repositoryName) throws RepositoryException {
        JcrEngine engine = this.managedEngine.getEngine();
        if (engine != null) {
            return engine.getRepository(repositoryName);
        }
        throw new RepositoryException(JBossManagedI18n.repositoryEngineIsNotRunning.text(new Object[0]));
    }

    public Set<String> getRepositoryNames() {
        JcrEngine engine = this.managedEngine.getEngine();
        if (engine != null) {
            try {
                return engine.getRepositoryNames();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Collections.emptySet();
    }

    private void rebind() throws NamingException {
        InitialContext ctx = new InitialContext();
        Util.rebind((Context)ctx, (String)this.url.getPath(), (Object)this);
        LOGGER.log(Logger.Level.INFO, JBossManagedI18n.logModeShapeBoundToJNDI, new Object[]{this.url.getPath()});
    }

    private void unbind(String jndiName) {
        try {
            InitialContext ctx = new InitialContext();
            Util.unbind((Context)ctx, (String)jndiName);
            LOGGER.log(Logger.Level.INFO, JBossManagedI18n.logModeShapeUnBoundToJNDI, new Object[]{jndiName});
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }
}

